/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.validation;

import com.google.common.collect.ImmutableList;
import com.nulabinc.zxcvbn.Pattern;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.Zxcvbn;
import com.nulabinc.zxcvbn.matchers.Match;
import io.lucenia.security.dlic.rest.validation.RequestContentValidator;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.Settings;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordValidator {
    private static final int MAX_LENGTH = 100;
    private static final Predicate<Match> USERNAME_SIMILARITY_CHECK = m -> m.pattern == Pattern.Dictionary && "user_inputs".equals(m.dictionaryName);
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final int minPasswordLength;
    private final java.util.regex.Pattern passwordRegexpPattern;
    private final ScoreStrength scoreStrength;
    private final Zxcvbn zxcvbn;

    private PasswordValidator(int minPasswordLength, java.util.regex.Pattern passwordRegexpPattern, ScoreStrength scoreStrength) {
        this.minPasswordLength = minPasswordLength;
        this.passwordRegexpPattern = passwordRegexpPattern;
        this.scoreStrength = scoreStrength;
        this.zxcvbn = new Zxcvbn();
    }

    public static PasswordValidator of(Settings settings) {
        String passwordRegex = settings.get("plugins.security.restapi.password_validation_regex", null);
        ScoreStrength scoreStrength = ScoreStrength.fromConfiguration(settings.get("plugins.security.restapi.password_score_based_validation_strength", ScoreStrength.STRONG.name()));
        int minPasswordLength = settings.getAsInt("plugins.security.restapi.password_min_length", Integer.valueOf(-1));
        return new PasswordValidator(minPasswordLength, !Strings.isNullOrEmpty((String)passwordRegex) ? java.util.regex.Pattern.compile(String.format("^%s$", passwordRegex)) : null, scoreStrength);
    }

    public RequestContentValidator.ValidationError validate(String username, String password) {
        if (this.minPasswordLength > 0 && password.length() < this.minPasswordLength) {
            this.logger.debug("Password is too short, the minimum required length is {}, but current length is {}", (Object)this.minPasswordLength, (Object)password.length());
            return RequestContentValidator.ValidationError.INVALID_PASSWORD_TOO_SHORT;
        }
        if (password.length() > 100) {
            this.logger.debug("Password is too long, the maximum required length is {}, but current length is {}", (Object)100, (Object)password.length());
            return RequestContentValidator.ValidationError.INVALID_PASSWORD_TOO_LONG;
        }
        if (Objects.nonNull(this.passwordRegexpPattern) && !this.passwordRegexpPattern.matcher(password).matches()) {
            this.logger.debug("Regex does not match password");
            return RequestContentValidator.ValidationError.INVALID_PASSWORD_INVALID_REGEX;
        }
        Strength strength = this.zxcvbn.measure((CharSequence)password, (List)ImmutableList.of((Object)username));
        if (strength.getScore() < this.scoreStrength.score()) {
            this.logger.debug("Password is weak the required score is {}, but current is {}", (Object)this.scoreStrength, (Object)ScoreStrength.fromScore(strength.getScore()));
            return RequestContentValidator.ValidationError.WEAK_PASSWORD;
        }
        boolean similar = strength.getSequence().stream().anyMatch(USERNAME_SIMILARITY_CHECK);
        if (similar) {
            this.logger.debug("Password is too similar to the user name {}", (Object)username);
            return RequestContentValidator.ValidationError.SIMILAR_PASSWORD;
        }
        return RequestContentValidator.ValidationError.NONE;
    }

    public static enum ScoreStrength {
        WEAK(0, "too guessable: risky password"),
        FAIR(1, "very guessable: protection from throttled online attacks"),
        GOOD(2, "somewhat guessable: protection from unthrottled online attacks"),
        STRONG(3, "safely unguessable: moderate protection from offline slow-hash scenario"),
        VERY_STRONG(4, "very unguessable: strong protection from offline slow-hash scenario");

        private final int score;
        private final String description;
        static final List<ScoreStrength> CONFIGURATION_VALUES;
        static final String EXPECTED_CONFIGURATION_VALUES;

        private ScoreStrength(int score, String description) {
            this.score = score;
            this.description = description;
        }

        public static ScoreStrength fromScore(int score) {
            for (ScoreStrength strength : ScoreStrength.values()) {
                if (strength.score != score) continue;
                return strength;
            }
            throw new IllegalArgumentException("Unknown score " + score);
        }

        public static ScoreStrength fromConfiguration(String value) {
            for (ScoreStrength strength : CONFIGURATION_VALUES) {
                if (!strength.name().equalsIgnoreCase(value)) continue;
                return strength;
            }
            throw new IllegalArgumentException(String.format("Setting [%s] cannot be used with the configured: %s. Expected one of [%s]", "plugins.security.restapi.password_score_based_validation_strength", value, EXPECTED_CONFIGURATION_VALUES));
        }

        public String toString() {
            return String.format("Password strength score %s. %s", this.score, this.description);
        }

        public int score() {
            return this.score;
        }

        static {
            CONFIGURATION_VALUES = ImmutableList.of((Object)((Object)FAIR), (Object)((Object)STRONG), (Object)((Object)VERY_STRONG));
            EXPECTED_CONFIGURATION_VALUES = new StringJoiner(",").add(FAIR.name().toLowerCase(Locale.ROOT)).add(STRONG.name().toLowerCase(Locale.ROOT)).add(VERY_STRONG.name().toLowerCase(Locale.ROOT)).toString();
        }
    }
}

