/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.filter;

import io.lucenia.security.filter.LuceniaRequest;
import io.lucenia.security.filter.SecurityRequestChannel;
import io.lucenia.security.filter.SecurityResponse;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class LuceniaRequestChannel
extends LuceniaRequest
implements SecurityRequestChannel {
    private final AtomicReference<SecurityResponse> responseRef = new AtomicReference<Object>(null);
    private final RestChannel underlyingChannel;

    LuceniaRequestChannel(RestRequest request, RestChannel channel) {
        super(request);
        this.underlyingChannel = channel;
    }

    public RestChannel breakEncapsulationForChannel() {
        return this.underlyingChannel;
    }

    @Override
    public void queueForSending(SecurityResponse response) {
        if (this.underlyingChannel == null) {
            throw new UnsupportedOperationException("Channel was not defined");
        }
        if (this.getQueuedResponse().isPresent()) {
            throw new UnsupportedOperationException("Another response was already queued");
        }
        this.responseRef.set(response);
    }

    @Override
    public Optional<SecurityResponse> getQueuedResponse() {
        return Optional.ofNullable(this.responseRef.get());
    }
}

