/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.filter;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import io.skylite.core.http.HttpChannel;
import io.skylite.core.rest.RestRequest;
import java.util.Optional;

public class NettyAttribute {
    public static <T> Optional<T> popFrom(RestRequest request, AttributeKey<T> attribute) {
        HttpChannel httpChannel = request.getHttpChannel();
        if (httpChannel != null) {
            return httpChannel.get("channel", Channel.class).map(channel -> channel.attr(attribute).getAndSet(null));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> popFrom(ChannelHandlerContext ctx, AttributeKey<T> attribute) {
        return Optional.ofNullable(ctx.channel().attr(attribute).getAndSet(null));
    }

    public static <T> Optional<T> peekFrom(ChannelHandlerContext ctx, AttributeKey<T> attribute) {
        return Optional.ofNullable(ctx.channel().attr(attribute).get());
    }

    public static <T> void clearAttribute(RestRequest request, AttributeKey<T> attribute) {
        HttpChannel httpChannel = request.getHttpChannel();
        if (httpChannel != null) {
            httpChannel.get("channel", Channel.class).ifPresent(channel -> channel.attr(attribute).set(null));
        }
    }
}

