/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.filter;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.lucenia.http.netty4.Netty4HttpChannel;
import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.filter.SecurityRestUtils;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestUtils;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLEngine;

public class NettyRequest
implements SecurityRequest {
    protected final HttpRequest underlyingRequest;
    protected final Netty4HttpChannel underlyingChannel;
    protected final Supplier<CheckedAccessMap> parameters = Suppliers.memoize(() -> new CheckedAccessMap(NettyRequest.params(this.uri())));

    NettyRequest(HttpRequest request, Netty4HttpChannel channel) {
        this.underlyingRequest = request;
        this.underlyingChannel = channel;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.underlyingRequest.headers().forEach(h -> headers.put((String)h.getKey(), List.of((String)h.getValue())));
        return headers;
    }

    @Override
    public SSLEngine getSSLEngine() {
        SslHandler sslhandler = (SslHandler)this.underlyingChannel.getNettyChannel().pipeline().get("ssl_http");
        if (sslhandler == null && this.underlyingChannel.inboundPipeline() != null) {
            sslhandler = (SslHandler)this.underlyingChannel.inboundPipeline().get("ssl_http");
        }
        return sslhandler != null ? sslhandler.engine() : null;
    }

    @Override
    public String path() {
        String rawPath = SecurityRestUtils.path(this.underlyingRequest.uri());
        return RestUtils.decodeComponent((String)rawPath);
    }

    @Override
    public RestRequest.Method method() {
        return RestRequest.Method.valueOf((String)this.underlyingRequest.method().name());
    }

    @Override
    public Optional<InetSocketAddress> getRemoteAddress() {
        return Optional.ofNullable(this.underlyingChannel.getRemoteAddress());
    }

    @Override
    public String uri() {
        return this.underlyingRequest.uri();
    }

    @Override
    public Map<String, String> params() {
        return (Map)this.parameters.get();
    }

    @Override
    public Set<String> getUnconsumedParams() {
        return ((CheckedAccessMap)this.parameters.get()).accessedKeys();
    }

    private static Map<String, String> params(String uri) {
        HashMap<String, String> params = new HashMap<String, String>();
        int index = uri.indexOf(63);
        if (index >= 0) {
            try {
                RestUtils.decodeQueryString((String)uri, (int)(index + 1), params);
            }
            catch (IllegalArgumentException var4) {
                return Collections.emptyMap();
            }
        }
        return params;
    }

    private static class CheckedAccessMap
    extends HashMap<String, String> {
        private final Set<String> accessedKeys = new HashSet<String>();

        public CheckedAccessMap(Map<String, String> map) {
            super(map);
        }

        @Override
        public String get(Object key) {
            if (key instanceof String) {
                this.accessedKeys.add((String)key);
            }
            return (String)super.get(key);
        }

        public Set<String> accessedKeys() {
            return this.accessedKeys;
        }
    }
}

