/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.http;

import io.lucenia.security.auth.HTTPAuthenticator;
import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.filter.SecurityResponse;
import io.lucenia.security.support.HTTPHelper;
import io.lucenia.security.user.AuthCredentials;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Settings;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPBasicAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());

    public HTTPBasicAuthenticator(Settings settings, Path configPath) {
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext threadContext) {
        boolean forceLogin = Boolean.getBoolean(request.params().get("force_login"));
        if (forceLogin) {
            return null;
        }
        String authorizationHeader = request.header("Authorization");
        return HTTPHelper.extractCredentials(authorizationHeader, this.log);
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest request, AuthCredentials creds) {
        return Optional.of(new SecurityResponse(401, Map.of("WWW-Authenticate", "Basic realm=\"Lucenia Security\""), "Unauthorized"));
    }

    @Override
    public String getType() {
        return "basic";
    }
}

