/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.http;

import io.lucenia.security.auth.HTTPAuthenticator;
import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.filter.SecurityResponse;
import io.lucenia.security.user.AuthCredentials;
import io.skylite.SkyliteSecurityException;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Settings;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPProxyAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile Settings settings;
    private final Pattern rolesSeparator;

    public HTTPProxyAuthenticator(Settings settings, Path configPath) {
        this.settings = settings;
        this.rolesSeparator = Pattern.compile(settings.get("roles_separator", ","));
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext context) {
        if (context.getTransient("_opendistro_security_xff_done") != Boolean.TRUE) {
            throw new SkyliteSecurityException("xff not done", new Object[0]);
        }
        Optional<AuthCredentials> requestUserHeader = Optional.ofNullable(this.settings.get("user_header")).flatMap(userHeader -> Optional.ofNullable(request.header((String)userHeader)));
        Optional requestRolesHeader = Optional.ofNullable(this.settings.get("roles_header")).flatMap(rolesHeader -> Optional.ofNullable(request.header((String)rolesHeader)));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Headers {}", request.getHeaders());
            this.log.debug("UserHeader {}, value {}", (Object)this.settings.get("user_header"), requestUserHeader.orElse(null));
            this.log.debug("RolesHeader {}, value {}", (Object)this.settings.get("roles_header"), requestRolesHeader.orElse(null));
        }
        return requestUserHeader.map(userHeader -> {
            String[] backendRoles = requestRolesHeader.map(rolesHeader -> (String[])this.rolesSeparator.splitAsStream((CharSequence)rolesHeader).map(String::trim).filter(Predicate.not(String::isEmpty)).toArray(String[]::new)).orElse(null);
            return new AuthCredentials((String)userHeader, backendRoles).markComplete();
        }).orElseGet(() -> {
            this.log.trace("No '{}' header, send 401", (Object)this.settings.get("user_header"));
            return null;
        });
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest response, AuthCredentials creds) {
        return Optional.empty();
    }

    @Override
    public String getType() {
        return "proxy";
    }
}

