/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.identity;

import io.lucenia.security.authtoken.jwt.ExpiringBearerAuthToken;
import io.lucenia.security.authtoken.jwt.JwtVendor;
import io.lucenia.security.securityconf.ConfigModel;
import io.lucenia.security.securityconf.DynamicConfigModel;
import io.lucenia.security.user.User;
import io.lucenia.security.user.UserService;
import io.skylite.SkyliteSecurityException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.identity.Subject;
import io.skylite.core.identity.noop.NoopSubject;
import io.skylite.core.identity.tokens.AuthToken;
import io.skylite.core.identity.tokens.OnBehalfOfClaims;
import io.skylite.core.identity.tokens.TokenManager;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;

public class SecurityTokenManager
implements TokenManager {
    private static final Logger logger = LogManager.getLogger(SecurityTokenManager.class);
    private final ClusterService cs;
    private final ThreadPool threadPool;
    private final UserService userService;
    private JwtVendor jwtVendor = null;
    private ConfigModel configModel = null;

    public SecurityTokenManager(ClusterService cs, ThreadPool threadPool, UserService userService) {
        this.cs = cs;
        this.threadPool = threadPool;
        this.userService = userService;
    }

    @Subscribe
    public void onConfigModelChanged(ConfigModel configModel) {
        this.configModel = configModel;
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        Settings oboSettings = dcm.getDynamicOnBehalfOfSettings();
        Boolean enabled = oboSettings.getAsBoolean("enabled", Boolean.valueOf(false));
        this.jwtVendor = enabled != false ? this.createJwtVendor(oboSettings) : null;
    }

    JwtVendor createJwtVendor(Settings settings) {
        try {
            return new JwtVendor(settings, Optional.empty());
        }
        catch (Exception ex) {
            logger.error("Unable to create the JwtVendor instance", (Throwable)ex);
            return null;
        }
    }

    public boolean issueOnBehalfOfTokenAllowed() {
        return this.jwtVendor != null && this.configModel != null;
    }

    public ExpiringBearerAuthToken issueOnBehalfOfToken(Subject subject, OnBehalfOfClaims claims) {
        if (!this.issueOnBehalfOfTokenAllowed()) {
            throw new SkyliteSecurityException("The OnBehalfOf token generation is not enabled, see {link to doc} for more information on this feature.", new Object[0]);
        }
        if (subject != null && !(subject instanceof NoopSubject)) {
            logger.warn("Unsupported subject for OnBehalfOfToken token generation, {}", (Object)subject);
            throw new IllegalArgumentException("Unsupported subject to generate OnBehalfOfToken");
        }
        if (Strings.isNullOrEmpty((String)claims.getAudience())) {
            throw new IllegalArgumentException("Claims must be supplied with an audience value");
        }
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        if (user == null) {
            throw new SkyliteSecurityException("Unsupported user to generate OnBehalfOfToken", new Object[0]);
        }
        TransportAddress callerAddress = null;
        Set<String> mappedRoles = this.configModel.mapSecurityRoles(user, callerAddress);
        try {
            return this.jwtVendor.createJwt(this.cs.getClusterName().value(), user.getName(), claims.getAudience(), claims.getExpiration(), mappedRoles.stream().collect(Collectors.toList()), user.getRoles().stream().collect(Collectors.toList()), false);
        }
        catch (Exception ex) {
            logger.error("Error creating OnBehalfOfToken for " + user.getName(), (Throwable)ex);
            throw new SkyliteSecurityException("Unable to generate OnBehalfOfToken", new Object[0]);
        }
    }

    public AuthToken issueServiceAccountToken(String serviceId) {
        try {
            return this.userService.generateAuthToken(serviceId);
        }
        catch (Exception e) {
            logger.error("Error creating sevice final account auth token, service " + serviceId, (Throwable)e);
            throw new SkyliteSecurityException("Unable to issue service account token", new Object[0]);
        }
    }
}

