/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.opensaml.integration;

import io.lucenia.security.opensaml.integration.CleanerFactory;
import java.lang.ref.Cleaner;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.collection.IndexingObjectStore;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.X509CRL;

public class SecurityX509CRLImpl
extends AbstractXMLObject
implements X509CRL {
    private static final IndexingObjectStore<String> B64_CRL_STORE = new IndexingObjectStore();
    private static final Cleaner CLEANER = CleanerFactory.create(SecurityX509CRLImpl.class);
    private Cleaner.Cleanable cleanable;
    private String b64CRLIndex;

    protected SecurityX509CRLImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getValue() {
        return (String)B64_CRL_STORE.get(this.b64CRLIndex);
    }

    public void setValue(String newValue) {
        String newCRL;
        String currentCRL = (String)B64_CRL_STORE.get(this.b64CRLIndex);
        if (!Objects.equals(currentCRL, newCRL = this.prepareForAssignment(currentCRL, newValue))) {
            if (this.cleanable != null) {
                this.cleanable.clean();
                this.cleanable = null;
            }
            this.b64CRLIndex = B64_CRL_STORE.put((Object)newCRL);
            if (this.b64CRLIndex != null) {
                this.cleanable = CLEANER.register((Object)this, new CleanerState(this.b64CRLIndex));
            }
        }
    }

    public List<XMLObject> getOrderedChildren() {
        return Collections.emptyList();
    }

    static class CleanerState
    implements Runnable {
        private String index;

        public CleanerState(@Nonnull String idx) {
            this.index = idx;
        }

        @Override
        public void run() {
            B64_CRL_STORE.remove(this.index);
        }
    }
}

