/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.privileges;

import io.lucenia.security.LuceniaSecurityPlugin;
import io.lucenia.security.privileges.PrivilegesEvaluatorResponse;
import io.lucenia.security.resolver.IndexResolverReplacer;
import io.lucenia.security.securityconf.SecurityRoles;
import io.lucenia.security.user.User;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.admin.indices.segments.PitSegmentsRequest;
import io.skylite.core.action.search.CreatePitRequest;
import io.skylite.core.action.search.DeletePitRequest;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PitPrivilegesEvaluator {
    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, ClusterService clusterService, User user, SecurityRoles securityRoles, String action, IndexNameExpressionResolver resolver, PrivilegesEvaluatorResponse presponse, IndexResolverReplacer irr) {
        if (!(request instanceof DeletePitRequest) && !(request instanceof PitSegmentsRequest)) {
            return presponse;
        }
        List<String> pitIds = new ArrayList();
        if (request instanceof DeletePitRequest) {
            DeletePitRequest deletePitRequest = (DeletePitRequest)request;
            pitIds = deletePitRequest.getPitIds();
        } else if (request instanceof PitSegmentsRequest) {
            PitSegmentsRequest pitSegmentsRequest = (PitSegmentsRequest)request;
            pitIds = pitSegmentsRequest.getPitIds();
        }
        if (pitIds.size() == 1 && "_all".equals(pitIds.get(0))) {
            return presponse;
        }
        return this.handlePitsAccess(pitIds, clusterService, user, securityRoles, action, resolver, presponse, irr);
    }

    private PrivilegesEvaluatorResponse handlePitsAccess(List<String> pitIds, ClusterService clusterService, User user, SecurityRoles securityRoles, String action, IndexNameExpressionResolver resolver, PrivilegesEvaluatorResponse presponse, IndexResolverReplacer irr) {
        Map pitToIndicesMap = LuceniaSecurityPlugin.GuiceHolder.getPitService().getIndicesForPits(pitIds);
        HashSet<String> pitIndices = new HashSet<String>();
        for (String[] indices : pitToIndicesMap.values()) {
            pitIndices.addAll(Arrays.asList(indices));
        }
        Set<String> allPermittedIndices = this.getPermittedIndices(pitIndices, clusterService, user, securityRoles, action, resolver, irr);
        if (allPermittedIndices.containsAll(pitIndices)) {
            presponse.allowed = true;
            presponse.markComplete();
        }
        return presponse;
    }

    private Set<String> getPermittedIndices(Set<String> pitIndices, ClusterService clusterService, User user, SecurityRoles securityRoles, String action, IndexNameExpressionResolver resolver, IndexResolverReplacer irr) {
        String[] indicesArr = new String[pitIndices.size()];
        CreatePitRequest req = new CreatePitRequest(new TimeValue(1L, TimeUnit.DAYS), Boolean.valueOf(true), pitIndices.toArray(indicesArr));
        IndexResolverReplacer.Resolved pitResolved = irr.resolveRequest(req);
        return securityRoles.reduce(pitResolved, user, new String[]{action}, resolver, clusterService);
    }
}

