/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.privileges;

import io.lucenia.security.privileges.PrivilegesEvaluatorResponse;
import io.lucenia.security.resolver.IndexResolverReplacer;
import io.lucenia.security.securityconf.SecurityRoles;
import io.lucenia.security.user.User;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.index.query.MatchNoneQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class TermsAggregationEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private static final String[] READ_ACTIONS = new String[]{"indices:data/read/msearch", "indices:data/read/mget", "indices:data/read/get", "indices:data/read/search", "indices:data/read/field_caps*"};
    private static final QueryBuilder NONE_QUERY = new MatchNoneQueryBuilder();

    public PrivilegesEvaluatorResponse evaluate(IndexResolverReplacer.Resolved resolved, ActionRequest request, ClusterService clusterService, User user, SecurityRoles securityRoles, IndexNameExpressionResolver resolver, PrivilegesEvaluatorResponse presponse) {
        try {
            AggregationBuilder ab;
            SearchRequest sr;
            if (request instanceof SearchRequest && (sr = (SearchRequest)request).source() != null && sr.source().query() == null && sr.source().aggregations() != null && sr.source().aggregations().getAggregatorFactories() != null && sr.source().aggregations().getAggregatorFactories().size() == 1 && sr.source().size() == 0 && (ab = (AggregationBuilder)sr.source().aggregations().getAggregatorFactories().iterator().next()) instanceof TermsAggregationBuilder && "terms".equals(ab.getType()) && "indices".equals(ab.getName()) && "_index".equals(((TermsAggregationBuilder)ab).field()) && ab.getPipelineAggregations().isEmpty() && ab.getSubAggregations().isEmpty()) {
                Set<String> allPermittedIndices = securityRoles.getAllPermittedIndicesForDashboards(resolved, user, READ_ACTIONS, resolver, clusterService);
                if (allPermittedIndices == null || allPermittedIndices.isEmpty()) {
                    sr.source().query(NONE_QUERY);
                } else {
                    sr.source().query((QueryBuilder)new TermsQueryBuilder("_index", allPermittedIndices));
                }
                presponse.allowed = true;
                return presponse.markComplete();
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to evaluate terms aggregation", (Throwable)e);
            return presponse;
        }
        return presponse;
    }
}

