/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.rest;

import com.google.common.collect.ImmutableList;
import io.lucenia.security.action.configupdate.ConfigUpdateAction;
import io.lucenia.security.action.configupdate.ConfigUpdateRequest;
import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.filter.SecurityRequestFactory;
import io.lucenia.security.ssl.transport.PrincipalExtractor;
import io.lucenia.security.ssl.util.SSLRequestHelper;
import io.lucenia.security.user.User;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.action.RestActions;

public class SecurityConfigUpdateAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/configupdate")), "/_plugins/_security");
    private final ThreadContext threadContext;
    private final AdminDNs adminDns;
    private final Settings settings;
    private final Path configPath;
    private final PrincipalExtractor principalExtractor;

    public SecurityConfigUpdateAction(Settings settings, RestController controller, ThreadPool threadPool, AdminDNs adminDns, Path configPath, PrincipalExtractor principalExtractor) {
        this.threadContext = threadPool.getThreadContext();
        this.adminDns = adminDns;
        this.settings = settings;
        this.configPath = configPath;
        this.principalExtractor = principalExtractor;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] configTypes = request.paramAsStringArrayOrEmptyIfAll("config_types");
        SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(this.settings, this.configPath, SecurityRequestFactory.from(request), this.principalExtractor);
        if (sslInfo == null) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, ""));
        }
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        if (user == null || !this.adminDns.isAdmin(user)) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, ""));
        }
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest(configTypes);
        return channel -> client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)configUpdateRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    public String getName() {
        return "Security config update";
    }
}

