/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.rest;

import com.google.common.collect.ImmutableList;
import io.lucenia.security.auth.BackendRegistry;
import io.lucenia.security.dlic.rest.support.Utils;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;

public class SecurityHealthAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/health"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/health")), "/_opendistro/_security", "/_plugins/_security");
    private final BackendRegistry registry;

    public SecurityHealthAction(Settings settings, RestController controller, BackendRegistry registry) {
        this.registry = registry;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final String mode;
            {
                this.mode = request.param("mode", "strict");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                RestStatus restStatus = RestStatus.OK;
                BytesRestResponse response = null;
                try {
                    String status = "UP";
                    String message = null;
                    builder.startObject();
                    if ("strict".equalsIgnoreCase(this.mode) && !SecurityHealthAction.this.registry.isInitialized()) {
                        status = "DOWN";
                        message = "Not initialized";
                        restStatus = RestStatus.SERVICE_UNAVAILABLE;
                    }
                    builder.field("message", message);
                    builder.field("mode", this.mode);
                    builder.field("status", status);
                    builder.endObject();
                    response = new BytesRestResponse(restStatus, builder);
                }
                finally {
                    builder.close();
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Lucenia Security Health Check";
    }
}

