/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.rest;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.configuration.ConfigurationRepository;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.privileges.PrivilegesEvaluator;
import io.lucenia.security.securityconf.DynamicConfigFactory;
import io.lucenia.security.securityconf.RoleMappings;
import io.lucenia.security.securityconf.impl.CType;
import io.lucenia.security.securityconf.impl.SecurityDynamicConfiguration;
import io.lucenia.security.user.User;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;

public class TenantInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/tenantinfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/tenantinfo")), "/_opendistro/_security", "/_plugins/_security");
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final AdminDNs adminDns;
    private final ConfigurationRepository configurationRepository;

    public TenantInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool, ClusterService clusterService, AdminDNs adminDns, ConfigurationRepository configurationRepository) {
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
        this.clusterService = clusterService;
        this.adminDns = adminDns;
        this.configurationRepository = configurationRepository;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)TenantInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                    if (!TenantInfoAction.this.isAuthorized()) {
                        response = new BytesRestResponse(RestStatus.FORBIDDEN, "");
                    } else {
                        builder.startObject();
                        SortedMap lookup = TenantInfoAction.this.clusterService.state().metadata().getIndicesLookup();
                        for (String indexOrAlias : lookup.keySet()) {
                            String tenant = TenantInfoAction.this.tenantNameForIndex(indexOrAlias);
                            if (tenant == null) continue;
                            builder.field(indexOrAlias, tenant);
                        }
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.OK, builder);
                    }
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    private boolean isAuthorized() {
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        if (user == null) {
            return false;
        }
        if (user.getName().equals(this.evaluator.dashboardsServerUsername()) || this.adminDns.isAdmin(user)) {
            return true;
        }
        SecurityDynamicConfiguration<?> rolesMappingConfiguration = this.load(CType.ROLESMAPPING, true);
        if (rolesMappingConfiguration != null) {
            String dashboardsOpenSearchRole = this.evaluator.dashboardsOpenSearchRole();
            if (Strings.isNullOrEmpty((String)dashboardsOpenSearchRole)) {
                return false;
            }
            RoleMappings roleMapping = rolesMappingConfiguration.getCEntries().getOrDefault(dashboardsOpenSearchRole, null);
            return roleMapping != null && roleMapping.getUsers().contains(user.getName());
        }
        return false;
    }

    private final SecurityDynamicConfiguration<?> load(CType config, boolean logComplianceEvent) {
        SecurityDynamicConfiguration<?> loaded = this.configurationRepository.getConfigurationsFromIndex(Collections.singleton(config), logComplianceEvent).get((Object)config).deepClone();
        return DynamicConfigFactory.addStatics(loaded);
    }

    private String tenantNameForIndex(String index) {
        String[] indexParts;
        if (index == null || (indexParts = index.split("_")).length != 3) {
            return null;
        }
        if (!indexParts[0].equals(this.evaluator.dashboardsIndex())) {
            return null;
        }
        try {
            int expectedHash = Integer.parseInt(indexParts[1]);
            String sanitizedName = indexParts[2];
            for (String tenant : this.evaluator.getAllConfiguredTenantNames()) {
                if (tenant.hashCode() != expectedHash || !sanitizedName.equals(tenant.toLowerCase().replaceAll("[^a-z0-9]+", ""))) continue;
                return tenant;
            }
            return "__private__";
        }
        catch (NumberFormatException e) {
            this.log.warn("Index {} looks like a Security tenant index but we cannot parse the hashcode so we ignore it.", (Object)index);
            return null;
        }
    }

    public String getName() {
        return "Tenant Info Action";
    }
}

