/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.securityconf.impl;

import io.lucenia.security.filter.SecurityRequest;
import io.lucenia.security.filter.SecurityResponse;
import io.lucenia.security.securityconf.impl.HttpRequestMethods;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AllowlistingSettings {
    private boolean enabled;
    private Map<String, List<HttpRequestMethods>> requests;

    public AllowlistingSettings() {
        this.enabled = false;
        this.requests = Collections.emptyMap();
    }

    public AllowlistingSettings(AllowlistingSettings allowlistingSettings) {
        this.enabled = allowlistingSettings.getEnabled();
        this.requests = allowlistingSettings.getRequests();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, List<HttpRequestMethods>> getRequests() {
        return this.requests == null ? Collections.emptyMap() : this.requests;
    }

    public void setRequests(Map<String, List<HttpRequestMethods>> requests) {
        this.requests = requests;
    }

    public String toString() {
        return "AllowlistingSetting [enabled=" + this.enabled + ", requests=" + String.valueOf(this.requests) + "]";
    }

    private boolean requestIsAllowlisted(SecurityRequest request) {
        String path = request.path();
        String pathWithoutTrailingSlash = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        String pathWithTrailingSlash = pathWithoutTrailingSlash + "/";
        if (this.requests.containsKey(pathWithoutTrailingSlash) && this.requests.get(pathWithoutTrailingSlash).contains((Object)HttpRequestMethods.valueOf(request.method().toString()))) {
            return true;
        }
        return this.requests.containsKey(pathWithTrailingSlash) && this.requests.get(pathWithTrailingSlash).contains((Object)HttpRequestMethods.valueOf(request.method().toString()));
    }

    public Optional<SecurityResponse> checkRequestIsAllowed(SecurityRequest request) {
        if (this.enabled && !this.requestIsAllowlisted(request)) {
            return Optional.of(new SecurityResponse(403, null, this.generateFailureMessage(request), XContentType.JSON.mediaType()));
        }
        return Optional.empty();
    }

    protected String getVerb() {
        return "allowlisted";
    }

    protected String generateFailureMessage(SecurityRequest request) {
        try {
            return XContentFactory.jsonBuilder().startObject().field("error", String.valueOf(request.method()) + " " + request.path() + " API not " + this.getVerb()).field("status", (Object)RestStatus.FORBIDDEN).endObject().toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

