/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.securityconf.impl;

import com.google.common.collect.ImmutableMap;
import io.lucenia.security.auditlog.config.AuditConfig;
import io.lucenia.security.securityconf.impl.AllowlistingSettings;
import io.lucenia.security.securityconf.impl.NodesDn;
import io.lucenia.security.securityconf.impl.WhitelistingSettings;
import io.lucenia.security.securityconf.impl.v6.ActionGroupsV6;
import io.lucenia.security.securityconf.impl.v6.ConfigV6;
import io.lucenia.security.securityconf.impl.v6.InternalUserV6;
import io.lucenia.security.securityconf.impl.v6.RoleMappingsV6;
import io.lucenia.security.securityconf.impl.v6.RoleV6;
import io.lucenia.security.securityconf.impl.v7.ActionGroupsV7;
import io.lucenia.security.securityconf.impl.v7.ConfigV7;
import io.lucenia.security.securityconf.impl.v7.InternalUserV7;
import io.lucenia.security.securityconf.impl.v7.RoleMappingsV7;
import io.lucenia.security.securityconf.impl.v7.RoleV7;
import io.lucenia.security.securityconf.impl.v7.TenantV7;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum CType {
    ACTIONGROUPS(CType.toMap(0, List.class, 1, ActionGroupsV6.class, 2, ActionGroupsV7.class), "action_groups.yml", false),
    ALLOWLIST(CType.toMap(1, AllowlistingSettings.class, 2, AllowlistingSettings.class), "allowlist.yml", true),
    AUDIT(CType.toMap(1, AuditConfig.class, 2, AuditConfig.class), "audit.yml", true),
    CONFIG(CType.toMap(1, ConfigV6.class, 2, ConfigV7.class), "config.yml", false),
    INTERNALUSERS(CType.toMap(1, InternalUserV6.class, 2, InternalUserV7.class), "internal_users.yml", false),
    NODESDN(CType.toMap(1, NodesDn.class, 2, NodesDn.class), "nodes_dn.yml", true),
    ROLES(CType.toMap(1, RoleV6.class, 2, RoleV7.class), "roles.yml", false),
    ROLESMAPPING(CType.toMap(1, RoleMappingsV6.class, 2, RoleMappingsV7.class), "roles_mapping.yml", false),
    TENANTS(CType.toMap(2, TenantV7.class), "tenants.yml", false),
    WHITELIST(CType.toMap(1, WhitelistingSettings.class, 2, WhitelistingSettings.class), "whitelist.yml", true);

    public static final List<CType> REQUIRED_CONFIG_FILES;
    public static final List<CType> NOT_REQUIRED_CONFIG_FILES;
    private final Map<Integer, Class<?>> implementations;
    private final String configFileName;
    private final boolean emptyIfMissing;

    private CType(Map<Integer, Class<?>> implementations, String configFileName, boolean emptyIfMissing) {
        this.implementations = implementations;
        this.configFileName = configFileName;
        this.emptyIfMissing = emptyIfMissing;
    }

    public boolean emptyIfMissing() {
        return this.emptyIfMissing;
    }

    public Map<Integer, Class<?>> getImplementationClass() {
        return Collections.unmodifiableMap(this.implementations);
    }

    public static CType fromString(String value) {
        return CType.valueOf(value.toUpperCase());
    }

    public String toLCString() {
        return this.toString().toLowerCase();
    }

    public static Set<String> lcStringValues() {
        return Arrays.stream(CType.values()).map(CType::toLCString).collect(Collectors.toSet());
    }

    public static Set<CType> fromStringValues(String[] strings) {
        return Arrays.stream(strings).map(CType::fromString).collect(Collectors.toSet());
    }

    public Path configFile(Path configDir) {
        return configDir.resolve(this.configFileName);
    }

    public String configFileName() {
        return this.configFileName;
    }

    private static Map<Integer, Class<?>> toMap(Object ... objects) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (int i = 0; i < objects.length; i += 2) {
            map.put((Object)((Integer)objects[i]), (Object)((Class)objects[i + 1]));
        }
        return map.build();
    }

    static {
        REQUIRED_CONFIG_FILES = Arrays.stream(CType.values()).filter(Predicate.not(CType::emptyIfMissing)).collect(Collectors.toList());
        NOT_REQUIRED_CONFIG_FILES = Arrays.stream(CType.values()).filter(CType::emptyIfMissing).collect(Collectors.toList());
    }
}

