/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.lucenia.client.secure.ConfigConstants;
import io.lucenia.security.ssl.LuceniaSecuritySSLPlugin;
import io.lucenia.security.ssl.SecureSSLSettings;
import io.lucenia.security.ssl.SecurityKeyStore;
import io.lucenia.security.ssl.util.CertFileProps;
import io.lucenia.security.ssl.util.CertFromFile;
import io.lucenia.security.ssl.util.CertFromKeystore;
import io.lucenia.security.ssl.util.CertFromTruststore;
import io.lucenia.security.ssl.util.ExceptionUtils;
import io.lucenia.security.ssl.util.KeystoreProps;
import io.lucenia.security.ssl.util.SSLConfigConstants;
import io.lucenia.transport.NettyAllocator;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.internal.PlatformDependent;
import io.skylite.SkyliteException;
import io.skylite.SkyliteSecurityException;
import io.skylite.SpecialPermission;
import io.skylite.common.SecureString;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.Settings;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;

public class DefaultSecurityKeyStore
implements SecurityKeyStore {
    private static final String DEFAULT_STORE_TYPE = "JKS";
    private final Settings settings;
    private final Logger log = LogManager.getLogger(this.getClass());
    public final SslProvider sslHTTPProvider;
    public final SslProvider sslTransportServerProvider;
    public final SslProvider sslTransportClientProvider;
    private final boolean httpSSLEnabled;
    private final boolean transportSSLEnabled;
    private ArrayList<String> enabledHttpCiphersJDKProvider;
    private ArrayList<String> enabledHttpCiphersOpenSSLProvider;
    private ArrayList<String> enabledTransportCiphersJDKProvider;
    private ArrayList<String> enabledTransportCiphersOpenSSLProvider;
    private ArrayList<String> enabledHttpProtocolsJDKProvider;
    private ArrayList<String> enabledHttpProtocolsOpenSSLProvider;
    private ArrayList<String> enabledTransportProtocolsJDKProvider;
    private ArrayList<String> enabledTransportProtocolsOpenSSLProvider;
    private SslContext httpSslContext;
    private SslContext transportServerSslContext;
    private SslContext transportClientSslContext;
    private X509Certificate[] transportCerts;
    private X509Certificate[] httpCerts;
    private final Environment env;

    private void printJCEWarnings() {
        try {
            int aesMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (aesMaxKeyLength < 256) {
                this.log.info("AES-256 not supported, max key length for AES is {} bit. (This is not an issue, it just limits possible encryption strength. To enable AES 256, install 'Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files')", (Object)aesMaxKeyLength);
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("AES encryption not supported (SG 1). ", (Throwable)e);
        }
    }

    public DefaultSecurityKeyStore(Settings settings, Path configPath) {
        boolean useOpenSSLForTransportIfAvailable;
        Environment _env;
        this.settings = settings;
        try {
            _env = new Environment(settings, configPath);
        }
        catch (IllegalStateException e) {
            _env = null;
        }
        this.env = _env;
        this.httpSSLEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("plugins.security.ssl.transport.enabled", Boolean.valueOf(true));
        boolean useOpenSSLForHttpIfAvailable = LuceniaSecuritySSLPlugin.OPENSSL_SUPPORTED && settings.getAsBoolean("plugins.security.ssl.http.enable_openssl_if_available", Boolean.valueOf(true)) != false;
        boolean bl = useOpenSSLForTransportIfAvailable = LuceniaSecuritySSLPlugin.OPENSSL_SUPPORTED && settings.getAsBoolean("plugins.security.ssl.transport.enable_openssl_if_available", Boolean.valueOf(true)) != false;
        if (!LuceniaSecuritySSLPlugin.OPENSSL_SUPPORTED && OpenSsl.isAvailable() && (settings.getAsBoolean("plugins.security.ssl.http.enable_openssl_if_available", Boolean.valueOf(true)).booleanValue() || settings.getAsBoolean("plugins.security.ssl.transport.enable_openssl_if_available", Boolean.valueOf(true)).booleanValue())) {
            if (PlatformDependent.javaVersion() < 12) {
                this.log.warn("Support for OpenSSL with Java 11 or prior versions require using Netty allocator. Set 'lucenia.unsafe.use_netty_default_allocator' system property to true");
            } else {
                this.log.warn("Support for OpenSSL with Java 12+ has been removed from Open Distro Security since Elasticsearch 7.4.0. Using JDK SSL instead.");
            }
        }
        boolean openSSLInfoLogged = false;
        if (this.httpSSLEnabled && useOpenSSLForHttpIfAvailable) {
            this.sslHTTPProvider = SslContext.defaultServerProvider();
            this.logOpenSSLInfos();
            openSSLInfoLogged = true;
        } else {
            this.sslHTTPProvider = this.httpSSLEnabled ? SslProvider.JDK : null;
        }
        if (this.transportSSLEnabled && useOpenSSLForTransportIfAvailable) {
            this.sslTransportClientProvider = SslContext.defaultClientProvider();
            this.sslTransportServerProvider = SslContext.defaultServerProvider();
            if (!openSSLInfoLogged) {
                this.logOpenSSLInfos();
            }
        } else if (this.transportSSLEnabled) {
            this.sslTransportClientProvider = this.sslTransportServerProvider = SslProvider.JDK;
        } else {
            this.sslTransportServerProvider = null;
            this.sslTransportClientProvider = null;
        }
        this.initEnabledSSLCiphers();
        this.initSSLConfig();
        this.printJCEWarnings();
        this.log.info("TLS Transport Client Provider : {}", (Object)this.sslTransportClientProvider);
        this.log.info("TLS Transport Server Provider : {}", (Object)this.sslTransportServerProvider);
        this.log.info("TLS HTTP Provider             : {}", (Object)this.sslHTTPProvider);
        this.log.debug("sslTransportClientProvider:{} with ciphers {}", (Object)this.sslTransportClientProvider, this.getEnabledSSLCiphers(this.sslTransportClientProvider, false));
        this.log.debug("sslTransportServerProvider:{} with ciphers {}", (Object)this.sslTransportServerProvider, this.getEnabledSSLCiphers(this.sslTransportServerProvider, false));
        this.log.debug("sslHTTPProvider:{} with ciphers {}", (Object)this.sslHTTPProvider, this.getEnabledSSLCiphers(this.sslHTTPProvider, true));
        this.log.info("Enabled TLS protocols for transport layer : {}", (Object)Arrays.toString(this.getEnabledSSLProtocols(this.sslTransportServerProvider, false)));
        this.log.info("Enabled TLS protocols for HTTP layer      : {}", (Object)Arrays.toString(this.getEnabledSSLProtocols(this.sslHTTPProvider, true)));
        this.log.debug("sslTransportClientProvider:{} with protocols {}", (Object)this.sslTransportClientProvider, (Object)this.getEnabledSSLProtocols(this.sslTransportClientProvider, false));
        this.log.debug("sslTransportServerProvider:{} with protocols {}", (Object)this.sslTransportServerProvider, (Object)this.getEnabledSSLProtocols(this.sslTransportServerProvider, false));
        this.log.debug("sslHTTPProvider:{} with protocols {}", (Object)this.sslHTTPProvider, (Object)this.getEnabledSSLProtocols(this.sslHTTPProvider, true));
        if (this.transportSSLEnabled && (this.getEnabledSSLCiphers(this.sslTransportClientProvider, false).isEmpty() || this.getEnabledSSLCiphers(this.sslTransportServerProvider, false).isEmpty())) {
            throw new SkyliteSecurityException("no valid cipher suites for transport protocol", new Object[0]);
        }
        if (this.httpSSLEnabled && this.getEnabledSSLCiphers(this.sslHTTPProvider, true).isEmpty()) {
            throw new SkyliteSecurityException("no valid cipher suites for https", new Object[0]);
        }
        if (this.transportSSLEnabled && this.getEnabledSSLCiphers(this.sslTransportServerProvider, false).isEmpty()) {
            throw new SkyliteSecurityException("no ssl protocols for transport protocol", new Object[0]);
        }
        if (this.transportSSLEnabled && this.getEnabledSSLCiphers(this.sslTransportClientProvider, false).isEmpty()) {
            throw new SkyliteSecurityException("no ssl protocols for transport protocol", new Object[0]);
        }
        if (this.httpSSLEnabled && this.getEnabledSSLCiphers(this.sslHTTPProvider, true).isEmpty()) {
            throw new SkyliteSecurityException("no ssl protocols for https", new Object[0]);
        }
    }

    private String resolve(String propName, boolean mustBeValid) {
        String originalPath;
        String path = originalPath = this.settings.get(propName, null);
        this.log.debug("Value for {} is {}", (Object)propName, (Object)originalPath);
        if (this.env != null && originalPath != null && originalPath.length() > 0) {
            path = this.env.configDir().resolve(originalPath).toAbsolutePath().toString();
            this.log.debug("Resolved {} to {} against {}", (Object)originalPath, (Object)path, (Object)this.env.configDir().toAbsolutePath().toString());
        }
        if (mustBeValid) {
            DefaultSecurityKeyStore.checkPath(path, propName);
        }
        if ("".equals(path)) {
            path = null;
        }
        return path;
    }

    private void initSSLConfig() {
        boolean client;
        if (this.env == null) {
            this.log.info("No config directory, key- and truststore files are resolved absolutely");
        } else {
            this.log.info("Config directory is {}/, from there the key- and truststore files are resolved relatively", (Object)this.env.configDir().toAbsolutePath());
        }
        if (this.transportSSLEnabled) {
            this.initTransportSSLConfig();
        }
        boolean bl = client = !"node".equals(this.settings.get("client.type"));
        if (!client && this.httpSSLEnabled) {
            this.initHttpSSLConfig();
        }
    }

    @Override
    public void initTransportSSLConfig() {
        boolean useKeyStore = this.settings.hasValue("plugins.security.ssl.transport.keystore_filepath");
        boolean useRawFiles = this.settings.hasValue("plugins.security.ssl.transport.pemcert_filepath") || this.settings.hasValue("plugins.security.ssl.transport.server.pemcert_filepath") && this.settings.hasValue("plugins.security.ssl.transport.client.pemcert_filepath");
        boolean extendedKeyUsageEnabled = this.settings.getAsBoolean("plugins.security.ssl.transport.extended_key_usage_enabled", Boolean.valueOf(false));
        if (useKeyStore) {
            String keystoreFilePath = this.resolve("plugins.security.ssl.transport.keystore_filepath", true);
            String keystoreType = this.settings.get("plugins.security.ssl.transport.keystore_type", DEFAULT_STORE_TYPE);
            String keystorePassword = SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_KEYSTORE_PASSWORD.getSetting(this.settings, "changeit");
            String truststoreFilePath = this.resolve("plugins.security.ssl.transport.truststore_filepath", true);
            if (this.settings.get("plugins.security.ssl.transport.truststore_filepath", null) == null) {
                throw new SkyliteException("plugins.security.ssl.transport.truststore_filepath must be set if transport ssl is requested.", new Object[0]);
            }
            String truststoreType = this.settings.get("plugins.security.ssl.transport.truststore_type", DEFAULT_STORE_TYPE);
            String truststorePassword = SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_TRUSTSTORE_PASSWORD.getSetting(this.settings);
            KeystoreProps keystoreProps = new KeystoreProps(keystoreFilePath, keystoreType, keystorePassword);
            KeystoreProps truststoreProps = new KeystoreProps(truststoreFilePath, truststoreType, truststorePassword);
            try {
                CertFromTruststore certFromTruststore;
                CertFromKeystore certFromKeystore;
                if (extendedKeyUsageEnabled) {
                    String truststoreServerAlias = this.settings.get("plugins.security.ssl.transport.server.truststore_alias", null);
                    String truststoreClientAlias = this.settings.get("plugins.security.ssl.transport.client.truststore_alias", null);
                    String keystoreServerAlias = this.settings.get("plugins.security.ssl.transport.server.keystore_alias", null);
                    String keystoreClientAlias = this.settings.get("plugins.security.ssl.transport.client.keystore_alias", null);
                    String serverKeyPassword = SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_SERVER_KEYSTORE_KEYPASSWORD.getSetting(this.settings, keystorePassword);
                    String clientKeyPassword = SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_CLIENT_KEYSTORE_KEYPASSWORD.getSetting(this.settings, keystorePassword);
                    if (keystoreServerAlias == null || keystoreClientAlias == null || truststoreServerAlias == null || truststoreClientAlias == null) {
                        throw new SkyliteException("plugins.security.ssl.transport.server.keystore_alias, plugins.security.ssl.transport.client.keystore_alias, plugins.security.ssl.transport.server.truststore_alias, plugins.security.ssl.transport.client.truststore_alias must be set when plugins.security.ssl.transport.extended_key_usage_enabled is true.", new Object[0]);
                    }
                    certFromKeystore = new CertFromKeystore(keystoreProps, keystoreServerAlias, keystoreClientAlias, serverKeyPassword, clientKeyPassword);
                    certFromTruststore = new CertFromTruststore(truststoreProps, truststoreServerAlias, truststoreClientAlias);
                } else {
                    String truststoreAlias = this.settings.get("plugins.security.ssl.transport.truststore_alias", null);
                    String keystoreAlias = this.settings.get("plugins.security.ssl.transport.keystore_alias", null);
                    String keyPassword = SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_KEYSTORE_KEYPASSWORD.getSetting(this.settings, keystorePassword);
                    certFromKeystore = new CertFromKeystore(keystoreProps, keystoreAlias, keyPassword);
                    certFromTruststore = new CertFromTruststore(truststoreProps, truststoreAlias);
                }
                this.validateNewCerts(this.transportCerts, certFromKeystore.getCerts());
                this.transportServerSslContext = this.buildSSLServerContext(certFromKeystore.getServerKey(), certFromKeystore.getServerCert(), certFromTruststore.getServerTrustedCerts(), this.getEnabledSSLCiphers(this.sslTransportServerProvider, false), this.sslTransportServerProvider, ClientAuth.REQUIRE);
                this.transportClientSslContext = this.buildSSLClientContext(certFromKeystore.getClientKey(), certFromKeystore.getClientCert(), certFromTruststore.getClientTrustedCerts(), this.getEnabledSSLCiphers(this.sslTransportClientProvider, false), this.sslTransportClientProvider);
                this.setTransportSSLCerts(certFromKeystore.getCerts());
            }
            catch (Exception e) {
                this.logExplanation(e);
                throw new SkyliteSecurityException("Error while initializing transport SSL layer: " + e.toString(), e, new Object[0]);
            }
        } else if (useRawFiles) {
            try {
                CertFromFile certFromFile;
                if (extendedKeyUsageEnabled) {
                    CertFileProps clientCertProps = new CertFileProps(this.resolve("plugins.security.ssl.transport.client.pemcert_filepath", true), this.resolve("plugins.security.ssl.transport.client.pemkey_filepath", true), this.resolve("plugins.security.ssl.transport.client.pemtrustedcas_filepath", true), SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_CLIENT_PEMKEY_PASSWORD.getSetting(this.settings));
                    CertFileProps serverCertProps = new CertFileProps(this.resolve("plugins.security.ssl.transport.server.pemcert_filepath", true), this.resolve("plugins.security.ssl.transport.server.pemkey_filepath", true), this.resolve("plugins.security.ssl.transport.server.pemtrustedcas_filepath", true), SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_SERVER_PEMKEY_PASSWORD.getSetting(this.settings));
                    certFromFile = new CertFromFile(clientCertProps, serverCertProps);
                } else {
                    CertFileProps certProps = new CertFileProps(this.resolve("plugins.security.ssl.transport.pemcert_filepath", true), this.resolve("plugins.security.ssl.transport.pemkey_filepath", true), this.resolve("plugins.security.ssl.transport.pemtrustedcas_filepath", true), SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_PEMKEY_PASSWORD.getSetting(this.settings));
                    certFromFile = new CertFromFile(certProps);
                }
                this.validateNewCerts(this.transportCerts, certFromFile.getCerts());
                this.transportServerSslContext = this.buildSSLServerContext(certFromFile.getServerPemKey(), certFromFile.getServerPemCert(), certFromFile.getServerTrustedCas(), certFromFile.getServerPemKeyPassword(), this.getEnabledSSLCiphers(this.sslTransportServerProvider, false), this.sslTransportServerProvider, ClientAuth.REQUIRE);
                this.transportClientSslContext = this.buildSSLClientContext(certFromFile.getClientPemKey(), certFromFile.getClientPemCert(), certFromFile.getClientTrustedCas(), certFromFile.getClientPemKeyPassword(), this.getEnabledSSLCiphers(this.sslTransportClientProvider, false), this.sslTransportClientProvider);
                this.setTransportSSLCerts(certFromFile.getCerts());
            }
            catch (Exception e) {
                this.logExplanation(e);
                throw new SkyliteSecurityException("Error while initializing transport SSL layer from PEM: " + e.toString(), e, new Object[0]);
            }
        } else {
            throw new SkyliteException("plugins.security.ssl.transport.keystore_filepath or plugins.security.ssl.transport.server.pemcert_filepath and plugins.security.ssl.transport.client.pemcert_filepath must be set if transport ssl is requested.", new Object[0]);
        }
    }

    @Override
    public void initHttpSSLConfig() {
        boolean useKeyStore = this.settings.hasValue("plugins.security.ssl.http.keystore_filepath");
        boolean useRawFiles = this.settings.hasValue("plugins.security.ssl.http.pemcert_filepath");
        ClientAuth httpClientAuthMode = ClientAuth.valueOf((String)this.settings.get("plugins.security.ssl.http.clientauth_mode", ClientAuth.OPTIONAL.toString()));
        if (useKeyStore) {
            String keystoreFilePath = this.resolve("plugins.security.ssl.http.keystore_filepath", true);
            String keystoreType = this.settings.get("plugins.security.ssl.http.keystore_type", DEFAULT_STORE_TYPE);
            SecureString tempKeystorePassword = (SecureString)ConfigConstants.LUCENIA_SECURITY_SSL_HTTP_KEYSTORE_PASSWORD_SETTING.get(this.settings);
            SecureString keystorePassword = tempKeystorePassword.isEmpty() ? new SecureString("changeit") : tempKeystorePassword;
            SecureString tempKeyPassword = (SecureString)ConfigConstants.LUCENIA_SECURITY_SSL_HTTP_KEYSTORE_KEYPASSWORD_SETTING.get(this.settings);
            SecureString keyPassword = tempKeyPassword.isEmpty() ? new SecureString(keystorePassword.toString()) : tempKeyPassword;
            String keystoreAlias = this.settings.get("plugins.security.ssl.http.keystore_alias", null);
            this.log.info("HTTPS client auth mode {}", (Object)httpClientAuthMode);
            if (this.settings.get("plugins.security.ssl.http.keystore_filepath", null) == null) {
                throw new SkyliteException("plugins.security.ssl.http.keystore_filepath must be set if https is requested.", new Object[0]);
            }
            if (httpClientAuthMode == ClientAuth.REQUIRE && this.settings.get("plugins.security.ssl.http.truststore_filepath", null) == null) {
                throw new SkyliteException("plugins.security.ssl.http.truststore_filepath must be set if http ssl and client auth is requested.", new Object[0]);
            }
            try {
                KeystoreProps keystoreProps = new KeystoreProps(keystoreFilePath, keystoreType, keystorePassword.toString());
                CertFromKeystore certFromKeystore = new CertFromKeystore(keystoreProps, keystoreAlias, keyPassword.toString());
                CertFromTruststore certFromTruststore = CertFromTruststore.Empty();
                if (this.settings.get("plugins.security.ssl.http.truststore_filepath", null) != null) {
                    String truststoreFilePath = this.resolve("plugins.security.ssl.http.truststore_filepath", true);
                    String truststoreType = this.settings.get("plugins.security.ssl.http.truststore_type", DEFAULT_STORE_TYPE);
                    String truststorePassword = SecureSSLSettings.SSLSetting.SECURITY_SSL_HTTP_TRUSTSTORE_PASSWORD.getSetting(this.settings);
                    String truststoreAlias = this.settings.get("plugins.security.ssl.http.truststore_alias", null);
                    KeystoreProps truststoreProps = new KeystoreProps(truststoreFilePath, truststoreType, truststorePassword);
                    certFromTruststore = new CertFromTruststore(truststoreProps, truststoreAlias);
                }
                this.validateNewCerts(this.httpCerts, certFromKeystore.getCerts());
                this.httpSslContext = this.buildSSLServerContext(certFromKeystore.getServerKey(), certFromKeystore.getServerCert(), certFromTruststore.getServerTrustedCerts(), this.getEnabledSSLCiphers(this.sslHTTPProvider, true), this.sslHTTPProvider, httpClientAuthMode);
                this.setHttpSSLCerts(certFromKeystore.getCerts());
            }
            catch (Exception e) {
                this.logExplanation(e);
                throw new SkyliteSecurityException("Error while initializing HTTP SSL layer: " + e.toString(), e, new Object[0]);
            }
        } else if (useRawFiles) {
            String trustedCas = this.resolve("plugins.security.ssl.http.pemtrustedcas_filepath", false);
            if (httpClientAuthMode == ClientAuth.REQUIRE) {
                DefaultSecurityKeyStore.checkPath(trustedCas, "plugins.security.ssl.http.pemtrustedcas_filepath");
            }
            try {
                CertFileProps certFileProps = new CertFileProps(this.resolve("plugins.security.ssl.http.pemcert_filepath", true), this.resolve("plugins.security.ssl.http.pemkey_filepath", true), trustedCas, SecureSSLSettings.SSLSetting.SECURITY_SSL_HTTP_PEMKEY_PASSWORD.getSetting(this.settings));
                CertFromFile certFromFile = new CertFromFile(certFileProps);
                this.validateNewCerts(this.httpCerts, certFromFile.getCerts());
                this.httpSslContext = this.buildSSLServerContext(certFromFile.getServerPemKey(), certFromFile.getServerPemCert(), certFromFile.getServerTrustedCas(), SecureSSLSettings.SSLSetting.SECURITY_SSL_HTTP_PEMKEY_PASSWORD.getSetting(this.settings), this.getEnabledSSLCiphers(this.sslHTTPProvider, true), this.sslHTTPProvider, httpClientAuthMode);
                this.setHttpSSLCerts(certFromFile.getCerts());
            }
            catch (Exception e) {
                this.logExplanation(e);
                throw new SkyliteSecurityException("Error while initializing http SSL layer from PEM: " + e.toString(), e, new Object[0]);
            }
        } else {
            throw new SkyliteException("plugins.security.ssl.http.keystore_filepath or plugins.security.ssl.http.pemkey_filepath must be set if http ssl is requested.", new Object[0]);
        }
    }

    private void validateNewCerts(X509Certificate[] currentX509Certs, X509Certificate[] newX509Certs) throws Exception {
        if (currentX509Certs == null) {
            return;
        }
        if (this.areSameCerts(currentX509Certs, newX509Certs)) {
            return;
        }
        if (!this.hasValidExpiryDates(currentX509Certs, newX509Certs)) {
            throw new Exception("New certificates should not expire before the current ones.");
        }
        if (!this.hasValidDNs(currentX509Certs, newX509Certs)) {
            throw new Exception("New Certs do not have valid Issuer DN, Subject DN or SAN.");
        }
    }

    private boolean hasValidDNs(X509Certificate[] currentX509Certs, X509Certificate[] newX509Certs) {
        Function<X509Certificate, String> formatDNString = cert -> {
            String issuerDn = cert != null && cert.getIssuerX500Principal() != null ? cert.getIssuerX500Principal().getName() : "";
            String subjectDn = cert != null && cert.getSubjectX500Principal() != null ? cert.getSubjectX500Principal().getName() : "";
            String san = this.getSubjectAlternativeNames((X509Certificate)cert);
            return String.format("%s/%s/%s", issuerDn, subjectDn, san);
        };
        List currentCertDNList = Arrays.stream(currentX509Certs).map(formatDNString).sorted().collect(Collectors.toList());
        List newCertDNList = Arrays.stream(newX509Certs).map(formatDNString).sorted().collect(Collectors.toList());
        return currentCertDNList.equals(newCertDNList);
    }

    private boolean hasValidExpiryDates(X509Certificate[] currentX509Certs, X509Certificate[] newX509Certs) {
        Date earliestExpiryDate = Arrays.stream(currentX509Certs).map(c -> c.getNotAfter()).min(Date::compareTo).get();
        boolean newCertsExpireBeforeCurrentCerts = Arrays.stream(newX509Certs).anyMatch(cert -> {
            Date notAfterDate = cert.getNotAfter();
            return notAfterDate.before(earliestExpiryDate) || notAfterDate.equals(earliestExpiryDate);
        });
        return !newCertsExpireBeforeCurrentCerts;
    }

    private boolean areSameCerts(X509Certificate[] currentX509Certs, X509Certificate[] newX509Certs) {
        Function<X509Certificate, String> certificateSignature = cert -> {
            byte[] signature = cert != null && cert.getSignature() != null ? cert.getSignature() : null;
            return new String(signature, StandardCharsets.UTF_8);
        };
        Set currentCertSignatureSet = Arrays.stream(currentX509Certs).map(certificateSignature).collect(Collectors.toSet());
        Set newCertSignatureSet = Arrays.stream(newX509Certs).map(certificateSignature).collect(Collectors.toSet());
        return currentCertSignatureSet.equals(newCertSignatureSet);
    }

    @Override
    public SSLEngine createHTTPSSLEngine() throws SSLException {
        SSLEngine engine = this.httpSslContext.newEngine(NettyAllocator.getAllocator());
        engine.setEnabledProtocols(this.getEnabledSSLProtocols(this.sslHTTPProvider, true));
        return engine;
    }

    @Override
    public SSLEngine createServerTransportSSLEngine() throws SSLException {
        SSLEngine engine = this.transportServerSslContext.newEngine(NettyAllocator.getAllocator());
        engine.setEnabledProtocols(this.getEnabledSSLProtocols(this.sslTransportServerProvider, false));
        return engine;
    }

    @Override
    public SSLEngine createClientTransportSSLEngine(String peerHost, int peerPort) throws SSLException {
        if (peerHost != null) {
            SSLEngine engine = this.transportClientSslContext.newEngine(NettyAllocator.getAllocator(), peerHost, peerPort);
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParams);
            engine.setEnabledProtocols(this.getEnabledSSLProtocols(this.sslTransportClientProvider, false));
            return engine;
        }
        SSLEngine engine = this.transportClientSslContext.newEngine(NettyAllocator.getAllocator());
        engine.setEnabledProtocols(this.getEnabledSSLProtocols(this.sslTransportClientProvider, false));
        return engine;
    }

    @Override
    public String getHTTPProviderName() {
        return this.sslHTTPProvider == null ? null : this.sslHTTPProvider.toString();
    }

    @Override
    public String getTransportServerProviderName() {
        return this.sslTransportServerProvider == null ? null : this.sslTransportServerProvider.toString();
    }

    @Override
    public String getTransportClientProviderName() {
        return this.sslTransportClientProvider == null ? null : this.sslTransportClientProvider.toString();
    }

    @Override
    public X509Certificate[] getTransportCerts() {
        return this.transportCerts;
    }

    @Override
    public X509Certificate[] getHttpCerts() {
        return this.httpCerts;
    }

    private void setTransportSSLCerts(X509Certificate[] certs) {
        this.transportCerts = certs;
    }

    private void setHttpSSLCerts(X509Certificate[] certs) {
        this.httpCerts = certs;
    }

    private void logOpenSSLInfos() {
        if (LuceniaSecuritySSLPlugin.OPENSSL_SUPPORTED && OpenSsl.isAvailable()) {
            this.log.info("OpenSSL {} ({}) available", (Object)OpenSsl.versionString(), (Object)OpenSsl.version());
            if ((long)OpenSsl.version() < 0x10002000L) {
                this.log.warn("Outdated OpenSSL version detected. You should update to 1.0.2k or later. Currently installed: {}", (Object)OpenSsl.versionString());
            }
            if (!OpenSsl.supportsHostnameValidation()) {
                this.log.warn("Your OpenSSL version {} does not support hostname verification. You should update to 1.0.2k or later.", (Object)OpenSsl.versionString());
            }
            this.log.debug("OpenSSL available ciphers {}", (Object)OpenSsl.availableOpenSslCipherSuites());
        } else {
            this.log.info("OpenSSL not available (this is not an error, we simply fallback to built-in JDK SSL) because of " + String.valueOf(OpenSsl.unavailabilityCause()));
        }
    }

    private List<String> getEnabledSSLCiphers(SslProvider provider, boolean http) {
        if (provider == null) {
            return Collections.emptyList();
        }
        if (http) {
            return ImmutableList.copyOf(provider == SslProvider.JDK ? this.enabledHttpCiphersJDKProvider : this.enabledHttpCiphersOpenSSLProvider);
        }
        return ImmutableList.copyOf(provider == SslProvider.JDK ? this.enabledTransportCiphersJDKProvider : this.enabledTransportCiphersOpenSSLProvider);
    }

    private String[] getEnabledSSLProtocols(SslProvider provider, boolean http) {
        if (provider == null) {
            return new String[0];
        }
        if (http) {
            return (provider == SslProvider.JDK ? this.enabledHttpProtocolsJDKProvider : this.enabledHttpProtocolsOpenSSLProvider).toArray(new String[0]);
        }
        return (provider == SslProvider.JDK ? this.enabledTransportProtocolsJDKProvider : this.enabledTransportProtocolsOpenSSLProvider).toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEnabledSSLCiphers() {
        ImmutableSet allowedSecureHttpSSLCiphers = ImmutableSet.copyOf(SSLConfigConstants.getSecureSSLCiphers(this.settings, true));
        ImmutableSet allowedSecureTransportSSLCiphers = ImmutableSet.copyOf(SSLConfigConstants.getSecureSSLCiphers(this.settings, false));
        ImmutableSet allowedSecureHttpSSLProtocols = ImmutableSet.copyOf((Object[])SSLConfigConstants.getSecureSSLProtocols(this.settings, true));
        ImmutableSet allowedSecureTransportSSLProtocols = ImmutableSet.copyOf((Object[])SSLConfigConstants.getSecureSSLProtocols(this.settings, false));
        if (LuceniaSecuritySSLPlugin.OPENSSL_SUPPORTED && OpenSsl.isAvailable()) {
            HashSet<String> openSSLSecureHttpCiphers = new HashSet<String>();
            for (String secure : allowedSecureHttpSSLCiphers) {
                if (!OpenSsl.isCipherSuiteAvailable((String)secure)) continue;
                openSSLSecureHttpCiphers.add(secure);
            }
            this.log.debug("OPENSSL {} supports the following ciphers (java-style) {}", (Object)OpenSsl.versionString(), (Object)OpenSsl.availableJavaCipherSuites());
            this.log.debug("OPENSSL {} supports the following ciphers (openssl-style) {}", (Object)OpenSsl.versionString(), (Object)OpenSsl.availableOpenSslCipherSuites());
            this.enabledHttpCiphersOpenSSLProvider = new ArrayList(openSSLSecureHttpCiphers);
        } else {
            this.enabledHttpCiphersOpenSSLProvider = new ArrayList();
        }
        if (LuceniaSecuritySSLPlugin.OPENSSL_SUPPORTED && OpenSsl.isAvailable()) {
            HashSet<String> openSSLSecureTransportCiphers = new HashSet<String>();
            for (String secure : allowedSecureTransportSSLCiphers) {
                if (!OpenSsl.isCipherSuiteAvailable((String)secure)) continue;
                openSSLSecureTransportCiphers.add(secure);
            }
            this.enabledTransportCiphersOpenSSLProvider = new ArrayList(openSSLSecureTransportCiphers);
        } else {
            this.enabledTransportCiphersOpenSSLProvider = new ArrayList();
        }
        if (LuceniaSecuritySSLPlugin.OPENSSL_SUPPORTED && OpenSsl.isAvailable() && (long)OpenSsl.version() > 0x10101009L) {
            this.enabledHttpProtocolsOpenSSLProvider = new ArrayList<String>(Arrays.asList("TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"));
            this.enabledHttpProtocolsOpenSSLProvider.retainAll((Collection<?>)allowedSecureHttpSSLProtocols);
            this.enabledTransportProtocolsOpenSSLProvider = new ArrayList<String>(Arrays.asList("TLSv1.3", "TLSv1.2", "TLSv1.1"));
            this.enabledTransportProtocolsOpenSSLProvider.retainAll((Collection<?>)allowedSecureTransportSSLProtocols);
            this.log.info("OpenSSL supports TLSv1.3");
        } else if (LuceniaSecuritySSLPlugin.OPENSSL_SUPPORTED && OpenSsl.isAvailable()) {
            this.enabledHttpProtocolsOpenSSLProvider = new ArrayList<String>(Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1"));
            this.enabledHttpProtocolsOpenSSLProvider.retainAll((Collection<?>)allowedSecureHttpSSLProtocols);
            this.enabledTransportProtocolsOpenSSLProvider = new ArrayList<String>(Arrays.asList("TLSv1.2", "TLSv1.1"));
            this.enabledTransportProtocolsOpenSSLProvider.retainAll((Collection<?>)allowedSecureTransportSSLProtocols);
        } else {
            this.enabledHttpProtocolsOpenSSLProvider = new ArrayList();
            this.enabledTransportProtocolsOpenSSLProvider = new ArrayList();
        }
        SSLEngine engine = null;
        List<String> jdkSupportedCiphers = null;
        List<String> jdkSupportedProtocols = null;
        try {
            SSLContext serverContext = SSLContext.getInstance("TLS");
            serverContext.init(null, null, null);
            engine = serverContext.createSSLEngine();
            jdkSupportedCiphers = Arrays.asList(engine.getEnabledCipherSuites());
            jdkSupportedProtocols = Arrays.asList(engine.getEnabledProtocols());
            this.log.debug("JVM supports the following {} protocols {}", (Object)jdkSupportedProtocols.size(), jdkSupportedProtocols);
            this.log.debug("JVM supports the following {} ciphers {}", (Object)jdkSupportedCiphers.size(), jdkSupportedCiphers);
            if (jdkSupportedProtocols.contains("TLSv1.3")) {
                this.log.info("JVM supports TLSv1.3");
            }
        }
        catch (Throwable e) {
            this.log.error("Unable to determine supported ciphers due to ", e);
        }
        finally {
            if (engine != null) {
                try {
                    engine.closeInbound();
                }
                catch (SSLException e) {
                    this.log.debug("Unable to close inbound ssl engine", (Throwable)e);
                }
                engine.closeOutbound();
            }
        }
        if (jdkSupportedCiphers == null || jdkSupportedCiphers.isEmpty() || jdkSupportedProtocols == null || jdkSupportedProtocols.isEmpty()) {
            throw new SkyliteException("Unable to determine supported ciphers or protocols", new Object[0]);
        }
        this.enabledHttpCiphersJDKProvider = new ArrayList<String>(jdkSupportedCiphers);
        this.enabledHttpCiphersJDKProvider.retainAll((Collection<?>)allowedSecureHttpSSLCiphers);
        this.enabledTransportCiphersJDKProvider = new ArrayList<String>(jdkSupportedCiphers);
        this.enabledTransportCiphersJDKProvider.retainAll((Collection<?>)allowedSecureTransportSSLCiphers);
        this.enabledHttpProtocolsJDKProvider = new ArrayList<String>(jdkSupportedProtocols);
        this.enabledHttpProtocolsJDKProvider.retainAll((Collection<?>)allowedSecureHttpSSLProtocols);
        this.enabledTransportProtocolsJDKProvider = new ArrayList<String>(jdkSupportedProtocols);
        this.enabledTransportProtocolsJDKProvider.retainAll((Collection<?>)allowedSecureTransportSSLProtocols);
    }

    private SslContext buildSSLServerContext(final PrivateKey _key, final X509Certificate[] _cert, X509Certificate[] _trustedCerts, final Iterable<String> ciphers, final SslProvider sslProvider, final ClientAuth authMode) throws SSLException {
        try {
            SslContextBuilder _sslContextBuilder = AccessController.doPrivileged(new PrivilegedExceptionAction<SslContextBuilder>(){

                @Override
                public SslContextBuilder run() throws Exception {
                    return DefaultSecurityKeyStore.this.configureSSLServerContextBuilder(SslContextBuilder.forServer((PrivateKey)_key, (X509Certificate[])_cert), sslProvider, ciphers, authMode);
                }
            });
            if (_trustedCerts != null && _trustedCerts.length > 0) {
                _sslContextBuilder.trustManager(_trustedCerts);
            }
            return this.buildSSLContext0(_sslContextBuilder);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SSLException) {
                throw (SSLException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private SslContext buildSSLServerContext(final File _key, final File _cert, File _trustedCerts, final String pwd, final Iterable<String> ciphers, final SslProvider sslProvider, final ClientAuth authMode) throws SSLException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            SslContextBuilder _sslContextBuilder = AccessController.doPrivileged(new PrivilegedExceptionAction<SslContextBuilder>(){

                @Override
                public SslContextBuilder run() throws Exception {
                    return DefaultSecurityKeyStore.this.configureSSLServerContextBuilder(SslContextBuilder.forServer((File)_cert, (File)_key, (String)pwd), sslProvider, ciphers, authMode);
                }
            });
            if (_trustedCerts != null) {
                _sslContextBuilder.trustManager(_trustedCerts);
            }
            return this.buildSSLContext0(_sslContextBuilder);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SSLException) {
                throw (SSLException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private SslContextBuilder configureSSLServerContextBuilder(SslContextBuilder builder, SslProvider sslProvider, Iterable<String> ciphers, ClientAuth authMode) {
        return builder.ciphers((Iterable)Stream.concat(Http2SecurityUtil.CIPHERS.stream(), StreamSupport.stream(ciphers.spliterator(), false)).collect(Collectors.toSet()), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).clientAuth(Objects.requireNonNull(authMode)).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(sslProvider).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
    }

    private SslContext buildSSLClientContext(PrivateKey _key, X509Certificate[] _cert, X509Certificate[] _trustedCerts, Iterable<String> ciphers, SslProvider sslProvider) throws SSLException {
        SslContextBuilder _sslClientContextBuilder = SslContextBuilder.forClient().ciphers(ciphers).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(sslProvider).trustManager(_trustedCerts).keyManager(_key, _cert);
        return this.buildSSLContext0(_sslClientContextBuilder);
    }

    private SslContext buildSSLClientContext(File _key, File _cert, File _trustedCerts, String pwd, Iterable<String> ciphers, SslProvider sslProvider) throws SSLException {
        SslContextBuilder _sslClientContextBuilder = SslContextBuilder.forClient().ciphers(ciphers).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(sslProvider).trustManager(_trustedCerts).keyManager(_cert, _key, pwd);
        return this.buildSSLContext0(_sslClientContextBuilder);
    }

    private SslContext buildSSLContext0(final SslContextBuilder sslContextBuilder) throws SSLException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        SslContext sslContext = null;
        try {
            sslContext = AccessController.doPrivileged(new PrivilegedExceptionAction<SslContext>(){

                @Override
                public SslContext run() throws Exception {
                    return sslContextBuilder.build();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SSLException) {
                throw (SSLException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        return sslContext;
    }

    private void logExplanation(Exception e) {
        if (ExceptionUtils.findMsg(e, "not contain valid private key") != null) {
            this.log.error("Your keystore or PEM does not contain a key. If you specified a key password, try removing it. If you did not specify a key password, perhaps you need to if the key is in fact password-protected. Maybe you just confused keys and certificates.");
        }
        if (ExceptionUtils.findMsg(e, "not contain valid certificates") != null) {
            this.log.error("Your keystore or PEM does not contain a certificate. Maybe you confused keys and certificates.");
        }
    }

    private static void checkPath(String keystoreFilePath, String fileNameLogOnly) {
        if (keystoreFilePath == null || keystoreFilePath.length() == 0) {
            throw new SkyliteException("Empty file path for " + fileNameLogOnly, new Object[0]);
        }
        if (Files.isDirectory(Paths.get(keystoreFilePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new SkyliteException("Is a directory: " + keystoreFilePath + " Expected a file for " + fileNameLogOnly, new Object[0]);
        }
        if (!Files.isReadable(Paths.get(keystoreFilePath, new String[0]))) {
            throw new SkyliteException("Unable to read " + keystoreFilePath + " (" + String.valueOf(Paths.get(keystoreFilePath, new String[0])) + "). Please make sure this files exists and is readable regarding to permissions. Property: " + fileNameLogOnly, new Object[0]);
        }
    }

    @Override
    public String getSubjectAlternativeNames(X509Certificate cert) {
        String san = "";
        try {
            Collection<List<?>> altNames;
            Collection<List<?>> collection = altNames = cert != null && cert.getSubjectAlternativeNames() != null ? cert.getSubjectAlternativeNames() : null;
            if (altNames != null) {
                ArrayList sans = new ArrayList();
                for (List<?> altName : altNames) {
                    Integer type = (Integer)altName.get(0);
                    if (type == 0) {
                        List<String> otherName = this.getOtherName(altName);
                        if (otherName == null) continue;
                        sans.add(Arrays.asList(type, otherName));
                        continue;
                    }
                    sans.add(altName);
                }
                san = ((Object)sans).toString();
            }
        }
        catch (CertificateParsingException e) {
            this.log.error("Issue parsing SubjectAlternativeName:", (Throwable)e);
        }
        return san;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getOtherName(List<?> altName) {
        if (altName.size() < 2) {
            this.log.warn("Couldn't parse subject alternative names");
            return null;
        }
        try (ASN1InputStream in = new ASN1InputStream((byte[])altName.get(1));){
            ASN1Primitive asn1Primitive = in.readObject();
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)asn1Primitive);
            ASN1ObjectIdentifier asn1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)sequence.getObjectAt(0));
            ASN1TaggedObject asn1TaggedObject = ASN1TaggedObject.getInstance((Object)sequence.getObjectAt(1));
            ASN1Object maybeTaggedAsn1Primitive = asn1TaggedObject.getBaseObject();
            if (maybeTaggedAsn1Primitive instanceof ASN1TaggedObject) {
                maybeTaggedAsn1Primitive = ASN1TaggedObject.getInstance((Object)maybeTaggedAsn1Primitive).getBaseObject();
            }
            if (maybeTaggedAsn1Primitive instanceof ASN1String) {
                ImmutableList immutableList = ImmutableList.of((Object)asn1ObjectIdentifier.getId(), (Object)maybeTaggedAsn1Primitive.toString());
                return immutableList;
            }
            this.log.warn("Couldn't parse subject alternative names");
            List<String> list = null;
            return list;
        }
        catch (Exception ioe) {
            throw new RuntimeException("Couldn't parse subject alternative names", ioe);
        }
    }
}

