/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl;

import io.lucenia.http.netty4.ssl.SecureNetty4HttpServerTransport;
import io.lucenia.plugins.SecureSettingsFactory;
import io.lucenia.security.filter.SecurityRestFilter;
import io.lucenia.security.ssl.SecurityKeyStore;
import io.lucenia.security.ssl.SslExceptionHandler;
import io.lucenia.security.ssl.http.netty.Netty4ConditionalDecompressor;
import io.lucenia.security.ssl.http.netty.Netty4HttpRequestHeaderVerifier;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.plugins.SecureHttpTransportSettingsProvider;
import io.skylite.core.plugins.TransportExceptionHandler;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.SecureTransportSettingsProvider;
import io.skylite.core.transport.Transport;
import io.skylite.core.transport.TransportAdapterProvider;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public class LuceniaSecureSettingsFactory
implements SecureSettingsFactory {
    private final ThreadPool threadPool;
    private final SecurityKeyStore sks;
    private final SslExceptionHandler sslExceptionHandler;
    private final SecurityRestFilter restFilter;

    public LuceniaSecureSettingsFactory(ThreadPool threadPool, SecurityKeyStore sks, SslExceptionHandler sslExceptionHandler, SecurityRestFilter restFilter) {
        this.threadPool = threadPool;
        this.sks = sks;
        this.sslExceptionHandler = sslExceptionHandler;
        this.restFilter = restFilter;
    }

    public Optional<SecureTransportSettingsProvider> getSecureTransportSettingsProvider(Settings settings) {
        return Optional.of(new SecureTransportSettingsProvider(){

            public Optional<TransportExceptionHandler> buildServerTransportExceptionHandler(Settings settings, Transport transport) {
                return Optional.of(new TransportExceptionHandler(){

                    public void onError(Throwable t) {
                        LuceniaSecureSettingsFactory.this.sslExceptionHandler.logError(t, false);
                    }
                });
            }

            public Optional<SSLEngine> buildSecureServerTransportEngine(Settings settings, Transport transport) throws SSLException {
                return Optional.of(LuceniaSecureSettingsFactory.this.sks.createServerTransportSSLEngine());
            }

            public Optional<SSLEngine> buildSecureClientTransportEngine(Settings settings, String hostname, int port) throws SSLException {
                return Optional.of(LuceniaSecureSettingsFactory.this.sks.createClientTransportSSLEngine(hostname, port));
            }
        });
    }

    public Optional<SecureHttpTransportSettingsProvider> getSecureHttpTransportSettingsProvider(Settings settings) {
        return Optional.of(new SecureHttpTransportSettingsProvider(){

            public Collection<TransportAdapterProvider<HttpServerTransport>> getHttpTransportAdapterProviders(Settings settings) {
                return List.of(new TransportAdapterProvider<HttpServerTransport>(this){

                    public String name() {
                        return "RequestDecompressor";
                    }

                    public <C> Optional<C> create(Settings settings, HttpServerTransport transport, Class<C> adapterClass) {
                        if (transport instanceof SecureNetty4HttpServerTransport && ChannelInboundHandlerAdapter.class.isAssignableFrom(adapterClass)) {
                            return Optional.of(new Netty4ConditionalDecompressor());
                        }
                        return Optional.empty();
                    }
                }, new TransportAdapterProvider<HttpServerTransport>(){

                    public String name() {
                        return "HeaderVerifier";
                    }

                    public <C> Optional<C> create(Settings settings, HttpServerTransport transport, Class<C> adapterClass) {
                        if (transport instanceof SecureNetty4HttpServerTransport && ChannelInboundHandlerAdapter.class.isAssignableFrom(adapterClass)) {
                            return Optional.of(new Netty4HttpRequestHeaderVerifier(LuceniaSecureSettingsFactory.this.restFilter, LuceniaSecureSettingsFactory.this.threadPool, settings));
                        }
                        return Optional.empty();
                    }
                });
            }

            public Optional<TransportExceptionHandler> buildHttpServerExceptionHandler(Settings settings, HttpServerTransport transport) {
                return Optional.of(new TransportExceptionHandler(){

                    public void onError(Throwable t) {
                        LuceniaSecureSettingsFactory.this.sslExceptionHandler.logError(t, true);
                    }
                });
            }

            public Optional<SSLEngine> buildSecureHttpServerEngine(Settings settings, HttpServerTransport transport) throws SSLException {
                return Optional.of(LuceniaSecureSettingsFactory.this.sks.createHTTPSSLEngine());
            }
        });
    }
}

