/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl;

import com.fasterxml.jackson.databind.InjectableValues;
import io.lucenia.http.netty4.ssl.SecureNetty4HttpServerTransport;
import io.lucenia.plugins.NetworkPlugin;
import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.SecureSettingsFactory;
import io.lucenia.plugins.SystemIndexPlugin;
import io.lucenia.security.DefaultObjectMapper;
import io.lucenia.security.NonValidatingObjectMapper;
import io.lucenia.security.filter.SecurityRestFilter;
import io.lucenia.security.ssl.DefaultSecurityKeyStore;
import io.lucenia.security.ssl.ExternalSecurityKeyStore;
import io.lucenia.security.ssl.LuceniaSecureSettingsFactory;
import io.lucenia.security.ssl.SecureSSLSettings;
import io.lucenia.security.ssl.SecurityKeyStore;
import io.lucenia.security.ssl.SslExceptionHandler;
import io.lucenia.security.ssl.http.netty.ValidatingDispatcher;
import io.lucenia.security.ssl.rest.SecuritySSLInfoAction;
import io.lucenia.security.ssl.transport.DefaultPrincipalExtractor;
import io.lucenia.security.ssl.transport.PrincipalExtractor;
import io.lucenia.security.ssl.transport.SSLConfig;
import io.lucenia.security.ssl.transport.SecuritySSLTransportInterceptor;
import io.lucenia.security.support.SecuritySettings;
import io.lucenia.transport.SharedGroupFactory;
import io.lucenia.transport.netty4.ssl.SecureNetty4Transport;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import io.skylite.SkyliteException;
import io.skylite.SpecialPermission;
import io.skylite.Version;
import io.skylite.common.Booleans;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.network.NetworkModuleSettings;
import io.skylite.core.common.network.NetworkService;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.PageCacheRecycler;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.plugins.SecureHttpTransportSettingsProvider;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.SecureTransportSettingsProvider;
import io.skylite.core.transport.Transport;
import io.skylite.core.transport.TransportInterceptor;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.RestController;
import org.opensearch.watcher.ResourceWatcherService;

public class LuceniaSecuritySSLPlugin
extends Plugin
implements SystemIndexPlugin,
NetworkPlugin {
    private static final Setting<Boolean> SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION = Setting.boolSetting((String)"plugins.security.ssl.transport.enforce_hostname_verification", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Deprecated});
    private static final Setting<Boolean> SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME = Setting.boolSetting((String)"plugins.security.ssl.transport.resolve_hostname", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Deprecated});
    private static boolean USE_NETTY_DEFAULT_ALLOCATOR = Booleans.parseBoolean((String)System.getProperty("lucenia.unsafe.use_netty_default_allocator"), (boolean)false);
    public static final boolean OPENSSL_SUPPORTED = PlatformDependent.javaVersion() < 12 && USE_NETTY_DEFAULT_ALLOCATOR;
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    public static final String CLIENT_TYPE = "client.type";
    protected final boolean client;
    protected final boolean httpSSLEnabled;
    protected final boolean transportSSLEnabled;
    protected final boolean extendedKeyUsageEnabled;
    protected final Settings settings;
    protected volatile SecurityRestFilter securityRestHandler;
    protected final SharedGroupFactory sharedGroupFactory;
    protected final SecurityKeyStore sks;
    protected PrincipalExtractor principalExtractor;
    protected final Path configPath;
    private static final SslExceptionHandler NOOP_SSL_EXCEPTION_HANDLER = new SslExceptionHandler(){};
    protected final SSLConfig SSLConfig;
    protected volatile ThreadPool threadPool;

    protected LuceniaSecuritySSLPlugin(Settings settings, Path configPath, boolean disabled) {
        SecurityManager sm;
        if (disabled) {
            this.settings = null;
            this.sharedGroupFactory = null;
            this.client = false;
            this.httpSSLEnabled = false;
            this.transportSSLEnabled = false;
            this.extendedKeyUsageEnabled = false;
            this.sks = null;
            this.configPath = null;
            this.SSLConfig = new SSLConfig(false, false);
            AccessController.doPrivileged(new PrivilegedAction<Object>(this){

                @Override
                public Object run() {
                    System.setProperty("opensearch.set.netty.runtime.available.processors", "false");
                    return null;
                }
            });
            return;
        }
        this.SSLConfig = new SSLConfig(settings);
        this.configPath = configPath;
        if (this.configPath != null) {
            this.log.info("Lucenia Config path is {}", (Object)this.configPath.toAbsolutePath());
        } else {
            this.log.info("Lucenia Config path is not set");
        }
        boolean allowClientInitiatedRenegotiation = settings.getAsBoolean("plugins.security.ssl.allow_client_initiated_renegotiation", Boolean.valueOf(false));
        boolean rejectClientInitiatedRenegotiation = Boolean.parseBoolean(System.getProperty("jdk.tls.rejectClientInitiatedRenegotiation"));
        if (allowClientInitiatedRenegotiation && !rejectClientInitiatedRenegotiation) {
            String renegoMsg = "Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.";
            this.log.warn("Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.");
        } else if (!rejectClientInitiatedRenegotiation) {
            sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(this){

                @Override
                public Object run() {
                    System.setProperty("jdk.tls.rejectClientInitiatedRenegotiation", "true");
                    return null;
                }
            });
            this.log.debug("Client side initiated TLS renegotiation forcibly disabled. This can prevent DoS attacks. (jdk.tls.rejectClientInitiatedRenegotiation set to true).");
        } else {
            this.log.debug("Client side initiated TLS renegotiation already disabled.");
        }
        sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(this){

            @Override
            public Object run() {
                System.setProperty("opensearch.set.netty.runtime.available.processors", "false");
                PlatformDependent.newFixedMpscQueue((int)1);
                OpenSsl.isAvailable();
                return null;
            }
        });
        this.settings = settings;
        this.sharedGroupFactory = new SharedGroupFactory(settings);
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(Settings.class, (Object)settings);
        DefaultObjectMapper.inject(injectableValues);
        NonValidatingObjectMapper.inject(injectableValues);
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE));
        this.httpSSLEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("plugins.security.ssl.transport.enabled", Boolean.valueOf(true));
        this.extendedKeyUsageEnabled = settings.getAsBoolean("plugins.security.ssl.transport.extended_key_usage_enabled", Boolean.valueOf(false));
        if (!this.httpSSLEnabled && !this.transportSSLEnabled) {
            this.log.error("SSL not activated for http and/or transport.");
        }
        this.sks = ExternalSecurityKeyStore.hasExternalSslContext(settings) ? new ExternalSecurityKeyStore(settings) : new DefaultSecurityKeyStore(settings, configPath);
    }

    public Map<String, Supplier<HttpServerTransport>> getSecureHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider, Tracer tracer) {
        if (!this.client && this.httpSSLEnabled) {
            ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings, this.configPath, NOOP_SSL_EXCEPTION_HANDLER);
            SecureNetty4HttpServerTransport sgsnht = new SecureNetty4HttpServerTransport(this.migrateSettings(settings), networkService, bigArrays, threadPool, xContentRegistry, (HttpServerTransport.Dispatcher)validatingDispatcher, clusterSettings, this.sharedGroupFactory, secureHttpTransportSettingsProvider, tracer);
            return Collections.singletonMap("io.lucenia.security.ssl.http.netty.SecuritySSLNettyHttpServerTransport", () -> sgsnht);
        }
        return Collections.emptyMap();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>(1);
        if (!this.client) {
            handlers.add((RestHandler)new SecuritySSLInfoAction(settings, this.configPath, restController, this.sks, Objects.requireNonNull(this.principalExtractor)));
        }
        return handlers;
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (this.transportSSLEnabled && !this.client) {
            interceptors.add(new SecuritySSLTransportInterceptor(this.settings, null, null, this.SSLConfig, NOOP_SSL_EXCEPTION_HANDLER));
        }
        return interceptors;
    }

    public Map<String, Supplier<Transport>> getSecureTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, SecureTransportSettingsProvider secureTransportSettingsProvider, Tracer tracer) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (this.transportSSLEnabled) {
            transports.put("io.lucenia.security.ssl.http.netty.SecuritySSLNettyTransport", () -> new SecureNetty4Transport(this.migrateSettings(settings), Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.sharedGroupFactory, secureTransportSettingsProvider, tracer));
        }
        return transports;
    }

    public Collection<Object> createComponents(Client localClient, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.threadPool = threadPool;
        ArrayList<Object> components = new ArrayList<Object>(1);
        if (this.client) {
            return components;
        }
        String principalExtractorClass = this.settings.get("plugins.security.ssl.transport.principal_extractor_class", null);
        if (principalExtractorClass == null) {
            this.principalExtractor = new DefaultPrincipalExtractor();
        } else {
            try {
                this.log.debug("Try to load and instantiate '{}'", (Object)principalExtractorClass);
                Class<?> principalExtractorClazz = Class.forName(principalExtractorClass);
                this.principalExtractor = (PrincipalExtractor)principalExtractorClazz.newInstance();
            }
            catch (Exception e) {
                this.log.error("Unable to load '{}' due to", (Object)principalExtractorClass, (Object)e);
                throw new SkyliteException((Throwable)e);
            }
        }
        components.add(this.principalExtractor);
        return components;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SecureSSLSettings.getSecureSettings());
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.clientauth_mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.enable_openssl_if_available", (boolean)OPENSSL_SUPPORTED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.enable_openssl_if_available", (boolean)OPENSSL_SUPPORTED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        if (!settings.stream().anyMatch(s -> s.getKey().equalsIgnoreCase("transport.ssl.enforce_hostname_verification"))) {
            settings.add(SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION);
        }
        if (!settings.stream().anyMatch(s -> s.getKey().equalsIgnoreCase("transport.ssl.resolve_hostname"))) {
            settings.add(SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME);
        }
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.http.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.http.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.transport.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"plugins.security.ssl.transport.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.client.external_context_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.principal_extractor_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.transport.extended_key_usage_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        if (this.extendedKeyUsageEnabled) {
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.server.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.client.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        } else {
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.ssl.transport.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        }
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"plugins.security.ssl.http.crl.file_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.validate", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.prefer_crlfile_over_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.check_only_end_entities", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.disable_crldp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"plugins.security.ssl.http.crl.disable_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.longSetting((String)"plugins.security.ssl.http.crl.validation_date", (long)-1L, (long)-1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        return settings;
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        if (!this.client && this.httpSSLEnabled) {
            if (this.settings.get("http.compression") == null) {
                builder.put("http.compression", false);
                this.log.info("Disabled https compression by default to mitigate BREACH attacks. You can enable it by setting 'http.compression: true' in lucenia.yml");
            }
            builder.put("http.type", "io.lucenia.security.ssl.http.netty.SecuritySSLNettyHttpServerTransport");
        }
        if (this.transportSSLEnabled) {
            builder.put("transport.type", "io.lucenia.security.ssl.http.netty.SecuritySSLNettyTransport");
        }
        return builder.build();
    }

    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        settingsFilter.add("opendistro_security.*");
        settingsFilter.add("plugins.security.*");
        return settingsFilter;
    }

    public Optional<SecureSettingsFactory> getSecureSettingFactory(Settings settings) {
        return Optional.of(new LuceniaSecureSettingsFactory(this.threadPool, this.sks, NOOP_SSL_EXCEPTION_HANDLER, this.securityRestHandler));
    }

    protected Settings migrateSettings(Settings settings) {
        Settings.Builder builder = Settings.builder().put(settings);
        if (!NetworkModuleSettings.TRANSPORT_SSL_DUAL_MODE_ENABLED.exists(settings)) {
            builder.put("transport.ssl.dual_mode.enabled", ((Boolean)SecuritySettings.SSL_DUAL_MODE_SETTING.get(settings)).booleanValue());
        } else if (SecuritySettings.SSL_DUAL_MODE_SETTING.exists(settings)) {
            throw new SkyliteException("Only one of the settings [transport.ssl.dual_mode.enabled, " + SecuritySettings.SSL_DUAL_MODE_SETTING.getKey() + " (deprecated)] could be specified but not both", new Object[0]);
        }
        if (!NetworkModuleSettings.TRANSPORT_SSL_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.exists(settings)) {
            builder.put("transport.ssl.resolve_hostname", ((Boolean)SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.get(settings)).booleanValue());
        } else if (SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.exists(settings)) {
            throw new SkyliteException("Only one of the settings [transport.ssl.resolve_hostname, " + SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.getKey() + " (deprecated)] could be specified but not both", new Object[0]);
        }
        if (!NetworkModuleSettings.TRANSPORT_SSL_ENFORCE_HOSTNAME_VERIFICATION.exists(settings)) {
            builder.put("transport.ssl.enforce_hostname_verification", ((Boolean)SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION.get(settings)).booleanValue());
        } else if (SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION.exists(settings)) {
            throw new SkyliteException("Only one of the settings [transport.ssl.enforce_hostname_verification, " + SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION.getKey() + " (deprecated)] could be specified but not both", new Object[0]);
        }
        return builder.build();
    }
}

