/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.ssl;

import io.skylite.common.SecureString;
import io.skylite.core.settings.SecureSetting;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SecureSSLSettings {
    private static final Logger LOG = LogManager.getLogger(SecureSSLSettings.class);
    private static final String SECURE_SUFFIX = "_secure";
    private static final String PREFIX = "plugins.security.ssl";
    private static final String HTTP_PREFIX = "plugins.security.ssl.http";
    private static final String TRANSPORT_PREFIX = "plugins.security.ssl.transport";

    private SecureSSLSettings() {
    }

    public static List<Setting<?>> getSecureSettings() {
        return Arrays.stream(SSLSetting.values()).flatMap(setting -> Stream.of(setting.asSetting(), setting.asInsecureSetting())).collect(Collectors.toList());
    }

    public static enum SSLSetting {
        SECURITY_SSL_HTTP_PEMKEY_PASSWORD("plugins.security.ssl.http.pemkey_password"),
        SECURITY_SSL_HTTP_TRUSTSTORE_PASSWORD("plugins.security.ssl.http.truststore_password", "changeit"),
        SECURITY_SSL_TRANSPORT_PEMKEY_PASSWORD("plugins.security.ssl.transport.pemkey_password"),
        SECURITY_SSL_TRANSPORT_SERVER_PEMKEY_PASSWORD("plugins.security.ssl.transport.server.pemkey_password"),
        SECURITY_SSL_TRANSPORT_CLIENT_PEMKEY_PASSWORD("plugins.security.ssl.transport.client.pemkey_password"),
        SECURITY_SSL_TRANSPORT_KEYSTORE_PASSWORD("plugins.security.ssl.transport.keystore_password"),
        SECURITY_SSL_TRANSPORT_KEYSTORE_KEYPASSWORD("plugins.security.ssl.transport.keystore_keypassword"),
        SECURITY_SSL_TRANSPORT_SERVER_KEYSTORE_KEYPASSWORD("plugins.security.ssl.transport.server.keystore_keypassword"),
        SECURITY_SSL_TRANSPORT_CLIENT_KEYSTORE_KEYPASSWORD("plugins.security.ssl.transport.client.keystore_keypassword"),
        SECURITY_SSL_TRANSPORT_TRUSTSTORE_PASSWORD("plugins.security.ssl.transport.truststore_password", "changeit");

        public final String insecurePropertyName;
        public final String propertyName;
        public final String defaultValue;

        private SSLSetting(String insecurePropertyName) {
            this(insecurePropertyName, null);
        }

        private SSLSetting(String insecurePropertyName, String defaultValue) {
            this.insecurePropertyName = insecurePropertyName;
            this.propertyName = String.format("%s%s", this.insecurePropertyName, SecureSSLSettings.SECURE_SUFFIX);
            this.defaultValue = defaultValue;
        }

        public Setting<SecureString> asSetting() {
            return SecureSetting.secureString((String)this.propertyName, (Setting)new InsecureFallbackStringSetting(this.insecurePropertyName), (Setting.Property[])new Setting.Property[0]);
        }

        public Setting<SecureString> asInsecureSetting() {
            return new InsecureFallbackStringSetting(this.insecurePropertyName);
        }

        public String getSetting(Settings settings) {
            return this.getSetting(settings, this.defaultValue);
        }

        public String getSetting(Settings settings, String defaultValue) {
            return Optional.of((SecureString)this.asSetting().get(settings)).filter(ss -> ss.length() > 0).map(SecureString::toString).orElse(defaultValue);
        }
    }

    private static class InsecureFallbackStringSetting
    extends Setting<SecureString> {
        private final String name;

        private InsecureFallbackStringSetting(String name) {
            super(name, "", s -> new SecureString(s.toCharArray()), new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
            this.name = name;
        }

        public SecureString get(Settings settings) {
            if (this.exists(settings)) {
                LOG.warn("Setting [{}] has a secure counterpart [{}{}] which should be used instead - allowing for legacy SSL setups", (Object)this.name, (Object)this.name, (Object)SecureSSLSettings.SECURE_SUFFIX);
            }
            return (SecureString)super.get(settings);
        }
    }
}

