/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.support;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import io.lucenia.security.support.SafeSerializationUtils;
import io.skylite.SkyliteException;
import io.skylite.SpecialPermission;
import io.skylite.core.common.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;

public class Base64JDKHelper {
    public static String serializeObject(Serializable object) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = SafeObjectOutputStream.create(bos);){
            out.writeObject(object);
        }
        catch (Exception e) {
            throw new SkyliteException("Instance {} of class {} is not serializable", (Throwable)e, new Object[]{object, object.getClass()});
        }
        byte[] bytes = bos.toByteArray();
        return BaseEncoding.base64().encode(bytes);
    }

    public static Serializable deserializeObject(String string) {
        Serializable serializable;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)string) ? 1 : 0) != 0, (Object)"object must not be null or empty");
        byte[] bytes = BaseEncoding.base64().decode((CharSequence)string);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        SafeObjectInputStream in = new SafeObjectInputStream(bis);
        try {
            serializable = (Serializable)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SkyliteException((Throwable)e);
            }
        }
        in.close();
        return serializable;
    }

    private static final class SafeObjectOutputStream
    extends ObjectOutputStream {
        private static final boolean useSafeObjectOutputStream = SafeObjectOutputStream.checkSubstitutionPermission();

        private static boolean checkSubstitutionPermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkPermission((Permission)new SpecialPermission());
                    AccessController.doPrivileged(() -> {
                        AccessController.checkPermission(SUBSTITUTION_PERMISSION);
                        return null;
                    });
                }
                catch (SecurityException e) {
                    return false;
                }
            }
            return true;
        }

        static ObjectOutputStream create(ByteArrayOutputStream out) throws IOException {
            try {
                return useSafeObjectOutputStream ? new SafeObjectOutputStream(out) : new ObjectOutputStream(out);
            }
            catch (SecurityException e) {
                out.reset();
                return new ObjectOutputStream(out);
            }
        }

        private SafeObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(() -> this.enableReplaceObject(true));
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            Class<?> clazz = obj.getClass();
            if (SafeSerializationUtils.isSafeClass(clazz)) {
                return obj;
            }
            throw new IOException("Unauthorized serialization attempt " + clazz.getName());
        }
    }

    private static final class SafeObjectInputStream
    extends ObjectInputStream {
        public SafeObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz = super.resolveClass(desc);
            if (SafeSerializationUtils.isSafeClass(clazz)) {
                return clazz;
            }
            throw new InvalidClassException("Unauthorized deserialization attempt ", clazz.getName());
        }
    }
}

