/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.support;

import io.skylite.core.index.shard.SearchOperationListener;
import io.skylite.core.search.internal.ReaderContext;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.transport.TransportRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface GuardedSearchOperationWrapper {
    public static final Logger log = LogManager.getLogger(GuardedSearchOperationWrapper.class);

    public void onPreQueryPhase(SearchExecutionContext var1);

    public void onNewReaderContext(ReaderContext var1);

    public void onNewScrollContext(ReaderContext var1);

    public void validateReaderContext(ReaderContext var1, TransportRequest var2);

    public void onQueryPhase(SearchExecutionContext var1, long var2);

    default public SearchOperationListener toListener() {
        return new InnerSearchOperationListener(this);
    }

    public static class InnerSearchOperationListener
    implements SearchOperationListener {
        private GuardedSearchOperationWrapper that;

        InnerSearchOperationListener(GuardedSearchOperationWrapper that) {
            this.that = that;
        }

        public void onPreQueryPhase(SearchExecutionContext searchContext) {
            try {
                this.that.onPreQueryPhase(searchContext);
            }
            catch (Exception e) {
                searchContext.setTask(null);
                log.error("Cancelled request due to internal error", (Throwable)e);
            }
        }

        public void onNewReaderContext(ReaderContext readerContext) {
            this.that.onNewReaderContext(readerContext);
        }

        public void onNewScrollContext(ReaderContext readerContext) {
            this.that.onNewScrollContext(readerContext);
        }

        public void validateReaderContext(ReaderContext readerContext, TransportRequest transportRequest) {
            this.that.validateReaderContext(readerContext, transportRequest);
        }

        public void onQueryPhase(SearchExecutionContext searchContext, long tookInNanos) {
            try {
                this.that.onQueryPhase(searchContext, tookInNanos);
            }
            catch (Exception e) {
                searchContext.setTask(null);
                log.error("Cancelled request due to internal error", (Throwable)e);
            }
        }
    }
}

