/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.support;

import com.fasterxml.jackson.core.type.TypeReference;
import io.lucenia.security.DefaultObjectMapper;
import io.skylite.core.common.Strings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonFlattener {
    public static Map<String, Object> flattenAsMap(String jsonString) {
        try {
            TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>(){};
            Map jsonMap = (Map)DefaultObjectMapper.objectMapper.readValue(jsonString, (TypeReference)typeReference);
            LinkedHashMap<String, Object> flattenMap = new LinkedHashMap<String, Object>();
            JsonFlattener.flattenEntries("", jsonMap.entrySet(), flattenMap);
            return flattenMap;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unparseable json", ioe);
        }
    }

    private static void flattenEntries(String prefix, Iterable<Map.Entry<String, Object>> entries, Map<String, Object> result) {
        if (!Strings.isNullOrEmpty((String)prefix)) {
            prefix = (String)prefix + ".";
        }
        for (Map.Entry<String, Object> e : entries) {
            JsonFlattener.flattenElement(((String)prefix).concat(e.getKey()), e.getValue(), result);
        }
    }

    private static void flattenElement(String prefix, Object source, Map<String, Object> result) {
        if (source instanceof Iterable) {
            JsonFlattener.flattenCollection(prefix, (Iterable)source, result);
        }
        if (source instanceof Map) {
            JsonFlattener.flattenEntries(prefix, ((Map)source).entrySet(), result);
        }
        result.put(prefix, source);
    }

    private static void flattenCollection(String prefix, Iterable<Object> objects, Map<String, Object> result) {
        int counter = 0;
        for (Object o : objects) {
            JsonFlattener.flattenElement(prefix + "[" + counter + "]", o, result);
            ++counter;
        }
    }
}

