/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.support;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.skylite.SkyliteException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class StreamableRegistry {
    private static final StreamableRegistry INSTANCE = new StreamableRegistry();
    public final BiMap<Class<?>, Integer> classToIdMap = HashBiMap.create();
    private final Map<Integer, Entry> idToEntryMap = new HashMap<Integer, Entry>();

    private StreamableRegistry() {
        this.registerAllStreamables();
    }

    private Writeable.Writer<Object> getWriter(Class<?> clazz) {
        if (!this.classToIdMap.containsKey(clazz)) {
            throw new SkyliteException(String.format("No writer registered for class %s", clazz.getName()), new Object[0]);
        }
        return this.idToEntryMap.get((Object)this.classToIdMap.get(clazz)).writer;
    }

    private Writeable.Reader<Object> getReader(int id) {
        if (!this.idToEntryMap.containsKey(id)) {
            throw new SkyliteException(String.format("No reader registered for id %s", id), new Object[0]);
        }
        return this.idToEntryMap.get((Object)Integer.valueOf((int)id)).reader;
    }

    private int getId(Class<?> clazz) {
        if (!this.classToIdMap.containsKey(clazz)) {
            throw new SkyliteException(String.format("No writer registered for class %s", clazz.getName()), new Object[0]);
        }
        return (Integer)this.classToIdMap.get(clazz);
    }

    protected boolean isStreamable(Class<?> clazz) {
        return this.classToIdMap.containsKey(clazz);
    }

    protected void writeTo(StreamOutput out, Object object) throws IOException {
        out.writeByte((byte)this.getId(object.getClass()));
        this.getWriter(object.getClass()).write(out, object);
    }

    protected Object readFrom(StreamInput in) throws IOException {
        byte id = in.readByte();
        return this.getReader(id).read(in);
    }

    protected static StreamableRegistry getInstance() {
        return INSTANCE;
    }

    protected void registerStreamable(int streamableId, Class<?> clazz, Writeable.Writer<Object> writer, Writeable.Reader<Object> reader) {
        if (Writeable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format("%s is Writeable and should not be registered as a streamable", clazz.getName()));
        }
        this.classToIdMap.put(clazz, (Object)streamableId);
        this.idToEntryMap.put(streamableId, new Entry(writer, reader));
    }

    protected int getStreamableID(Class<?> clazz) {
        if (!this.isStreamable(clazz)) {
            throw new SkyliteException(String.format("class %s is in streamable registry", clazz.getName()), new Object[0]);
        }
        return (Integer)this.classToIdMap.get(clazz);
    }

    private void registerAllStreamables() {
        this.registerStreamable(1, InetSocketAddress.class, (Writeable.Writer<Object>)((Writeable.Writer)(o, v) -> {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)v;
            o.writeString(inetSocketAddress.getHostString());
            o.writeByteArray(inetSocketAddress.getAddress().getAddress());
            o.writeInt(inetSocketAddress.getPort());
        }), (Writeable.Reader<Object>)((Writeable.Reader)i -> {
            String host = i.readString();
            byte[] addressBytes = i.readByteArray();
            int port = i.readInt();
            return new InetSocketAddress(InetAddress.getByAddress(host, addressBytes), port);
        }));
    }

    private static class Entry {
        Writeable.Writer<Object> writer;
        Writeable.Reader<Object> reader;

        Entry(Writeable.Writer<Object> writer, Writeable.Reader<Object> reader) {
            this.writer = writer;
            this.reader = reader;
        }
    }
}

