/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.transport;

import io.lucenia.security.transport.InterClusterRequestEvaluator;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportRequest;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class OIDClusterRequestEvaluator
implements InterClusterRequestEvaluator {
    private final String certOid;

    public OIDClusterRequestEvaluator(Settings settings) {
        this.certOid = settings.get("plugins.security.cert.oid", "1.2.3.4.5.5");
    }

    @Override
    public boolean isInterClusterRequest(TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) {
        if (localCerts != null && localCerts.length > 0 && peerCerts != null && peerCerts.length > 0) {
            byte[] localValue = localCerts[0].getExtensionValue(this.certOid);
            byte[] peerValue = peerCerts[0].getExtensionValue(this.certOid);
            if (localValue != null && peerValue != null) {
                return Arrays.equals(localValue, peerValue);
            }
        }
        return false;
    }
}

