/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.user;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import io.lucenia.security.DefaultObjectMapper;
import io.lucenia.security.configuration.ConfigurationRepository;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.securityconf.DynamicConfigFactory;
import io.lucenia.security.securityconf.Hashed;
import io.lucenia.security.securityconf.impl.CType;
import io.lucenia.security.securityconf.impl.SecurityDynamicConfiguration;
import io.lucenia.security.securityconf.impl.v7.InternalUserV7;
import io.lucenia.security.support.SecurityJsonNode;
import io.lucenia.security.user.User;
import io.lucenia.security.user.UserFilterType;
import io.lucenia.security.user.UserServiceException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.Randomness;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.identity.tokens.AuthToken;
import io.skylite.core.identity.tokens.BasicAuthToken;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.PasswordGenerator;

public class UserService {
    protected final Logger log = LogManager.getLogger(this.getClass());
    ClusterService clusterService;
    private final ConfigurationRepository configurationRepository;
    String securityIndex;
    Client client;
    User tokenUser;
    static final String NO_PASSWORD_OR_HASH_MESSAGE = "Please specify either 'hash' or 'password' when creating a new internal user.";
    static final String RESTRICTED_CHARACTER_USE_MESSAGE = "A restricted character(s) was detected in the account name. Please remove: ";
    static final String SERVICE_ACCOUNT_PASSWORD_MESSAGE = "A password cannot be provided for a service account. Failed to register service account: ";
    static final String SERVICE_ACCOUNT_HASH_MESSAGE = "A password hash cannot be provided for service account. Failed to register service account: ";
    static final String NO_ACCOUNT_NAME_MESSAGE = "No account name was specified in the request.";
    static final String FAILED_ACCOUNT_RETRIEVAL_MESSAGE = "The account specified could not be accessed at this time.";
    static final String AUTH_TOKEN_GENERATION_MESSAGE = "An auth token could not be generated for the specified account.";
    static final List<String> RESTRICTED_FROM_USERNAME = ImmutableList.of((Object)":");

    private static CType getUserConfigName() {
        return CType.INTERNALUSERS;
    }

    @Inject
    public UserService(ClusterService clusterService, ConfigurationRepository configurationRepository, Settings settings, Client client) {
        this.clusterService = clusterService;
        this.configurationRepository = configurationRepository;
        this.securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.client = client;
    }

    protected final SecurityDynamicConfiguration<?> load(CType config, boolean logComplianceEvent) {
        SecurityDynamicConfiguration<?> loaded = this.configurationRepository.getConfigurationsFromIndex(Collections.singleton(config), logComplianceEvent).get((Object)config).deepClone();
        return DynamicConfigFactory.addStatics(loaded);
    }

    public SecurityDynamicConfiguration<?> createOrUpdateAccount(ObjectNode contentAsNode) throws IOException {
        boolean userExisted;
        SecurityJsonNode securityJsonNode = new SecurityJsonNode((JsonNode)contentAsNode);
        SecurityDynamicConfiguration<?> internalUsersConfiguration = this.load(UserService.getUserConfigName(), false);
        String accountName = securityJsonNode.get("name").asString();
        if (accountName == null || accountName.length() == 0) {
            throw new UserServiceException(NO_ACCOUNT_NAME_MESSAGE);
        }
        SecurityJsonNode attributeNode = securityJsonNode.get("attributes");
        if (!attributeNode.get("service").isNull() && attributeNode.get("service").asString().equalsIgnoreCase("true")) {
            this.verifyServiceAccount(securityJsonNode, accountName);
            String password = UserService.generatePassword();
            contentAsNode.put("hash", Utils.hash(password.toCharArray()));
            contentAsNode.put("service", "true");
        } else {
            contentAsNode.put("service", "false");
        }
        securityJsonNode = new SecurityJsonNode((JsonNode)contentAsNode);
        List foundRestrictedContents = RESTRICTED_FROM_USERNAME.stream().filter(accountName::contains).collect(Collectors.toList());
        if (!foundRestrictedContents.isEmpty()) {
            String restrictedContents = foundRestrictedContents.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
            throw new UserServiceException(RESTRICTED_CHARACTER_USE_MESSAGE + restrictedContents);
        }
        String plainTextPassword = securityJsonNode.get("password").asString();
        String origHash = securityJsonNode.get("hash").asString();
        if (plainTextPassword != null && plainTextPassword.length() > 0) {
            contentAsNode.remove("password");
            contentAsNode.put("hash", Utils.hash(plainTextPassword.toCharArray()));
        } else if (origHash != null && origHash.length() > 0) {
            contentAsNode.remove("password");
        } else if (plainTextPassword != null && plainTextPassword.isEmpty() && origHash == null) {
            contentAsNode.remove("password");
        }
        if (!attributeNode.get("enabled").isNull()) {
            contentAsNode.put("enabled", securityJsonNode.get("enabled").asString());
        }
        if (!(userExisted = internalUsersConfiguration.exists(accountName)) && securityJsonNode.get("hash").asString() == null) {
            throw new UserServiceException(NO_PASSWORD_OR_HASH_MESSAGE);
        }
        if (userExisted && securityJsonNode.get("hash").asString() == null) {
            String hash = ((Hashed)internalUsersConfiguration.getCEntry(accountName)).getHash();
            if (hash == null || hash.length() == 0) {
                throw new UserServiceException("Existing user " + accountName + " has no password, and no new password or hash was specified.");
            }
            contentAsNode.put("hash", hash);
        }
        internalUsersConfiguration.remove(accountName);
        contentAsNode.remove("name");
        internalUsersConfiguration.putCObject(accountName, DefaultObjectMapper.readTree((JsonNode)contentAsNode, internalUsersConfiguration.getImplementingClass()));
        return internalUsersConfiguration;
    }

    private void verifyServiceAccount(SecurityJsonNode securityJsonNode, String accountName) {
        String plainTextPassword = securityJsonNode.get("password").asString();
        String origHash = securityJsonNode.get("hash").asString();
        if (plainTextPassword != null && plainTextPassword.length() > 0) {
            throw new UserServiceException(SERVICE_ACCOUNT_PASSWORD_MESSAGE + accountName);
        }
        if (origHash != null && origHash.length() > 0) {
            throw new UserServiceException(SERVICE_ACCOUNT_HASH_MESSAGE + accountName);
        }
    }

    public static String generatePassword() {
        CharacterRule lowercaseCharacterRule = new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 1);
        CharacterRule uppercaseCharacterRule = new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 1);
        CharacterRule numericCharacterRule = new CharacterRule((CharacterData)EnglishCharacterData.Digit, 1);
        CharacterRule specialCharacterRule = new CharacterRule((CharacterData)EnglishCharacterData.Special, 1);
        List<CharacterRule> rules = Arrays.asList(lowercaseCharacterRule, uppercaseCharacterRule, numericCharacterRule, specialCharacterRule);
        PasswordGenerator passwordGenerator = new PasswordGenerator();
        Random random = Randomness.get();
        return passwordGenerator.generatePassword(random.nextInt(8) + 8, rules);
    }

    public AuthToken generateAuthToken(String accountName) throws IOException {
        SecurityDynamicConfiguration<?> internalUsersConfiguration = this.load(UserService.getUserConfigName(), false);
        if (!internalUsersConfiguration.exists(accountName)) {
            throw new UserServiceException(FAILED_ACCOUNT_RETRIEVAL_MESSAGE);
        }
        String authToken = null;
        try {
            ObjectMapper mapper = DefaultObjectMapper.objectMapper;
            JsonNode accountDetails = mapper.readTree(internalUsersConfiguration.getCEntry(accountName).toString());
            ObjectNode contentAsNode = (ObjectNode)accountDetails;
            SecurityJsonNode securityJsonNode = new SecurityJsonNode((JsonNode)contentAsNode);
            Optional.ofNullable(securityJsonNode.get("service")).map(SecurityJsonNode::asString).filter("true"::equalsIgnoreCase).orElseThrow(() -> new UserServiceException(AUTH_TOKEN_GENERATION_MESSAGE));
            Optional.ofNullable(securityJsonNode.get("enabled")).map(SecurityJsonNode::asString).filter("true"::equalsIgnoreCase).orElseThrow(() -> new UserServiceException(AUTH_TOKEN_GENERATION_MESSAGE));
            String plainTextPassword = UserService.generatePassword();
            contentAsNode.put("hash", Utils.hash(plainTextPassword.toCharArray()));
            contentAsNode.put("enabled", "true");
            contentAsNode.put("service", "true");
            internalUsersConfiguration.remove(accountName);
            contentAsNode.remove("name");
            internalUsersConfiguration.putCObject(accountName, DefaultObjectMapper.readTree((JsonNode)contentAsNode, internalUsersConfiguration.getImplementingClass()));
            UserService.saveAndUpdateConfigs(UserService.getUserConfigName().toString(), this.client, CType.INTERNALUSERS, internalUsersConfiguration);
            authToken = Base64.getUrlEncoder().encodeToString((accountName + ":" + plainTextPassword).getBytes(StandardCharsets.UTF_8));
            return new BasicAuthToken(authToken);
        }
        catch (JsonProcessingException ex) {
            throw new UserServiceException(FAILED_ACCOUNT_RETRIEVAL_MESSAGE);
        }
        catch (Exception e) {
            throw new UserServiceException(AUTH_TOKEN_GENERATION_MESSAGE);
        }
    }

    public static void saveAndUpdateConfigs(String indexName, Client client, CType cType, SecurityDynamicConfiguration<?> configuration) {
        IndexRequest ir = new IndexRequest(indexName);
        String id = cType.toLCString();
        configuration.removeStatic();
        try {
            client.index(((IndexRequest)ir.id(id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setIfSeqNo(configuration.getSeqNo()).setIfPrimaryTerm(configuration.getPrimaryTerm()).source(new Object[]{id, XContentHelper.toXContent(configuration, (MediaType)XContentType.JSON, (boolean)false)}));
        }
        catch (IOException e) {
            throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    public void includeAccountsIfType(SecurityDynamicConfiguration<?> configuration, UserFilterType requestedAccountType) {
        if (requestedAccountType != UserFilterType.INTERNAL && requestedAccountType != UserFilterType.SERVICE) {
            return;
        }
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        if (requestedAccountType == UserFilterType.SERVICE) {
            this.accountsToRemoveFromConfiguration(configuration, toBeRemoved, false);
        } else if (requestedAccountType == UserFilterType.INTERNAL) {
            this.accountsToRemoveFromConfiguration(configuration, toBeRemoved, true);
        }
        configuration.remove(toBeRemoved);
    }

    private void accountsToRemoveFromConfiguration(SecurityDynamicConfiguration<?> configuration, List<String> toBeRemoved, boolean isServiceAccountRequested) {
        for (Map.Entry<String, ?> entry : configuration.getCEntries().entrySet()) {
            InternalUserV7 internalUserEntry = (InternalUserV7)entry.getValue();
            Map<String, String> accountAttributes = internalUserEntry.getAttributes();
            String accountName = entry.getKey();
            boolean isServiceAccount = Boolean.parseBoolean(accountAttributes.getOrDefault("service", "false").toString());
            if (isServiceAccount != isServiceAccountRequested) continue;
            toBeRemoved.add(accountName);
        }
    }
}

