/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.util.MutableLong;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.classification.Label;
import org.tribuo.classification.LabelInfo;
import org.tribuo.classification.protos.ImmutableLabelInfoProto;
import org.tribuo.protos.core.OutputDomainProto;

public class ImmutableLabelInfo
extends LabelInfo
implements ImmutableOutputInfo<Label> {
    private static final Logger logger = Logger.getLogger(ImmutableLabelInfo.class.getName());
    private static final long serialVersionUID = 1L;
    private final Map<Integer, String> idLabelMap;
    private final Map<String, Integer> labelIDMap;
    private transient Set<Label> domain;

    private ImmutableLabelInfo(ImmutableLabelInfo info) {
        super(info);
        this.idLabelMap = new HashMap<Integer, String>();
        this.idLabelMap.putAll(info.idLabelMap);
        this.labelIDMap = new HashMap<String, Integer>();
        this.labelIDMap.putAll(info.labelIDMap);
        this.domain = Collections.unmodifiableSet(new HashSet(this.labels.values()));
    }

    ImmutableLabelInfo(LabelInfo info) {
        super(info);
        this.idLabelMap = new HashMap<Integer, String>();
        this.labelIDMap = new HashMap<String, Integer>();
        int counter = 0;
        for (Map.Entry e : this.labelCounts.entrySet()) {
            this.idLabelMap.put(counter, (String)e.getKey());
            this.labelIDMap.put((String)e.getKey(), counter);
            ++counter;
        }
        this.domain = Collections.unmodifiableSet(new HashSet(this.labels.values()));
    }

    ImmutableLabelInfo(LabelInfo info, Map<Label, Integer> mapping) {
        super(info);
        if (mapping.size() != info.size()) {
            throw new IllegalStateException("Mapping and info come from different sources, mapping.size() = " + mapping.size() + ", info.size() = " + info.size());
        }
        this.idLabelMap = new HashMap<Integer, String>();
        this.labelIDMap = new HashMap<String, Integer>();
        for (Map.Entry<Label, Integer> e : mapping.entrySet()) {
            this.idLabelMap.put(e.getValue(), e.getKey().label);
            this.labelIDMap.put(e.getKey().label, e.getValue());
        }
        this.domain = Collections.unmodifiableSet(new HashSet(this.labels.values()));
    }

    private ImmutableLabelInfo(Map<String, MutableLong> labelCounts, Map<String, Integer> mapping, int unknownCount) {
        super(labelCounts, unknownCount);
        this.idLabelMap = new HashMap<Integer, String>();
        this.labelIDMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> e : mapping.entrySet()) {
            this.idLabelMap.put(e.getValue(), e.getKey());
            this.labelIDMap.put(e.getKey(), e.getValue());
        }
        this.domain = Collections.unmodifiableSet(new HashSet(this.labels.values()));
    }

    public static ImmutableLabelInfo deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        ImmutableLabelInfoProto proto = (ImmutableLabelInfoProto)message.unpack(ImmutableLabelInfoProto.class);
        if (proto.getLabelCount() != proto.getCountCount() || proto.getLabelCount() != proto.getIdCount()) {
            throw new IllegalArgumentException("Invalid protobuf, different numbers of labels, ids and counts, labels " + proto.getLabelCount() + ", ids " + proto.getIdCount() + ", counts " + proto.getCountCount());
        }
        HashMap<String, MutableLong> labelCounts = new HashMap<String, MutableLong>();
        HashMap<String, Integer> labelIDMap = new HashMap<String, Integer>();
        for (int i = 0; i < proto.getLabelCount(); ++i) {
            String lbl = proto.getLabel(i);
            long cnt = proto.getCount(i);
            int id = proto.getId(i);
            MutableLong old = labelCounts.put(lbl, new MutableLong(cnt));
            if (old != null) {
                throw new IllegalArgumentException("Invalid protobuf, two mappings for " + lbl);
            }
            labelIDMap.put(lbl, id);
        }
        return new ImmutableLabelInfo(labelCounts, labelIDMap, proto.getUnknownCount());
    }

    public OutputDomainProto serialize() {
        OutputDomainProto.Builder domainBuilder = OutputDomainProto.newBuilder();
        domainBuilder.setClassName(ImmutableLabelInfo.class.getName());
        domainBuilder.setVersion(0);
        ImmutableLabelInfoProto.Builder data = ImmutableLabelInfoProto.newBuilder();
        data.setUnknownCount(this.unknownCount);
        for (Map.Entry e : this.labelCounts.entrySet()) {
            data.addLabel((String)e.getKey());
            data.addCount(((MutableLong)e.getValue()).longValue());
            data.addId(this.labelIDMap.get(e.getKey()));
        }
        domainBuilder.setSerializedData(Any.pack((Message)data.build()));
        return domainBuilder.build();
    }

    @Override
    public Set<Label> getDomain() {
        return this.domain;
    }

    public int getID(Label output) {
        return this.labelIDMap.getOrDefault(output.getLabel(), -1);
    }

    public Label getOutput(int id) {
        String label = this.idLabelMap.get(id);
        if (label != null) {
            return (Label)this.labels.get(label);
        }
        logger.log(Level.INFO, "No entry found for id " + id);
        return null;
    }

    public long getTotalObservations() {
        long count = 0L;
        for (Map.Entry e : this.labelCounts.entrySet()) {
            count += ((MutableLong)e.getValue()).longValue();
        }
        return count;
    }

    public long getLabelCount(int id) {
        String label = this.idLabelMap.get(id);
        if (label != null) {
            MutableLong l = (MutableLong)this.labelCounts.get(label);
            return l.longValue();
        }
        return 0L;
    }

    @Override
    public ImmutableLabelInfo copy() {
        return new ImmutableLabelInfo(this);
    }

    public String toReadableString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry e : this.labelCounts.entrySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append('(');
            builder.append(this.labelIDMap.get(e.getKey()));
            builder.append(',');
            builder.append((String)e.getKey());
            builder.append(',');
            builder.append(((MutableLong)e.getValue()).longValue());
            builder.append(')');
        }
        return builder.toString();
    }

    public String toString() {
        return this.toReadableString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableLabelInfo labelInfo = (ImmutableLabelInfo)o;
        if (this.unknownCount == labelInfo.unknownCount && this.idLabelMap.equals(labelInfo.idLabelMap) && this.labelCounts.size() == labelInfo.labelCounts.size()) {
            for (Map.Entry e : this.labelCounts.entrySet()) {
                MutableLong other = (MutableLong)labelInfo.labelCounts.get(e.getKey());
                if (other != null && other.longValue() == ((MutableLong)e.getValue()).longValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.idLabelMap, this.labelCounts, this.unknownCount);
    }

    public Iterator<Pair<Integer, Label>> iterator() {
        return new ImmutableInfoIterator(this.idLabelMap);
    }

    public boolean domainAndIDEquals(ImmutableOutputInfo<Label> other) {
        if (this.size() == other.size()) {
            for (Map.Entry<Integer, String> e : this.idLabelMap.entrySet()) {
                Label otherLbl = (Label)other.getOutput(e.getKey().intValue());
                if (otherLbl == null) {
                    return false;
                }
                if (otherLbl.label.equals(e.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.domain = Collections.unmodifiableSet(new HashSet(this.labels.values()));
    }

    private static class ImmutableInfoIterator
    implements Iterator<Pair<Integer, Label>> {
        private final Iterator<Map.Entry<Integer, String>> itr;

        public ImmutableInfoIterator(Map<Integer, String> idLabelMap) {
            this.itr = idLabelMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Pair<Integer, Label> next() {
            Map.Entry<Integer, String> e = this.itr.next();
            return new Pair((Object)e.getKey(), (Object)new Label(e.getValue()));
        }
    }
}

