/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.tribuo.classification.Classifiable;
import org.tribuo.classification.protos.LabelProto;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.OutputProto;

@ProtoSerializableClass(serializedDataClass=LabelProto.class, version=0)
public final class Label
implements Classifiable<Label> {
    private static final long serialVersionUID = 1L;
    public static final String UNKNOWN = "LABEL##UNKNOWN";
    @ProtoSerializableField
    protected final String label;
    @ProtoSerializableField
    protected final double score;

    public Label(String label, double score) {
        this.label = label;
        this.score = score;
    }

    public Label(String label) {
        this(label, Double.NaN);
    }

    public static Label deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        LabelProto proto = (LabelProto)message.unpack(LabelProto.class);
        Label lbl = new Label(proto.getLabel(), proto.getScore());
        return lbl;
    }

    public OutputProto serialize() {
        return (OutputProto)ProtoUtil.serialize((ProtoSerializable)this);
    }

    public double getScore() {
        return this.score;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Label)) {
            return false;
        }
        Label that = (Label)o;
        return Objects.equals(this.label, that.label);
    }

    public boolean fullEquals(Label o) {
        return this.fullEquals(o, 0.0);
    }

    public boolean fullEquals(Label o, double tolerance) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (Double.isNaN(o.score) ^ Double.isNaN(this.score)) {
            return false;
        }
        if (Math.abs(o.score - this.score) > tolerance) {
            return false;
        }
        return Objects.equals(this.label, o.label);
    }

    public int hashCode() {
        int result = this.label.hashCode();
        return result;
    }

    public String toString() {
        if (Double.isNaN(this.score)) {
            return this.label;
        }
        return "(" + this.label + "," + this.score + ")";
    }

    public Label copy() {
        return new Label(this.label, this.score);
    }

    public String getSerializableForm(boolean includeConfidence) {
        if (includeConfidence && !Double.isNaN(this.score)) {
            return this.label + ",score=" + this.score;
        }
        return this.label;
    }
}

