/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config;

import com.oracle.labs.mlrg.olcut.config.io.ConfigWriter;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriterException;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import com.oracle.labs.mlrg.olcut.util.Util;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ConfigurationData
implements Serializable {
    private static final Logger logger = Logger.getLogger(ConfigurationData.class.getName());
    private static final long serialVersionUID = 1L;
    public static final long DEFAULT_LEASE_TIME = -1L;
    private final String name;
    private final String className;
    private final Map<String, Property> properties;
    private final String serializedForm;
    private final boolean exportable;
    private final boolean importable;
    private final long leaseTime;
    private final String entriesName;

    public ConfigurationData(String name, String className) {
        this(name, className, Collections.emptyMap());
    }

    public ConfigurationData(String name, String className, Map<String, Property> properties) {
        this(name, className, properties, null, null, false, false, -1L);
    }

    public ConfigurationData(String name, String className, String serializedForm, String entriesName, boolean exportable, boolean importable, long leaseTime) {
        this(name, className, Collections.emptyMap(), serializedForm, entriesName, exportable, importable, leaseTime);
    }

    public ConfigurationData(String name, String className, Map<String, Property> properties, String serializedForm, String entriesName, boolean exportable, boolean importable, long leaseTime) {
        this.name = name;
        this.className = className;
        this.properties = new HashMap<String, Property>(properties);
        this.serializedForm = serializedForm;
        this.entriesName = entriesName;
        this.exportable = exportable;
        this.importable = importable;
        this.leaseTime = leaseTime;
    }

    public void add(String propName, Property propValue) {
        this.properties.put(propName, propValue);
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedForm() {
        return this.serializedForm;
    }

    @Deprecated
    public boolean isImportable() {
        return this.importable;
    }

    @Deprecated
    public long getLeaseTime() {
        return this.leaseTime;
    }

    @Deprecated
    public boolean isExportable() {
        return this.exportable;
    }

    @Deprecated
    public String getEntriesName() {
        return this.entriesName;
    }

    public Map<String, Property> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Optional<Property> get(String propertyName) {
        Property value = this.properties.get(propertyName);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public boolean contains(String propName) {
        return this.properties.containsKey(propName);
    }

    public ConfigurationData copy() {
        return new ConfigurationData(this.name, this.className, this.properties, this.serializedForm, this.entriesName, this.exportable, this.importable, this.leaseTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationData)) {
            return false;
        }
        ConfigurationData that = (ConfigurationData)o;
        return this.exportable == that.exportable && this.importable == that.importable && this.leaseTime == that.leaseTime && this.name.equals(that.name) && this.className.equals(that.className) && this.properties.equals(that.properties) && Objects.equals(this.serializedForm, that.serializedForm) && Objects.equals(this.entriesName, that.entriesName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.properties, this.serializedForm, this.exportable, this.importable, this.leaseTime, this.entriesName);
    }

    public String toString() {
        return "ConfigurationData(name='" + this.name + '\'' + ", className='" + this.className + '\'' + ", properties=" + this.properties + ", serializedForm='" + this.serializedForm + '\'' + ", exportable=" + this.exportable + ", importable=" + this.importable + ", leaseTime=" + this.leaseTime + ", entriesName='" + this.entriesName + '\'' + ')';
    }

    private static boolean innerStructuralEquals(Map<String, ConfigurationData> a, Map<String, ConfigurationData> b, String aName, String bName) {
        Optional<StructuralConfigurationData> aRootOpt = StructuralConfigurationData.fromName(a, aName);
        Optional<StructuralConfigurationData> bRootOpt = StructuralConfigurationData.fromName(b, bName);
        if (aRootOpt.isPresent() && bRootOpt.isPresent()) {
            return aRootOpt.get().equals(bRootOpt.get());
        }
        if (aRootOpt.isPresent()) {
            logger.fine(String.format("Component with name: %s not found in b", bName));
        } else {
            logger.fine(String.format("Component with name: %s not found in a", aName));
        }
        return false;
    }

    public static boolean structuralEquals(List<ConfigurationData> a, List<ConfigurationData> b, String aName, String bName) {
        return ConfigurationData.innerStructuralEquals(a.stream().collect(Collectors.toMap(ConfigurationData::getName, Function.identity())), b.stream().collect(Collectors.toMap(ConfigurationData::getName, Function.identity())), aName, bName);
    }

    public void save(ConfigWriter configWriter) throws ConfigWriterException {
        this.save(configWriter, Collections.emptySet());
    }

    public void save(ConfigWriter configWriter, Set<String> redactedFields) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", this.name);
        attributes.put("type", this.className);
        attributes.put("import", "" + this.isImportable());
        attributes.put("export", "" + this.isExportable());
        if (this.getLeaseTime() > 0L) {
            attributes.put("leasetime", "" + this.getLeaseTime());
        }
        if (this.getSerializedForm() != null) {
            attributes.put("serialized", this.getSerializedForm());
        }
        if (this.getEntriesName() != null) {
            attributes.put("entries", this.getEntriesName());
        }
        HashMap<String, Property> writtenProperties = new HashMap<String, Property>();
        for (Map.Entry<String, Property> p : this.properties.entrySet()) {
            if (redactedFields.contains(p.getKey())) continue;
            writtenProperties.put(p.getKey(), p.getValue());
        }
        configWriter.writeComponent(attributes, writtenProperties);
    }

    private static class StructuralConfigurationData {
        private final String name;
        private final String className;
        private final Map<String, DerefedProperty> simpleProperties;
        private final Map<String, List<DerefedProperty>> listProperties;
        private final Map<String, List<Class<?>>> listClassProperties;
        private final Map<String, Map<String, DerefedProperty>> mapProperties;

        public static Optional<StructuralConfigurationData> fromName(Map<String, ConfigurationData> contextMap, String name) {
            return Optional.ofNullable(contextMap.get(name)).map(configurationData -> new StructuralConfigurationData(contextMap, (ConfigurationData)configurationData));
        }

        public StructuralConfigurationData(Map<String, ConfigurationData> contextMap, ConfigurationData referencedCD) {
            this.name = referencedCD.name;
            this.className = referencedCD.className;
            this.simpleProperties = new HashMap<String, DerefedProperty>();
            this.listProperties = new HashMap<String, List<DerefedProperty>>();
            this.listClassProperties = new HashMap();
            this.mapProperties = new HashMap<String, Map<String, DerefedProperty>>();
            for (Map.Entry propertyEntry : referencedCD.properties.entrySet()) {
                String propName = (String)propertyEntry.getKey();
                Property prop = (Property)propertyEntry.getValue();
                if (prop instanceof SimpleProperty) {
                    this.simpleProperties.put(propName, new DerefedProperty(contextMap, (SimpleProperty)prop, propName, ""));
                    continue;
                }
                if (prop instanceof ListProperty) {
                    ListProperty listProperty = (ListProperty)prop;
                    this.listProperties.put(propName, IntStream.range(0, listProperty.getSimpleList().size()).mapToObj(i -> new DerefedProperty(contextMap, listProperty.getSimpleList().get(i), propName, ", index: " + i)).collect(Collectors.toList()));
                    this.listClassProperties.put(propName, listProperty.getClassList());
                    continue;
                }
                if (prop instanceof MapProperty) {
                    MapProperty mapProperty = (MapProperty)prop;
                    this.mapProperties.put(propName, mapProperty.getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new DerefedProperty(contextMap, (SimpleProperty)e.getValue(), propName, ", PropValue key: " + (String)e.getKey()))));
                    continue;
                }
                logger.fine(String.format("Unknown Property of key: %s with type: %s", propertyEntry.getKey(), prop.getClass()));
            }
        }

        private static <T> boolean checkPresenceAllMatch(Map<String, T> aMap, Map<String, T> bMap, BiPredicate<T, T> matchPair) {
            HashSet<String> allKeys = new HashSet<String>(aMap.keySet());
            allKeys.addAll(bMap.keySet());
            return allKeys.stream().allMatch(k -> {
                Optional maybeA = Optional.ofNullable(aMap.get(k));
                Optional maybeB = Optional.ofNullable(bMap.get(k));
                if (maybeA.isPresent() && maybeB.isPresent()) {
                    return matchPair.test(maybeA.get(), maybeB.get());
                }
                if (maybeA.isPresent()) {
                    logger.fine(String.format("Missing property: a: %s, no value for b", k));
                } else {
                    logger.fine(String.format("Missing property: b: %s, no value for a", k));
                }
                return false;
            });
        }

        public int hashCode() {
            return Objects.hash(this.className, this.simpleProperties, this.listProperties, this.listClassProperties, this.mapProperties);
        }

        public boolean equals(Object o) {
            if (o instanceof StructuralConfigurationData) {
                StructuralConfigurationData that = (StructuralConfigurationData)o;
                if (this.className.equals(that.className)) {
                    boolean listMatch;
                    boolean mapMatch;
                    boolean simpleMatch = StructuralConfigurationData.checkPresenceAllMatch(this.simpleProperties, that.simpleProperties, DerefedProperty::equals);
                    if (!simpleMatch) {
                        logger.fine("SimpleProperties don't match: as: " + this.simpleProperties + " bs: " + that.simpleProperties);
                    }
                    if (!(mapMatch = StructuralConfigurationData.checkPresenceAllMatch(this.mapProperties, that.mapProperties, (aMap, bMap) -> aMap.keySet().equals(bMap.keySet()) && aMap.keySet().stream().allMatch(k -> ((DerefedProperty)aMap.get(k)).equals(bMap.get(k)))))) {
                        logger.fine("MapProperties don't match: as: " + this.mapProperties + " bs: " + that.mapProperties);
                    }
                    boolean bl = listMatch = StructuralConfigurationData.checkPresenceAllMatch(this.listProperties, that.listProperties, (as, bs) -> {
                        boolean eq = Util.bagEquality(as, bs);
                        if (!eq) {
                            logger.fine("ListProperties not equal using bag equality:\na: " + as.toString() + "\nb: " + bs.toString());
                        }
                        return eq;
                    }) && StructuralConfigurationData.checkPresenceAllMatch(this.listClassProperties, that.listClassProperties, (as, bs) -> {
                        boolean eq = Util.bagEquality(as, bs);
                        if (!eq) {
                            logger.fine("ListClassProperties not equal using bag equality:\na: " + as.toString() + "\nb: " + bs.toString());
                        }
                        return eq;
                    });
                    if (!listMatch) {
                        logger.fine("ListProperties don't match: as: " + this.listProperties + " bs: " + that.listProperties);
                        logger.fine("ListClassProperties don't match: as: " + this.listClassProperties + " bs: " + that.listClassProperties);
                    }
                    return simpleMatch && mapMatch && listMatch;
                }
                logger.fine(String.format("type mismatch, a.class: %s b.class: %s", this.className, this.className));
                return false;
            }
            return false;
        }

        public String toString() {
            return "StructuralConfigurationData(name='" + this.name + '\'' + ", className='" + this.className + '\'' + ", simpleProperties=" + this.simpleProperties + ", listProperties=" + this.listProperties + ", listClassProperties=" + this.listClassProperties + ", mapProperties=" + this.mapProperties + ')';
        }
    }

    private static class DerefedProperty {
        private final boolean isDerefed;
        private StructuralConfigurationData innerConf;
        private final String innerValue;
        private final String propName;
        private final String locationContext;
        private Optional<Double> innerDoubleValue;
        private Optional<OffsetDateTime> innerDateTime;
        private Optional<OffsetTime> innerTime;
        private Optional<Boolean> innerBool;

        public DerefedProperty(Map<String, ConfigurationData> confs, SimpleProperty prop, String propName, String locationContext) {
            this.propName = propName;
            this.locationContext = locationContext;
            this.innerValue = prop.getValue();
            this.innerBool = this.innerValue.trim().equalsIgnoreCase("true") || this.innerValue.trim().equalsIgnoreCase("false") ? Optional.of(Boolean.parseBoolean(this.innerValue)) : Optional.empty();
            try {
                this.innerDoubleValue = Optional.of(Double.parseDouble(this.innerValue));
            }
            catch (NumberFormatException e) {
                this.innerDoubleValue = Optional.empty();
            }
            try {
                this.innerDateTime = Optional.of(OffsetDateTime.parse(this.innerValue));
            }
            catch (DateTimeParseException e) {
                this.innerDateTime = Optional.empty();
            }
            try {
                this.innerTime = Optional.of(OffsetTime.parse(this.innerValue));
            }
            catch (DateTimeParseException e) {
                this.innerTime = Optional.empty();
            }
            Optional<ConfigurationData> maybeDeref = Optional.ofNullable(confs.get(prop.getValue()));
            this.isDerefed = maybeDeref.isPresent();
            if (this.isDerefed) {
                this.innerConf = new StructuralConfigurationData(confs, maybeDeref.get());
            }
        }

        public DerefedProperty(Map<String, ConfigurationData> confs, SimpleProperty prop, String propName) {
            this(confs, prop, propName, "");
        }

        private String reportString() {
            return String.format("Property Key: %s%s, with value %s %s %s %s %s", this.propName, this.locationContext, this.innerValue, this.isDerefed ? "(is a reference)" : "(is not a reference)", this.innerDoubleValue.map(d -> "(parsed as double " + d + ")").orElse("(not parsed as double)"), this.innerDateTime.map(d -> "(parsed as date " + d + ")").orElse("(not parsed as date)"), this.innerBool.map(d -> "(parsed as bool " + d + ")").orElse("(not parsed as bool)"));
        }

        public int hashCode() {
            if (this.isDerefed) {
                return Objects.hash(this.isDerefed, this.innerConf);
            }
            if (this.innerBool.isPresent()) {
                return Objects.hash(this.isDerefed, this.innerBool.get());
            }
            if (this.innerDoubleValue.isPresent()) {
                return Objects.hash(this.isDerefed, this.innerDoubleValue.get());
            }
            if (this.innerDateTime.isPresent()) {
                return Objects.hash(this.isDerefed, this.innerDateTime.get());
            }
            if (this.innerTime.isPresent()) {
                return Objects.hash(this.isDerefed, this.innerTime.get());
            }
            return Objects.hash(this.isDerefed, this.innerValue);
        }

        public boolean equals(Object o) {
            if (o instanceof DerefedProperty) {
                DerefedProperty that = (DerefedProperty)o;
                if (this.isDerefed && that.isDerefed) {
                    return this.innerConf.equals(that.innerConf);
                }
                if (!this.isDerefed && !that.isDerefed) {
                    boolean valueMatch = this.innerBool.isPresent() && that.innerBool.isPresent() ? this.innerBool.get().booleanValue() == that.innerBool.get().booleanValue() : (this.innerDoubleValue.isPresent() && that.innerDoubleValue.isPresent() ? Util.doubleEquals(this.innerDoubleValue.get(), that.innerDoubleValue.get()) : (this.innerDateTime.isPresent() && that.innerDateTime.isPresent() ? this.innerDateTime.get().equals(that.innerDateTime.get()) : (this.innerTime.isPresent() && that.innerTime.isPresent() ? this.innerTime.get().equals(that.innerTime.get()) : this.innerValue.equals(that.innerValue))));
                    if (!valueMatch) {
                        logger.fine(String.format("Property Value mismatch: %s and %s", this.reportString(), that.reportString()));
                    }
                    return valueMatch;
                }
                logger.fine(String.format("Reference/Value mismatch: %s and %s", this.reportString(), that.reportString()));
                return false;
            }
            logger.fine("b is not a DerefedProperty b.class: " + o.getClass());
            return false;
        }

        public String toString() {
            return "DerefedProperty(isDerefed=" + this.isDerefed + ", innerConf=" + this.innerConf + ", innerValue='" + this.innerValue + '\'' + ", propName='" + this.propName + '\'' + ", locationContext='" + this.locationContext + '\'' + ')';
        }
    }
}

