/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;

public final class SerializedObject<T> {
    private ConfigurationManager configurationManager;
    private final String name;
    private final String location;
    private final String className;
    private T object;

    public SerializedObject(String name, String location, String className) {
        this.name = name;
        this.location = location;
        this.className = className;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getClassName() {
        return this.className;
    }

    public final T getObject() throws PropertyException {
        if (this.object == null) {
            this.object = AccessController.doPrivileged(() -> {
                Object obj;
                String actualLocation = this.configurationManager.getImmutableGlobalProperties().replaceGlobalProperties(this.name, null, this.location);
                InputStream serStream = IOUtil.getInputStreamForLocation(actualLocation);
                Class<?> objectClass = Class.forName(this.className);
                if (serStream == null) throw new PropertyException(this.name, "Failed to open stream from location " + actualLocation);
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(serStream, 0x100000));
                try {
                    obj = objectClass.cast(ois.readObject());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                ois.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (ClassCastException ex) {
                            throw new PropertyException(ex, this.name, "Failed to cast object to type " + objectClass.getName());
                        }
                        catch (IOException ex) {
                            throw new PropertyException(ex, this.name, "Error reading serialized form from " + actualLocation);
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        throw new PropertyException(ex, this.name, "Serialized class " + this.className + " not found for " + actualLocation);
                    }
                }
                ois.close();
                return obj;
            });
        }
        return this.object;
    }
}

