/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.xml;

import com.oracle.labs.mlrg.olcut.config.ConfigurationData;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.config.SerializedObject;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoader;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoaderException;
import com.oracle.labs.mlrg.olcut.config.io.URLLoader;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperties;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXLoader
implements ConfigLoader {
    private static final Logger logger = Logger.getLogger(SAXLoader.class.getName());
    private final URLLoader parent;
    private final Map<String, ConfigurationData> rpdMap;
    private final Map<String, ConfigurationData> existingRPD;
    private final Map<String, SerializedObject> serializedObjects;
    private final GlobalProperties globalProperties;
    private final XMLReader xr;
    private final ConfigSAXHandler handler;

    public SAXLoader(URLLoader parent, Map<String, ConfigurationData> rpdMap, Map<String, ConfigurationData> existingRPD, Map<String, SerializedObject> serializedObjects, GlobalProperties globalProperties) throws ParserConfigurationException, SAXException {
        ConfigSAXHandler handler;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.xr = factory.newSAXParser().getXMLReader();
        this.handler = handler = new ConfigSAXHandler();
        this.xr.setContentHandler(handler);
        this.xr.setErrorHandler(handler);
        this.parent = parent;
        this.rpdMap = rpdMap;
        this.existingRPD = existingRPD;
        this.serializedObjects = serializedObjects;
        this.globalProperties = globalProperties;
    }

    @Override
    public final void load(URL url) throws ConfigLoaderException {
        AccessController.doPrivileged(() -> {
            if (url.getProtocol().equals("file")) {
                String workingDir = new File(url.getFile()).getParent();
                this.handler.setCurWorkingDir(workingDir);
            } else {
                if (IOUtil.isDisallowedProtocol(url)) {
                    throw new ConfigLoaderException("Unable to load configurations from URLs with protocol: " + url.getProtocol());
                }
                this.handler.setCurWorkingDir("");
            }
            try (InputStream is = url.openStream();){
                this.innerLoad(is, url.toString());
            }
            catch (IOException e) {
                throw new ConfigLoaderException(e, e.getMessage());
            }
            return null;
        });
    }

    @Override
    public void load(InputStream stream) throws ConfigLoaderException {
        this.innerLoad(stream, "");
    }

    private void innerLoad(InputStream stream, String location) {
        try {
            this.xr.parse(new InputSource(stream));
        }
        catch (SAXParseException e) {
            String msg = location != null && !location.isEmpty() ? "Error while parsing line " + e.getLineNumber() + " of " + location + ": " + e.getMessage() : "Error while parsing line " + e.getLineNumber() + " of input: " + e.getMessage();
            throw new ConfigLoaderException(e, msg);
        }
        catch (SAXException e) {
            throw new ConfigLoaderException(e, "Problem with XML: " + e);
        }
        catch (IOException e) {
            throw new ConfigLoaderException(e, e.getMessage());
        }
    }

    public Map<String, ConfigurationData> getPropertyMap() {
        return this.rpdMap;
    }

    public Map<String, SerializedObject> getSerializedObjects() {
        return this.serializedObjects;
    }

    public GlobalProperties getGlobalProperties() {
        return this.globalProperties;
    }

    private class ConfigSAXHandler
    extends DefaultHandler {
        ConfigurationData rpd = null;
        Locator locator;
        List<SimpleProperty> itemList = null;
        List<Class<?>> classList = null;
        String itemListName = null;
        String mapName = null;
        Map<String, SimpleProperty> entryMap = null;
        StringBuilder curItem;
        boolean overriding;
        String curWorkingDir;

        private ConfigSAXHandler() {
        }

        public void setCurWorkingDir(String curWorkingDir) {
            this.curWorkingDir = curWorkingDir;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "config": {
                    break;
                }
                case "component": {
                    String curComponent = attributes.getValue("name");
                    String curType = attributes.getValue("type");
                    String override = attributes.getValue("inherit");
                    String export = attributes.getValue("export");
                    String entriesName = attributes.getValue("entries");
                    String serializedForm = attributes.getValue("serialized");
                    boolean exportable = Boolean.parseBoolean(export);
                    String imp = attributes.getValue("import");
                    boolean importable = Boolean.parseBoolean(imp);
                    String lt = attributes.getValue("leasetime");
                    if (export == null && lt != null) {
                        throw new SAXParseException("lease timeout " + lt + " specified for component that does not have export set", this.locator);
                    }
                    long leaseTime = -1L;
                    if (lt != null) {
                        try {
                            leaseTime = Long.parseLong(lt);
                            if (leaseTime < 0L) {
                                throw new SAXParseException("lease timeout " + lt + " must be greater than 0", this.locator);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            throw new SAXParseException("lease timeout " + lt + " must be a long", this.locator);
                        }
                    }
                    if (curComponent == null || curType == null && override == null) {
                        throw new SAXParseException("component element must specify 'name' and either 'type' or 'inherit' attributes", this.locator);
                    }
                    if (override != null) {
                        ConfigurationData spd = (ConfigurationData)SAXLoader.this.rpdMap.get(override);
                        if (spd == null) {
                            if (SAXLoader.this.existingRPD == null || !SAXLoader.this.existingRPD.containsKey(override)) {
                                throw new SAXParseException("Failed to find base component '" + override + "' inherited from '" + curComponent + "'.", this.locator);
                            }
                            spd = (ConfigurationData)SAXLoader.this.existingRPD.get(override);
                        }
                        if (curType != null && !curType.equals(spd.getClassName())) {
                            logger.log(Level.FINE, String.format("Overriding component %s with component %s, new type is %s overridden type was %s", spd.getName(), curComponent, curType, spd.getClassName()));
                        }
                        if (curType == null) {
                            curType = spd.getClassName();
                        }
                        this.rpd = new ConfigurationData(curComponent, curType, spd.getProperties(), serializedForm, entriesName, exportable, importable, leaseTime);
                        this.overriding = true;
                        break;
                    }
                    if (SAXLoader.this.rpdMap.get(curComponent) != null) {
                        throw new SAXParseException("duplicate definition for " + curComponent, this.locator);
                    }
                    this.rpd = new ConfigurationData(curComponent, curType, serializedForm, entriesName, exportable, importable, leaseTime);
                    break;
                }
                case "property": {
                    String name = attributes.getValue("name");
                    String value = attributes.getValue("value");
                    if (attributes.getLength() != 2 || name == null || value == null) {
                        throw new SAXParseException("property element must only have 'name' and 'value' attributes", this.locator);
                    }
                    if (this.rpd == null) {
                        try {
                            SAXLoader.this.globalProperties.setValue(name, value);
                            break;
                        }
                        catch (PropertyException e) {
                            throw new SAXParseException("Invalid global property name: " + name, this.locator);
                        }
                    }
                    if (this.rpd.contains(name) && !this.overriding) {
                        throw new SAXParseException("Duplicate property: " + name, this.locator);
                    }
                    this.rpd.add(name, new SimpleProperty(value));
                    break;
                }
                case "propertylist": {
                    this.itemListName = attributes.getValue("name");
                    if (attributes.getLength() != 1 || this.itemListName == null) {
                        throw new SAXParseException("list element must only have the 'name' attribute", this.locator);
                    }
                    this.itemList = new ArrayList<SimpleProperty>();
                    this.classList = new ArrayList();
                    break;
                }
                case "item": 
                case "type": {
                    if (attributes.getLength() != 0) {
                        throw new SAXParseException("unknown 'item' attribute", this.locator);
                    }
                    if (this.itemList == null) {
                        throw new SAXParseException("'item' or 'type' elements must be inside a 'propertylist'", this.locator);
                    }
                    this.curItem = new StringBuilder();
                    break;
                }
                case "propertymap": {
                    this.mapName = attributes.getValue("name");
                    if (attributes.getLength() != 1 || this.mapName == null) {
                        throw new SAXParseException("map element must only have the 'name' attribute", this.locator);
                    }
                    this.entryMap = new HashMap<String, SimpleProperty>();
                    break;
                }
                case "entry": {
                    String key = attributes.getValue("key");
                    String value = attributes.getValue("value");
                    if (attributes.getLength() != 2 || key == null || value == null) {
                        throw new SAXParseException("entry element must only have 'key' and 'value' attributes", this.locator);
                    }
                    if (this.entryMap == null) {
                        throw new SAXParseException("entry element must be inside a map", this.locator);
                    }
                    if (this.entryMap.containsKey(key)) {
                        throw new SAXParseException("Repeated entry in map, key = " + key + " already exists", this.locator);
                    }
                    this.entryMap.put(key.trim(), new SimpleProperty(value.trim()));
                    break;
                }
                case "file": {
                    String name = attributes.getValue("name");
                    String value = attributes.getValue("value");
                    if (attributes.getLength() != 2 || name == null || value == null) {
                        throw new SAXParseException("file element must only have 'name' and 'value' attributes", this.locator);
                    }
                    if (this.rpd == null) {
                        try {
                            URL newURL = ConfigurationManager.class.getResource(value);
                            if (newURL == null) {
                                File newFile = new File(value);
                                if (!newFile.isAbsolute()) {
                                    newFile = new File(this.curWorkingDir, value);
                                }
                                newURL = newFile.toURI().toURL();
                            }
                            SAXLoader.this.parent.addURL(newURL);
                            break;
                        }
                        catch (MalformedURLException ex) {
                            throw new SAXParseException("Incorrectly formatted file element " + name + " with value " + value, this.locator, ex);
                        }
                    }
                    throw new SAXParseException("File element found inside a component: " + name, this.locator);
                }
                case "serialized": {
                    String name = attributes.getValue("name");
                    String type = attributes.getValue("type");
                    String location = attributes.getValue("location");
                    if (attributes.getLength() != 3 || name == null || type == null || location == null) {
                        throw new SAXParseException("serialized element must only have 'name', 'type' and 'location' elements", this.locator);
                    }
                    SAXLoader.this.serializedObjects.put(name, new SerializedObject(name, location, type));
                    break;
                }
                default: {
                    throw new SAXParseException("Unknown element '" + qName + "'", this.locator);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.curItem != null) {
                this.curItem.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXParseException {
            switch (qName) {
                case "component": {
                    SAXLoader.this.rpdMap.put(this.rpd.getName(), this.rpd);
                    this.rpd = null;
                    this.overriding = false;
                    break;
                }
                case "propertylist": {
                    if (this.rpd.contains(this.itemListName) && !this.overriding) {
                        throw new SAXParseException("Duplicate property: " + this.itemListName, this.locator);
                    }
                    this.rpd.add(this.itemListName, new ListProperty(this.itemList, this.classList));
                    this.itemList = null;
                    this.classList = null;
                    break;
                }
                case "item": {
                    this.itemList.add(new SimpleProperty(this.curItem.toString().trim()));
                    this.curItem = null;
                    break;
                }
                case "type": {
                    try {
                        this.classList.add(Class.forName(this.curItem.toString()));
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new SAXParseException("Unable to find class " + this.curItem.toString() + " in property list " + this.itemListName, this.locator);
                    }
                }
                case "propertymap": {
                    if (this.rpd.contains(this.mapName) && !this.overriding) {
                        throw new SAXParseException("Duplicate property: " + this.mapName, this.locator);
                    }
                    this.rpd.add(this.mapName, new MapProperty(this.entryMap));
                    this.entryMap = null;
                    break;
                }
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

