/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance;

import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.FloatProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class MapProvenance<T extends Provenance>
implements Provenance,
Iterable<Pair<String, T>> {
    private static final long serialVersionUID = 1L;
    private final Map<String, T> map;

    public MapProvenance(Map<String, T> map) {
        this.map = Collections.unmodifiableMap(new HashMap<String, T>(map));
    }

    public MapProvenance() {
        this.map = Collections.emptyMap();
    }

    public Map<String, T> getMap() {
        return this.map;
    }

    @Override
    public Iterator<Pair<String, T>> iterator() {
        return new MapProvenanceIterator<T>(this.map.entrySet().iterator());
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapProvenance)) {
            return false;
        }
        MapProvenance that = (MapProvenance)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static <T extends Provenance, U extends Provenancable<T>> MapProvenance<T> createMapProvenance(Map<String, U> map) {
        if (map == null || map.isEmpty()) {
            return new MapProvenance<T>();
        }
        HashMap outputMap = new HashMap();
        for (Map.Entry<String, U> e : map.entrySet()) {
            outputMap.put(e.getKey(), ((Provenancable)e.getValue()).getProvenance());
        }
        return new MapProvenance(outputMap);
    }

    public static MapProvenance<FloatProvenance> createMapProvenanceFromFloats(Map<String, Float> map) {
        if (map == null || map.isEmpty()) {
            return new MapProvenance<FloatProvenance>();
        }
        HashMap<String, FloatProvenance> outputMap = new HashMap<String, FloatProvenance>();
        for (Map.Entry<String, Float> e : map.entrySet()) {
            outputMap.put(e.getKey(), new FloatProvenance(e.getKey(), e.getValue().floatValue()));
        }
        return new MapProvenance<FloatProvenance>(outputMap);
    }

    private static class MapProvenanceIterator<T extends Provenance>
    implements Iterator<Pair<String, T>> {
        private final Iterator<Map.Entry<String, T>> itr;

        public MapProvenanceIterator(Iterator<Map.Entry<String, T>> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Pair<String, T> next() {
            Map.Entry<String, T> item = this.itr.next();
            return new Pair<String, Provenance>(item.getKey(), (Provenance)item.getValue());
        }
    }
}

