/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.io;

import com.oracle.labs.mlrg.olcut.provenance.io.FlatMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ListMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.MapMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ObjectMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ProvenanceSerialization;
import com.oracle.labs.mlrg.olcut.provenance.io.ProvenanceSerializationException;
import com.oracle.labs.mlrg.olcut.provenance.io.SimpleMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLProvenanceSerialization
implements ProvenanceSerialization {
    public static final String PROVENANCES = "provenances";
    public static final String OBJECT_MARSHALLED_PROVENANCE = "object-provenance";
    public static final String LIST_MARSHALLED_PROVENANCE = "list-provenance";
    public static final String MAP_MARSHALLED_PROVENANCE = "map-provenance";
    public static final String SIMPLE_MARSHALLED_PROVENANCE = "simple-provenance";
    public static final String OBJECT_NAME = "obj-name";
    public static final String OBJECT_CLASS_NAME = "class-name";
    public static final String PROVENANCE_CLASS_NAME = "prov-class-name";
    public static final String PROV_KEY = "key";
    public static final String PROV_VALUE = "value";
    public static final String PROV_ADDITIONAL = "additional";
    public static final String IS_REFERENCE = "is-reference";
    private final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private final XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
    private final boolean prettyPrint;

    public XMLProvenanceSerialization(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public String getFileExtension() {
        return "xml";
    }

    @Override
    public List<ObjectMarshalledProvenance> deserializeFromFile(Path path) throws ProvenanceSerializationException, IOException {
        return this.parse(new InputSource(Files.newInputStream(path, new OpenOption[0])), path.toString());
    }

    @Override
    public List<ObjectMarshalledProvenance> deserializeFromString(String input) throws ProvenanceSerializationException {
        try {
            InputSource source = new InputSource(new StringReader(input));
            return this.parse(source, "");
        }
        catch (IOException e) {
            throw new ProvenanceSerializationException("Found an IOException when reading from an in-memory string", e);
        }
    }

    private List<ObjectMarshalledProvenance> parse(InputSource source, String location) throws ProvenanceSerializationException, IOException {
        try {
            ArrayList<ObjectMarshalledProvenance> outputList = new ArrayList<ObjectMarshalledProvenance>();
            XMLReader xr = this.saxFactory.newSAXParser().getXMLReader();
            ProvenanceSAXHandler handler = new ProvenanceSAXHandler(outputList);
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            xr.parse(source);
            return outputList;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Could not configure the SAX parser", e);
        }
        catch (SAXParseException e) {
            String msg = location != null && !location.isEmpty() ? "Error while parsing line " + e.getLineNumber() + " of " + location + ": " + e.getMessage() : "Error while parsing line " + e.getLineNumber() + " of input: " + e.getMessage();
            throw new ProvenanceSerializationException(msg, e);
        }
        catch (SAXException e) {
            throw new ProvenanceSerializationException("Problem with XML: " + e, e);
        }
    }

    @Override
    public String serializeToString(List<ObjectMarshalledProvenance> marshalledProvenances) {
        try {
            StringWriter strWriter = new StringWriter();
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(strWriter);
            this.writeProvenance(writer, marshalledProvenances);
            return strWriter.toString();
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException("Failed to serialize to XML", e);
        }
    }

    @Override
    public void serializeToFile(List<ObjectMarshalledProvenance> marshalledProvenances, Path path) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(bos, "utf-8");
            this.writeProvenance(writer, marshalledProvenances);
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException("Failed to serialize to XML", e);
        }
    }

    private void writeProvenance(XMLStreamWriter writer, List<ObjectMarshalledProvenance> marshalledProvenances) throws XMLStreamException {
        writer.writeStartDocument("utf-8", "1.0");
        if (this.prettyPrint) {
            writer.writeCharacters(System.lineSeparator());
        }
        writer.writeStartElement(PROVENANCES);
        if (this.prettyPrint) {
            writer.writeCharacters(System.lineSeparator());
        }
        for (ObjectMarshalledProvenance omp : marshalledProvenances) {
            this.writeOMP(writer, omp);
        }
        writer.writeEndDocument();
    }

    private void writeOMP(XMLStreamWriter writer, ObjectMarshalledProvenance omp) throws XMLStreamException {
        Map<String, FlatMarshalledProvenance> provMap = omp.getMap();
        if (this.prettyPrint) {
            writer.writeCharacters("\t");
        }
        if (!provMap.isEmpty()) {
            writer.writeStartElement(OBJECT_MARSHALLED_PROVENANCE);
        } else {
            writer.writeEmptyElement(OBJECT_MARSHALLED_PROVENANCE);
        }
        writer.writeAttribute(OBJECT_NAME, omp.getName());
        writer.writeAttribute(OBJECT_CLASS_NAME, omp.getObjectClassName());
        writer.writeAttribute(PROVENANCE_CLASS_NAME, omp.getProvenanceClassName());
        if (!provMap.isEmpty()) {
            if (this.prettyPrint) {
                writer.writeCharacters(System.lineSeparator());
            }
            for (Map.Entry<String, FlatMarshalledProvenance> e : provMap.entrySet()) {
                this.dispatchFMP(writer, e.getKey(), e.getValue(), 2);
            }
            if (this.prettyPrint) {
                writer.writeCharacters("\t");
            }
            writer.writeEndElement();
        }
        if (this.prettyPrint) {
            writer.writeCharacters(System.lineSeparator());
        }
    }

    private void writeSMP(XMLStreamWriter writer, SimpleMarshalledProvenance smp, int depth) throws XMLStreamException {
        if (this.prettyPrint) {
            for (int i = 0; i < depth; ++i) {
                writer.writeCharacters("\t");
            }
        }
        writer.writeEmptyElement(SIMPLE_MARSHALLED_PROVENANCE);
        writer.writeAttribute(PROV_KEY, smp.getKey());
        writer.writeAttribute(PROV_VALUE, smp.getValue());
        writer.writeAttribute(PROV_ADDITIONAL, smp.getAdditional());
        writer.writeAttribute(PROVENANCE_CLASS_NAME, smp.getProvenanceClassName());
        writer.writeAttribute(IS_REFERENCE, "" + smp.isReference());
        if (this.prettyPrint) {
            writer.writeCharacters(System.lineSeparator());
        }
    }

    private void writeLMP(XMLStreamWriter writer, String key, ListMarshalledProvenance lmp, int depth) throws XMLStreamException {
        if (this.prettyPrint) {
            for (int i = 0; i < depth; ++i) {
                writer.writeCharacters("\t");
            }
        }
        if (lmp.getList().isEmpty()) {
            writer.writeEmptyElement(LIST_MARSHALLED_PROVENANCE);
            writer.writeAttribute(PROV_KEY, key);
        } else {
            writer.writeStartElement(LIST_MARSHALLED_PROVENANCE);
            writer.writeAttribute(PROV_KEY, key);
            if (this.prettyPrint) {
                writer.writeCharacters(System.lineSeparator());
            }
            for (FlatMarshalledProvenance fmp : lmp.getList()) {
                this.dispatchFMP(writer, "", fmp, depth + 1);
            }
            if (this.prettyPrint) {
                for (int i = 0; i < depth; ++i) {
                    writer.writeCharacters("\t");
                }
            }
            writer.writeEndElement();
        }
        if (this.prettyPrint) {
            writer.writeCharacters(System.lineSeparator());
        }
    }

    private void writeMMP(XMLStreamWriter writer, String key, MapMarshalledProvenance mmp, int depth) throws XMLStreamException {
        if (this.prettyPrint) {
            for (int i = 0; i < depth; ++i) {
                writer.writeCharacters("\t");
            }
        }
        if (mmp.isEmpty()) {
            writer.writeEmptyElement(MAP_MARSHALLED_PROVENANCE);
            writer.writeAttribute(PROV_KEY, key);
        } else {
            writer.writeStartElement(MAP_MARSHALLED_PROVENANCE);
            writer.writeAttribute(PROV_KEY, key);
            if (this.prettyPrint) {
                writer.writeCharacters(System.lineSeparator());
            }
            for (Pair<String, FlatMarshalledProvenance> p : mmp) {
                this.dispatchFMP(writer, p.getA(), p.getB(), depth + 1);
            }
            if (this.prettyPrint) {
                for (int i = 0; i < depth; ++i) {
                    writer.writeCharacters("\t");
                }
            }
            writer.writeEndElement();
        }
        if (this.prettyPrint) {
            writer.writeCharacters(System.lineSeparator());
        }
    }

    private void dispatchFMP(XMLStreamWriter writer, String key, FlatMarshalledProvenance fmp, int depth) throws XMLStreamException {
        if (fmp instanceof SimpleMarshalledProvenance) {
            SimpleMarshalledProvenance smp = (SimpleMarshalledProvenance)fmp;
            this.writeSMP(writer, smp, depth);
        } else if (fmp instanceof ListMarshalledProvenance) {
            ListMarshalledProvenance lmp = (ListMarshalledProvenance)fmp;
            this.writeLMP(writer, key, lmp, depth);
        } else if (fmp instanceof MapMarshalledProvenance) {
            MapMarshalledProvenance mmp = (MapMarshalledProvenance)fmp;
            this.writeMMP(writer, key, mmp, depth);
        } else {
            throw new RuntimeException("Should not reach here, unexpected FlatMarshalledProvenance subclass " + fmp.getClass());
        }
    }

    private static class ProvenanceSAXHandler
    extends DefaultHandler {
        private Locator locator;
        private final List<ObjectMarshalledProvenance> provenanceList;
        private Map<String, String> ompAttributeMap;
        private Map<String, FlatMarshalledProvenance> ompProvMap;
        private Deque<ProvCollection> provenanceChain;
        private SimpleMarshalledProvenance curSMP;
        private String curKey;

        ProvenanceSAXHandler(List<ObjectMarshalledProvenance> provenanceList) {
            this.provenanceList = provenanceList;
            this.provenanceChain = new ArrayDeque<ProvCollection>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "provenances": {
                    break;
                }
                case "object-provenance": {
                    String curObjName = attributes.getValue(XMLProvenanceSerialization.OBJECT_NAME);
                    String curObjClassName = attributes.getValue(XMLProvenanceSerialization.OBJECT_CLASS_NAME);
                    String curProvClassName = attributes.getValue(XMLProvenanceSerialization.PROVENANCE_CLASS_NAME);
                    if (curObjName == null || curObjName.isEmpty() || curObjClassName == null || curObjClassName.isEmpty() || curProvClassName == null || curProvClassName.isEmpty()) {
                        throw new SAXParseException(String.format("%s element must specify '%s', '%s' and '%s' attributes", XMLProvenanceSerialization.OBJECT_MARSHALLED_PROVENANCE, XMLProvenanceSerialization.OBJECT_NAME, XMLProvenanceSerialization.OBJECT_CLASS_NAME, XMLProvenanceSerialization.PROVENANCE_CLASS_NAME), this.locator);
                    }
                    this.ompAttributeMap = new HashMap<String, String>();
                    this.ompProvMap = new HashMap<String, FlatMarshalledProvenance>();
                    this.ompAttributeMap.put(XMLProvenanceSerialization.OBJECT_NAME, curObjName);
                    this.ompAttributeMap.put(XMLProvenanceSerialization.OBJECT_CLASS_NAME, curObjClassName);
                    this.ompAttributeMap.put(XMLProvenanceSerialization.PROVENANCE_CLASS_NAME, curProvClassName);
                    break;
                }
                case "simple-provenance": {
                    String curKey = attributes.getValue(XMLProvenanceSerialization.PROV_KEY);
                    String curValue = attributes.getValue(XMLProvenanceSerialization.PROV_VALUE);
                    String curAdditional = attributes.getValue(XMLProvenanceSerialization.PROV_ADDITIONAL);
                    String curProvClassName = attributes.getValue(XMLProvenanceSerialization.PROVENANCE_CLASS_NAME);
                    boolean isReference = Boolean.parseBoolean(attributes.getValue(XMLProvenanceSerialization.IS_REFERENCE));
                    if (curKey == null || curKey.isEmpty() || curValue == null || curAdditional == null || curProvClassName == null || curProvClassName.isEmpty()) {
                        throw new SAXParseException(String.format("%s element must specify '%s', '%s' and '%s' attributes", XMLProvenanceSerialization.SIMPLE_MARSHALLED_PROVENANCE, XMLProvenanceSerialization.PROV_KEY, XMLProvenanceSerialization.PROV_VALUE, XMLProvenanceSerialization.PROVENANCE_CLASS_NAME), this.locator);
                    }
                    this.curSMP = new SimpleMarshalledProvenance(curKey, curValue, curProvClassName, isReference, curAdditional);
                    break;
                }
                case "list-provenance": 
                case "map-provenance": {
                    String curKey = attributes.getValue(XMLProvenanceSerialization.PROV_KEY);
                    if (curKey == null || curKey.isEmpty() && (this.provenanceChain.isEmpty() || this.provenanceChain.peekLast().isMap())) {
                        throw new SAXParseException(String.format("%s element must specify '%s'", qName, XMLProvenanceSerialization.PROV_KEY), this.locator);
                    }
                    ProvCollection pc = new ProvCollection(curKey, qName.equals(XMLProvenanceSerialization.MAP_MARSHALLED_PROVENANCE));
                    this.provenanceChain.addLast(pc);
                    break;
                }
                default: {
                    throw new SAXParseException("Unknown element '" + qName + "'", this.locator);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXParseException {
            switch (qName) {
                case "provenances": {
                    break;
                }
                case "object-provenance": {
                    ObjectMarshalledProvenance omp = new ObjectMarshalledProvenance(this.ompAttributeMap.get(XMLProvenanceSerialization.OBJECT_NAME), this.ompProvMap, this.ompAttributeMap.get(XMLProvenanceSerialization.OBJECT_CLASS_NAME), this.ompAttributeMap.get(XMLProvenanceSerialization.PROVENANCE_CLASS_NAME));
                    this.provenanceList.add(omp);
                    if (this.provenanceChain.isEmpty()) break;
                    throw new SAXParseException("Not cleared all the elements of the provenance chain when closing a ObjectMarshalledProvenance, found " + this.provenanceChain.size(), this.locator);
                }
                case "simple-provenance": {
                    if (this.curSMP != null) {
                        if (this.provenanceChain.isEmpty()) {
                            this.ompProvMap.put(this.curSMP.getKey(), this.curSMP);
                        } else {
                            ProvCollection pc = this.provenanceChain.peekLast();
                            if (pc.isMap()) {
                                pc.addProvenance(this.curSMP.getKey(), this.curSMP);
                            } else {
                                pc.addProvenance(this.curSMP);
                            }
                        }
                        this.curSMP = null;
                        break;
                    }
                    throw new SAXParseException("Found a SMP close without matching SMP open", this.locator);
                }
                case "list-provenance": 
                case "map-provenance": {
                    if (!this.provenanceChain.isEmpty()) {
                        Pair<String, FlatMarshalledProvenance> pair = this.provenanceChain.pollLast().emitProvenance();
                        if (this.provenanceChain.isEmpty()) {
                            this.ompProvMap.put(pair.getA(), pair.getB());
                            break;
                        }
                        ProvCollection pc = this.provenanceChain.peekLast();
                        if (pc.isMap()) {
                            pc.addProvenance(pair.getA(), pair.getB());
                            break;
                        }
                        pc.addProvenance(pair.getB());
                        break;
                    }
                    throw new SAXParseException("Found a LMP or MMP close without matching LMP/MMP open", this.locator);
                }
                default: {
                    throw new SAXParseException("Unknown element '" + qName + "'", this.locator);
                }
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    private static class ProvCollection {
        private final String key;
        private final boolean isMap;
        private final Map<String, FlatMarshalledProvenance> fmpMap;
        private final List<FlatMarshalledProvenance> fmpList;

        ProvCollection(String key, boolean isMap) {
            this.key = key;
            this.isMap = isMap;
            if (isMap) {
                this.fmpMap = new HashMap<String, FlatMarshalledProvenance>();
                this.fmpList = Collections.emptyList();
            } else {
                this.fmpMap = Collections.emptyMap();
                this.fmpList = new ArrayList<FlatMarshalledProvenance>();
            }
        }

        public boolean isMap() {
            return this.isMap;
        }

        public void addProvenance(FlatMarshalledProvenance newFMP) {
            if (this.isMap) {
                throw new IllegalStateException("Added a list element to a map provenance");
            }
            this.fmpList.add(newFMP);
        }

        public void addProvenance(String key, FlatMarshalledProvenance newFMP) {
            if (!this.isMap) {
                throw new IllegalStateException("Added a map element to a list provenance");
            }
            this.fmpMap.put(key, newFMP);
        }

        public Pair<String, FlatMarshalledProvenance> emitProvenance() {
            if (this.isMap) {
                return new Pair<String, FlatMarshalledProvenance>(this.key, new MapMarshalledProvenance(this.fmpMap));
            }
            return new Pair<String, FlatMarshalledProvenance>(this.key, new ListMarshalledProvenance(this.fmpList));
        }
    }
}

