/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.primitives;

import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import java.util.Objects;

public final class EnumProvenance<E extends Enum>
implements PrimitiveProvenance<E> {
    private static final long serialVersionUID = 1L;
    private final String key;
    private final E value;
    private final String enumClass;

    public EnumProvenance(String key, E value) {
        this.key = key;
        this.value = value;
        this.enumClass = value.getClass().getName();
    }

    public String getEnumClass() {
        return this.enumClass;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public E getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumProvenance)) {
            return false;
        }
        EnumProvenance that = (EnumProvenance)o;
        return this.key.equals(that.key) && ((Enum)this.value).equals(that.value) && this.enumClass.equals(that.enumClass);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.enumClass);
    }

    public String toString() {
        return ((Enum)this.value).toString();
    }
}

