/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.common.blobstore.url;

import io.lucenia.common.blobstore.url.URLBlobContainer;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.core.blobstore.BlobStore;
import io.skylite.core.blobstore.BlobStoreException;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.settings.Settings;
import java.net.MalformedURLException;
import java.net.URL;

public class URLBlobStore
implements BlobStore {
    private final URL path;
    private final int bufferSizeInBytes;

    public URLBlobStore(Settings settings, URL path) {
        this.path = path;
        this.bufferSizeInBytes = (int)settings.getAsBytesSize("repositories.uri.buffer_size", new ByteSizeValue(100L, ByteSizeUnit.KB)).getBytes();
    }

    public String toString() {
        return this.path.toString();
    }

    public URL path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public BlobContainer blobContainer(BlobPath path) {
        try {
            return new URLBlobContainer(this, path, this.buildPath(path));
        }
        catch (MalformedURLException ex) {
            throw new BlobStoreException("malformed URL " + String.valueOf(path), (Throwable)ex);
        }
    }

    public void close() {
    }

    private URL buildPath(BlobPath path) throws MalformedURLException {
        String[] paths = path.toArray();
        if (paths.length == 0) {
            return this.path();
        }
        URL blobPath = new URL(this.path, paths[0] + "/");
        if (paths.length > 1) {
            for (int i = 1; i < paths.length; ++i) {
                blobPath = new URL(blobPath, paths[i] + "/");
            }
        }
        return blobPath;
    }
}

