/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import com.google.common.annotations.VisibleForTesting;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.lucene.Lucene;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.codec.util.NativeMemoryCacheKeyHelper;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryEntryContext;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;
import org.opensearch.knn.index.util.IndexUtil;

public class KNNIndexShard {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNIndexShard.class);
    private final IndexShard indexShard;
    private final NativeMemoryCacheManager nativeMemoryCacheManager;
    private static final String INDEX_SHARD_CLEAR_CACHE_SEARCHER = "knn-clear-cache";

    public KNNIndexShard(BaseIndexShard indexShard) {
        this.indexShard = (IndexShard)indexShard;
        this.nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();
    }

    public IndexShard getIndexShard() {
        return this.indexShard;
    }

    public String getIndexName() {
        return this.indexShard.shardId().getIndexName();
    }

    public void warmup() throws IOException {
        log.info("[KNN] Warming up index: [{}]", (Object)this.getIndexName());
        Directory directory = this.indexShard.store().directory();
        try (Engine.Searcher searcher = this.indexShard.acquireSearcher("knn-warmup");){
            this.getAllEngineFileContexts(searcher.getIndexReader()).forEach(engineFileContext -> {
                try {
                    String cacheKey = NativeMemoryCacheKeyHelper.constructCacheKey(engineFileContext.vectorFileName, engineFileContext.segmentInfo);
                    this.nativeMemoryCacheManager.get(new NativeMemoryEntryContext.IndexEntryContext(directory, cacheKey, NativeMemoryLoadStrategy.IndexLoadStrategy.getInstance(), IndexUtil.getParametersAtLoading(engineFileContext.getSpaceType(), KNNEngine.getEngineNameFromPath(engineFileContext.getVectorFileName()), this.getIndexName(), engineFileContext.getVectorDataType()), this.getIndexName(), engineFileContext.getModelId()), true);
                }
                catch (ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
    }

    public void clearCache() {
        String indexName = this.getIndexName();
        Optional<NativeMemoryAllocation> indexAllocationOptional = this.nativeMemoryCacheManager.getIndexMemoryAllocation(indexName);
        if (indexAllocationOptional.isPresent()) {
            NativeMemoryAllocation indexAllocation = indexAllocationOptional.get();
            indexAllocation.writeLock();
            log.info("[KNN] Evicting index from cache: [{}]", (Object)indexName);
            try (Engine.Searcher searcher = this.indexShard.acquireSearcher(INDEX_SHARD_CLEAR_CACHE_SEARCHER);){
                this.getAllEngineFileContexts(searcher.getIndexReader()).forEach(engineFileContext -> {
                    String cacheKey = NativeMemoryCacheKeyHelper.constructCacheKey(engineFileContext.vectorFileName, engineFileContext.segmentInfo);
                    this.nativeMemoryCacheManager.invalidate(cacheKey);
                });
            }
            catch (IOException ex) {
                log.error("[KNN] Failed to evict index from cache: [{}]", (Object)indexName, (Object)ex);
                throw new RuntimeException(ex);
            }
            finally {
                indexAllocation.writeUnlock();
            }
        }
    }

    @VisibleForTesting
    List<EngineFileContext> getAllEngineFileContexts(IndexReader indexReader) throws IOException {
        ArrayList<EngineFileContext> engineFiles = new ArrayList<EngineFileContext>();
        for (KNNEngine knnEngine : KNNEngine.getEnginesThatCreateCustomSegmentFiles()) {
            engineFiles.addAll(this.getEngineFileContexts(indexReader, knnEngine));
        }
        return engineFiles;
    }

    List<EngineFileContext> getEngineFileContexts(IndexReader indexReader, KNNEngine knnEngine) throws IOException {
        ArrayList<EngineFileContext> engineFiles = new ArrayList<EngineFileContext>();
        for (LeafReaderContext leafReaderContext : indexReader.leaves()) {
            SegmentReader reader = Lucene.segmentReader((LeafReader)leafReaderContext.reader());
            String fileExtension = reader.getSegmentInfo().info.getUseCompoundFile() ? knnEngine.getCompoundExtension() : knnEngine.getExtension();
            for (FieldInfo fieldInfo : reader.getFieldInfos()) {
                if (!fieldInfo.attributes().containsKey("knn_field")) continue;
                String spaceTypeName = fieldInfo.attributes().getOrDefault("spaceType", SpaceType.L2.getValue());
                SpaceType spaceType = SpaceType.getSpace(spaceTypeName);
                String modelId = fieldInfo.attributes().getOrDefault("model_id", null);
                engineFiles.addAll(this.getEngineFileContexts(reader.getSegmentInfo(), fieldInfo.name, fileExtension, spaceType, modelId, FieldInfoExtractor.extractQuantizationConfig(fieldInfo) == QuantizationConfig.EMPTY ? VectorDataType.get(fieldInfo.attributes().getOrDefault("data_type", VectorDataType.FLOAT.getValue())) : VectorDataType.BINARY));
            }
        }
        return engineFiles;
    }

    @VisibleForTesting
    List<EngineFileContext> getEngineFileContexts(SegmentCommitInfo segmentCommitInfo, String fieldName, String fileExtension, SpaceType spaceType, String modelId, VectorDataType vectorDataType) throws IOException {
        String prefix = KNNCodecUtil.buildEngineFilePrefix(segmentCommitInfo.info.name);
        String suffix = KNNCodecUtil.buildEngineFileSuffix(fieldName, fileExtension);
        return segmentCommitInfo.files().stream().filter(fileName -> fileName.startsWith(prefix)).filter(fileName -> fileName.endsWith(suffix)).map(vectorFileName -> new EngineFileContext(spaceType, modelId, (String)vectorFileName, vectorDataType, segmentCommitInfo.info)).collect(Collectors.toList());
    }

    @VisibleForTesting
    static class EngineFileContext {
        private final SpaceType spaceType;
        private final String modelId;
        private final String vectorFileName;
        private final VectorDataType vectorDataType;
        private final SegmentInfo segmentInfo;

        @Generated
        public EngineFileContext(SpaceType spaceType, String modelId, String vectorFileName, VectorDataType vectorDataType, SegmentInfo segmentInfo) {
            this.spaceType = spaceType;
            this.modelId = modelId;
            this.vectorFileName = vectorFileName;
            this.vectorDataType = vectorDataType;
            this.segmentInfo = segmentInfo;
        }

        @Generated
        public SpaceType getSpaceType() {
            return this.spaceType;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public String getVectorFileName() {
            return this.vectorFileName;
        }

        @Generated
        public VectorDataType getVectorDataType() {
            return this.vectorDataType;
        }

        @Generated
        public SegmentInfo getSegmentInfo() {
            return this.segmentInfo;
        }
    }
}

