/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.jni.JNICommons;
import org.opensearch.knn.training.BinaryTrainingDataConsumer;
import org.opensearch.knn.training.ByteTrainingDataConsumer;
import org.opensearch.knn.training.FloatTrainingDataConsumer;
import org.opensearch.knn.training.TrainingDataConsumer;

public enum VectorDataType {
    BINARY("binary"){

        @Override
        public VectorEncoding getVectorEncoding() {
            return null;
        }

        @Override
        public FieldType createKnnVectorFieldType(int dimension, KNNVectorSimilarityFunction knnVectorSimilarityFunction) {
            return KnnByteVectorField.createFieldType((int)(dimension / 8), (VectorSimilarityFunction)VectorSimilarityFunction.EUCLIDEAN);
        }

        @Override
        public float[] getVectorFromBytesRef(BytesRef binaryValue) {
            float[] vector = new float[binaryValue.length];
            int i = 0;
            int j = binaryValue.offset;
            while (i < binaryValue.length) {
                vector[i++] = binaryValue.bytes[j++];
            }
            return vector;
        }

        @Override
        public TrainingDataConsumer getTrainingDataConsumer(NativeMemoryAllocation.TrainingDataAllocation trainingDataAllocation) {
            return new BinaryTrainingDataConsumer(trainingDataAllocation);
        }

        @Override
        public void freeNativeMemory(long memoryAddress) {
            JNICommons.freeBinaryVectorData(memoryAddress);
        }
    }
    ,
    BYTE("byte"){

        @Override
        public VectorEncoding getVectorEncoding() {
            return VectorEncoding.BYTE;
        }

        @Override
        public FieldType createKnnVectorFieldType(int dimension, KNNVectorSimilarityFunction knnVectorSimilarityFunction) {
            return KnnByteVectorField.createFieldType((int)dimension, (VectorSimilarityFunction)knnVectorSimilarityFunction.getVectorSimilarityFunction());
        }

        @Override
        public float[] getVectorFromBytesRef(BytesRef binaryValue) {
            float[] vector = new float[binaryValue.length];
            int i = 0;
            int j = binaryValue.offset;
            while (i < binaryValue.length) {
                vector[i++] = binaryValue.bytes[j++];
            }
            return vector;
        }

        @Override
        public TrainingDataConsumer getTrainingDataConsumer(NativeMemoryAllocation.TrainingDataAllocation trainingDataAllocation) {
            return new ByteTrainingDataConsumer(trainingDataAllocation);
        }

        @Override
        public void freeNativeMemory(long memoryAddress) {
            JNICommons.freeByteVectorData(memoryAddress);
        }
    }
    ,
    FLOAT("float"){

        @Override
        public VectorEncoding getVectorEncoding() {
            return VectorEncoding.FLOAT32;
        }

        @Override
        public FieldType createKnnVectorFieldType(int dimension, KNNVectorSimilarityFunction knnVectorSimilarityFunction) {
            return KnnFloatVectorField.createFieldType((int)dimension, (VectorSimilarityFunction)knnVectorSimilarityFunction.getVectorSimilarityFunction());
        }

        @Override
        public float[] getVectorFromBytesRef(BytesRef binaryValue) {
            KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByBytesRef(binaryValue);
            return vectorSerializer.byteToFloatArray(binaryValue);
        }

        @Override
        public TrainingDataConsumer getTrainingDataConsumer(NativeMemoryAllocation.TrainingDataAllocation trainingDataAllocation) {
            return new FloatTrainingDataConsumer(trainingDataAllocation);
        }

        @Override
        public void freeNativeMemory(long memoryAddress) {
            JNICommons.freeVectorData(memoryAddress);
        }
    };

    public static final String SUPPORTED_VECTOR_DATA_TYPES;
    private final String value;
    public static VectorDataType DEFAULT;

    public abstract FieldType createKnnVectorFieldType(int var1, KNNVectorSimilarityFunction var2);

    public abstract float[] getVectorFromBytesRef(BytesRef var1);

    public abstract TrainingDataConsumer getTrainingDataConsumer(NativeMemoryAllocation.TrainingDataAllocation var1);

    public abstract VectorEncoding getVectorEncoding();

    public abstract void freeNativeMemory(long var1);

    public static VectorDataType get(String vectorDataType) {
        Objects.requireNonNull(vectorDataType, String.format(Locale.ROOT, "[%s] should not be null. Supported types are [%s]", "data_type", SUPPORTED_VECTOR_DATA_TYPES));
        try {
            return VectorDataType.valueOf(vectorDataType.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid value provided for [%s] field. Supported values are [%s]", "data_type", SUPPORTED_VECTOR_DATA_TYPES));
        }
    }

    @Generated
    private VectorDataType(String value) {
        this.value = value;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    static {
        SUPPORTED_VECTOR_DATA_TYPES = Arrays.stream(VectorDataType.values()).map(VectorDataType::getValue).collect(Collectors.joining(","));
        DEFAULT = FLOAT;
    }
}

