/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec;

import io.skylite.core.index.IndexSettings;
import io.skylite.core.mapper.MapperService;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.codec.KNN990Codec.NativeEngines990KnnVectorsFormat;
import org.opensearch.knn.index.codec.params.KNNScalarQuantizedVectorsFormatParams;
import org.opensearch.knn.index.codec.params.KNNVectorsFormatParams;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;

public abstract class BasePerFieldKnnVectorsFormat
extends PerFieldKnnVectorsFormat {
    @Generated
    private static final Logger log = LogManager.getLogger(BasePerFieldKnnVectorsFormat.class);
    private final Optional<MapperService> mapperService;
    private final int defaultMaxConnections;
    private final int defaultBeamWidth;
    private final Supplier<KnnVectorsFormat> defaultFormatSupplier;
    private final Function<KNNVectorsFormatParams, KnnVectorsFormat> vectorsFormatSupplier;
    private Function<KNNScalarQuantizedVectorsFormatParams, KnnVectorsFormat> scalarQuantizedVectorsFormatSupplier;
    private static final String MAX_CONNECTIONS = "max_connections";
    private static final String BEAM_WIDTH = "beam_width";

    public BasePerFieldKnnVectorsFormat(Optional<MapperService> mapperService, int defaultMaxConnections, int defaultBeamWidth, Supplier<KnnVectorsFormat> defaultFormatSupplier, Function<KNNVectorsFormatParams, KnnVectorsFormat> vectorsFormatSupplier) {
        this.mapperService = mapperService;
        this.defaultMaxConnections = defaultMaxConnections;
        this.defaultBeamWidth = defaultBeamWidth;
        this.defaultFormatSupplier = defaultFormatSupplier;
        this.vectorsFormatSupplier = vectorsFormatSupplier;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        if (!this.isKnnVectorFieldType(field)) {
            log.debug("Initialize KNN vector format for field [{}] with default params [{}] = \"{}\" and [{}] = \"{}\"", (Object)field, (Object)MAX_CONNECTIONS, (Object)this.defaultMaxConnections, (Object)BEAM_WIDTH, (Object)this.defaultBeamWidth);
            return this.defaultFormatSupplier.get();
        }
        KNNVectorFieldType mappedFieldType = (KNNVectorFieldType)this.mapperService.orElseThrow(() -> new IllegalStateException(String.format(Locale.ROOT, "Cannot read field type for field [%s] because mapper service is not available", field))).fieldType(field);
        KNNMappingConfig knnMappingConfig = mappedFieldType.getKnnMappingConfig();
        if (knnMappingConfig.getModelId().isPresent()) {
            return this.nativeEngineVectorsFormat();
        }
        KNNMethodContext knnMethodContext = knnMappingConfig.getKnnMethodContext().orElseThrow(() -> new IllegalArgumentException("KNN method context cannot be empty"));
        KNNEngine engine = knnMethodContext.getKnnEngine();
        Map<String, Object> params = knnMethodContext.getMethodComponentContext().getParameters();
        if (engine == KNNEngine.LUCENE) {
            KNNScalarQuantizedVectorsFormatParams knnScalarQuantizedVectorsFormatParams;
            if (params != null && params.containsKey("encoder") && (knnScalarQuantizedVectorsFormatParams = new KNNScalarQuantizedVectorsFormatParams(params, this.defaultMaxConnections, this.defaultBeamWidth)).validate(params)) {
                log.debug("Initialize KNN vector format for field [{}] with params [{}] = \"{}\", [{}] = \"{}\", [{}] = \"{}\", [{}] = \"{}\"", (Object)field, (Object)MAX_CONNECTIONS, (Object)knnScalarQuantizedVectorsFormatParams.getMaxConnections(), (Object)BEAM_WIDTH, (Object)knnScalarQuantizedVectorsFormatParams.getBeamWidth(), (Object)"confidence_interval", (Object)knnScalarQuantizedVectorsFormatParams.getConfidenceInterval(), (Object)"bits", (Object)knnScalarQuantizedVectorsFormatParams.getBits());
                return this.scalarQuantizedVectorsFormatSupplier.apply(knnScalarQuantizedVectorsFormatParams);
            }
            KNNVectorsFormatParams knnVectorsFormatParams = new KNNVectorsFormatParams(params, this.defaultMaxConnections, this.defaultBeamWidth, knnMethodContext.getSpaceType());
            log.debug("Initialize KNN vector format for field [{}] with params [{}] = \"{}\" and [{}] = \"{}\"", (Object)field, (Object)MAX_CONNECTIONS, (Object)knnVectorsFormatParams.getMaxConnections(), (Object)BEAM_WIDTH, (Object)knnVectorsFormatParams.getBeamWidth());
            return this.vectorsFormatSupplier.apply(knnVectorsFormatParams);
        }
        return this.nativeEngineVectorsFormat();
    }

    private NativeEngines990KnnVectorsFormat nativeEngineVectorsFormat() {
        int approximateThreshold = this.getApproximateThresholdValue();
        return new NativeEngines990KnnVectorsFormat((FlatVectorsFormat)new Lucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer()), approximateThreshold);
    }

    private int getApproximateThresholdValue() {
        IndexSettings indexSettings = this.mapperService.get().getIndexSettings();
        Integer approximateThresholdValue = (Integer)indexSettings.getValue(KNNSettings.INDEX_KNN_ADVANCED_APPROXIMATE_THRESHOLD_SETTING);
        return approximateThresholdValue != null ? approximateThresholdValue : KNNSettings.INDEX_KNN_ADVANCED_APPROXIMATE_THRESHOLD_DEFAULT_VALUE;
    }

    public int getMaxDimensions(String fieldName) {
        return this.getKnnVectorsFormatForField(fieldName).getMaxDimensions(fieldName);
    }

    private boolean isKnnVectorFieldType(String field) {
        return this.mapperService.isPresent() && this.mapperService.get().fieldType(field) instanceof KNNVectorFieldType;
    }

    @Generated
    public BasePerFieldKnnVectorsFormat(Optional<MapperService> mapperService, int defaultMaxConnections, int defaultBeamWidth, Supplier<KnnVectorsFormat> defaultFormatSupplier, Function<KNNVectorsFormatParams, KnnVectorsFormat> vectorsFormatSupplier, Function<KNNScalarQuantizedVectorsFormatParams, KnnVectorsFormat> scalarQuantizedVectorsFormatSupplier) {
        this.mapperService = mapperService;
        this.defaultMaxConnections = defaultMaxConnections;
        this.defaultBeamWidth = defaultBeamWidth;
        this.defaultFormatSupplier = defaultFormatSupplier;
        this.vectorsFormatSupplier = vectorsFormatSupplier;
        this.scalarQuantizedVectorsFormatSupplier = scalarQuantizedVectorsFormatSupplier;
    }
}

