/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN80Codec;

import io.skylite.common.StopWatch;
import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.util.Bits;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80BinaryDocValues;
import org.opensearch.knn.index.codec.util.BinaryDocValuesSub;

class KNN80DocValuesReader
extends EmptyDocValuesProducer {
    @Generated
    private static final Logger log = LogManager.getLogger(KNN80DocValuesReader.class);
    private final MergeState mergeState;

    KNN80DocValuesReader(MergeState mergeState) {
        this.mergeState = mergeState;
    }

    public BinaryDocValues getBinary(FieldInfo field) {
        long totalLiveDocs = 0L;
        try {
            ArrayList<BinaryDocValuesSub> subs = new ArrayList<BinaryDocValuesSub>(this.mergeState.docValuesProducers.length);
            for (int i = 0; i < this.mergeState.docValuesProducers.length; ++i) {
                BinaryDocValues values = null;
                DocValuesProducer docValuesProducer = this.mergeState.docValuesProducers[i];
                if (docValuesProducer == null) continue;
                FieldInfo readerFieldInfo = this.mergeState.fieldInfos[i].fieldInfo(field.name);
                if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                    values = docValuesProducer.getBinary(readerFieldInfo);
                }
                if (values == null) continue;
                totalLiveDocs += this.getLiveDocsCount(values, this.mergeState.liveDocs[i]);
                values = this.mergeState.liveDocs[i] != null ? docValuesProducer.getBinary(readerFieldInfo) : values;
                subs.add(new BinaryDocValuesSub(this.mergeState.docMaps[i], values));
            }
            return new KNN80BinaryDocValues((DocIDMerger<BinaryDocValuesSub>)DocIDMerger.of(subs, (boolean)this.mergeState.needsIndexSort)).setTotalLiveDocs(totalLiveDocs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long getLiveDocsCount(BinaryDocValues binaryDocValues, Bits liveDocsBits) throws IOException {
        long liveDocs = 0L;
        if (liveDocsBits != null) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            int docId = binaryDocValues.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                if (liveDocsBits.get(docId)) {
                    ++liveDocs;
                }
                docId = binaryDocValues.nextDoc();
            }
            stopWatch.stop();
            log.debug("Time taken to iterate over binary doc values: {} ms", (Object)stopWatch.totalTime().millis());
        } else {
            liveDocs = binaryDocValues.cost();
        }
        return liveDocs;
    }
}

