/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentInfo;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80BinaryDocValues;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;

public class KNNCodecUtil {
    public static final int FLOAT_BYTE_SIZE = 4;

    public static long calculateArraySize(int numVectors, int vectorLength, VectorDataType vectorDataType) {
        if (vectorDataType == VectorDataType.FLOAT) {
            return numVectors * vectorLength * 4;
        }
        if (vectorDataType == VectorDataType.BINARY || vectorDataType == VectorDataType.BYTE) {
            return numVectors * vectorLength;
        }
        throw new IllegalArgumentException("Float, binary, and byte are the only supported vector data types for array size calculation.");
    }

    public static String buildEngineFileName(String segmentName, String latestBuildVersion, String fieldName, String extension) {
        return String.format(Locale.ROOT, "%s%s%s", KNNCodecUtil.buildEngineFilePrefix(segmentName), latestBuildVersion, KNNCodecUtil.buildEngineFileSuffix(fieldName, extension));
    }

    public static String buildEngineFilePrefix(String segmentName) {
        return String.format(Locale.ROOT, "%s_", segmentName);
    }

    public static String buildEngineFileSuffix(String fieldName, String extension) {
        return String.format(Locale.ROOT, "_%s%s", fieldName, extension);
    }

    public static long getTotalLiveDocsCount(BinaryDocValues binaryDocValues) {
        long totalLiveDocs = binaryDocValues instanceof KNN80BinaryDocValues ? ((KNN80BinaryDocValues)binaryDocValues).getTotalLiveDocs() : binaryDocValues.cost();
        return totalLiveDocs;
    }

    public static List<String> getEngineFiles(String extension, String fieldName, SegmentInfo segmentInfo) {
        Object engineExtension = segmentInfo.getUseCompoundFile() ? extension + "c" : extension;
        String engineSuffix = fieldName + (String)engineExtension;
        String underLineEngineSuffix = "_" + engineSuffix;
        List<String> engineFiles = segmentInfo.files().stream().filter(fileName -> fileName.endsWith(underLineEngineSuffix)).sorted(Comparator.comparingInt(String::length)).collect(Collectors.toList());
        return engineFiles;
    }

    public static String getNativeEngineFileFromFieldInfo(FieldInfo field, SegmentInfo segmentInfo) {
        if (!field.attributes().containsKey("knn_field")) {
            return null;
        }
        KNNEngine knnEngine = KNNCodecUtil.getNativeKNNEngine(field);
        if (knnEngine == null) {
            return null;
        }
        List<String> engineFiles = KNNCodecUtil.getEngineFiles(knnEngine.getExtension(), field.name, segmentInfo);
        if (engineFiles.isEmpty()) {
            return null;
        }
        String vectorIndexFileName = engineFiles.get(0);
        return vectorIndexFileName;
    }

    public static void initializeVectorValues(KNNVectorValues<?> vectorValues) throws IOException {
        if (vectorValues.docId() != -1) {
            return;
        }
        vectorValues.nextDoc();
        if (vectorValues.docId() == Integer.MAX_VALUE) {
            return;
        }
        vectorValues.getVector();
    }

    private static KNNEngine getNativeKNNEngine(@NonNull FieldInfo field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        KNNEngine engine = FieldInfoExtractor.extractKNNEngine(field);
        if (KNNEngine.getEnginesThatCreateCustomSegmentFiles().contains(engine)) {
            return engine;
        }
        return null;
    }
}

