/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import io.skylite.common.ValidationException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContextImpl;
import org.opensearch.knn.index.engine.KNNLibrarySearchContext;
import org.opensearch.knn.index.engine.KNNMethod;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.SpaceVectorValidator;
import org.opensearch.knn.index.mapper.VectorValidator;

public abstract class AbstractKNNMethod
implements KNNMethod {
    protected final MethodComponent methodComponent;
    protected final Set<SpaceType> spaces;
    protected final KNNLibrarySearchContext knnLibrarySearchContext;

    @Override
    public boolean isSpaceTypeSupported(SpaceType space) {
        return this.spaces.contains((Object)space);
    }

    @Override
    public ValidationException validate(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        ValidationException methodValidation;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.isSpaceTypeSupported(knnMethodContext.getSpaceType())) {
            errorMessages.add(String.format(Locale.ROOT, "\"%s\" with \"%s\" configuration does not support space type: \"%s\".", this.methodComponent.getName(), knnMethodContext.getKnnEngine().getName().toLowerCase(Locale.ROOT), knnMethodContext.getSpaceType().getValue()));
        }
        if ((methodValidation = this.methodComponent.validate(knnMethodContext.getMethodComponentContext(), knnMethodConfigContext)) != null) {
            errorMessages.addAll(methodValidation.validationErrors());
        }
        if (errorMessages.isEmpty()) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        validationException.addValidationErrors(errorMessages);
        return validationException;
    }

    @Override
    public boolean isTrainingRequired(KNNMethodContext knnMethodContext) {
        return this.methodComponent.isTrainingRequired(knnMethodContext.getMethodComponentContext());
    }

    @Override
    public int estimateOverheadInKB(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        return this.methodComponent.estimateOverheadInKB(knnMethodContext.getMethodComponentContext(), knnMethodConfigContext.getDimension());
    }

    protected PerDimensionValidator doGetPerDimensionValidator(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        VectorDataType vectorDataType = knnMethodConfigContext.getVectorDataType();
        if (VectorDataType.BINARY == vectorDataType) {
            return PerDimensionValidator.DEFAULT_BIT_VALIDATOR;
        }
        if (VectorDataType.BYTE == vectorDataType) {
            return PerDimensionValidator.DEFAULT_BYTE_VALIDATOR;
        }
        return PerDimensionValidator.DEFAULT_FLOAT_VALIDATOR;
    }

    protected VectorValidator doGetVectorValidator(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        return new SpaceVectorValidator(knnMethodContext.getSpaceType());
    }

    protected PerDimensionProcessor doGetPerDimensionProcessor(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        return PerDimensionProcessor.NOOP_PROCESSOR;
    }

    @Override
    public KNNLibraryIndexingContext getKNNLibraryIndexingContext(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        KNNLibraryIndexingContext knnLibraryIndexingContext = this.methodComponent.getKNNLibraryIndexingContext(knnMethodContext.getMethodComponentContext(), knnMethodConfigContext);
        Map<String, Object> parameterMap = knnLibraryIndexingContext.getLibraryParameters();
        parameterMap.put("spaceType", knnMethodContext.getSpaceType().getValue());
        parameterMap.put("data_type", knnMethodConfigContext.getVectorDataType().getValue());
        return KNNLibraryIndexingContextImpl.builder().quantizationConfig(knnLibraryIndexingContext.getQuantizationConfig()).parameters(parameterMap).vectorValidator(this.doGetVectorValidator(knnMethodContext, knnMethodConfigContext)).perDimensionValidator(this.doGetPerDimensionValidator(knnMethodContext, knnMethodConfigContext)).perDimensionProcessor(this.doGetPerDimensionProcessor(knnMethodContext, knnMethodConfigContext)).build();
    }

    @Override
    public KNNLibrarySearchContext getKNNLibrarySearchContext() {
        return this.knnLibrarySearchContext;
    }

    @Generated
    public AbstractKNNMethod(MethodComponent methodComponent, Set<SpaceType> spaces, KNNLibrarySearchContext knnLibrarySearchContext) {
        this.methodComponent = methodComponent;
        this.spaces = spaces;
        this.knnLibrarySearchContext = knnLibrarySearchContext;
    }
}

