/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import com.google.common.collect.ImmutableSet;
import io.skylite.common.ValidationException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.engine.KNNLibrary;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNLibrarySearchContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.ResolvedMethodContext;
import org.opensearch.knn.index.engine.faiss.Faiss;
import org.opensearch.knn.index.engine.lucene.Lucene;
import org.opensearch.knn.index.engine.nmslib.Nmslib;

public enum KNNEngine implements KNNLibrary
{
    NMSLIB("nmslib", Nmslib.INSTANCE),
    FAISS("faiss", Faiss.INSTANCE),
    LUCENE("lucene", Lucene.INSTANCE);

    public static final KNNEngine DEFAULT;
    private static final Set<KNNEngine> CUSTOM_SEGMENT_FILE_ENGINES;
    private static final Set<KNNEngine> ENGINES_SUPPORTING_FILTERS;
    public static final Set<KNNEngine> ENGINES_SUPPORTING_RADIAL_SEARCH;
    public static final Set<KNNEngine> ENGINES_SUPPORTING_MULTI_VECTORS;
    private static Map<KNNEngine, Integer> MAX_DIMENSIONS_BY_ENGINE;
    private final String name;
    private final KNNLibrary knnLibrary;

    private KNNEngine(String name, KNNLibrary knnLibrary) {
        this.name = name;
        this.knnLibrary = knnLibrary;
    }

    public static KNNEngine getEngine(String name) {
        if (NMSLIB.getName().equalsIgnoreCase(name)) {
            return NMSLIB;
        }
        if (FAISS.getName().equalsIgnoreCase(name)) {
            return FAISS;
        }
        if (LUCENE.getName().equalsIgnoreCase(name)) {
            return LUCENE;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid engine type: %s", name));
    }

    public static KNNEngine getEngineNameFromPath(String path) {
        if (path.endsWith(NMSLIB.getExtension()) || path.endsWith(NMSLIB.getCompoundExtension())) {
            return NMSLIB;
        }
        if (path.endsWith(FAISS.getExtension()) || path.endsWith(FAISS.getCompoundExtension())) {
            return FAISS;
        }
        throw new IllegalArgumentException("No engine matches the path's suffix");
    }

    public static Set<KNNEngine> getEnginesThatCreateCustomSegmentFiles() {
        return CUSTOM_SEGMENT_FILE_ENGINES;
    }

    public static Set<KNNEngine> getEnginesThatSupportsFilters() {
        return ENGINES_SUPPORTING_FILTERS;
    }

    public static int getMaxDimensionByEngine(KNNEngine knnEngine) {
        return MAX_DIMENSIONS_BY_ENGINE.getOrDefault(knnEngine, MAX_DIMENSIONS_BY_ENGINE.get(DEFAULT));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.knnLibrary.getVersion();
    }

    @Override
    public String getExtension() {
        return this.knnLibrary.getExtension();
    }

    @Override
    public String getCompoundExtension() {
        return this.knnLibrary.getCompoundExtension();
    }

    @Override
    public float score(float rawScore, SpaceType spaceType) {
        return this.knnLibrary.score(rawScore, spaceType);
    }

    @Override
    public Float distanceToRadialThreshold(Float distance, SpaceType spaceType) {
        return this.knnLibrary.distanceToRadialThreshold(distance, spaceType);
    }

    @Override
    public Float scoreToRadialThreshold(Float score, SpaceType spaceType) {
        return this.knnLibrary.scoreToRadialThreshold(score, spaceType);
    }

    @Override
    public ValidationException validateMethod(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        return this.knnLibrary.validateMethod(knnMethodContext, knnMethodConfigContext);
    }

    @Override
    public boolean isTrainingRequired(KNNMethodContext knnMethodContext) {
        return this.knnLibrary.isTrainingRequired(knnMethodContext);
    }

    @Override
    public KNNLibraryIndexingContext getKNNLibraryIndexingContext(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        return this.knnLibrary.getKNNLibraryIndexingContext(knnMethodContext, knnMethodConfigContext);
    }

    @Override
    public KNNLibrarySearchContext getKNNLibrarySearchContext(String methodName) {
        return this.knnLibrary.getKNNLibrarySearchContext(methodName);
    }

    @Override
    public int estimateOverheadInKB(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        return this.knnLibrary.estimateOverheadInKB(knnMethodContext, knnMethodConfigContext);
    }

    @Override
    public Boolean isInitialized() {
        return this.knnLibrary.isInitialized();
    }

    @Override
    public void setInitialized(Boolean isInitialized) {
        this.knnLibrary.setInitialized(isInitialized);
    }

    @Override
    public List<String> mmapFileExtensions() {
        return this.knnLibrary.mmapFileExtensions();
    }

    @Override
    public ResolvedMethodContext resolveMethod(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext, boolean shouldRequireTraining, SpaceType spaceType) {
        return this.knnLibrary.resolveMethod(knnMethodContext, knnMethodConfigContext, shouldRequireTraining, spaceType);
    }

    static {
        DEFAULT = FAISS;
        CUSTOM_SEGMENT_FILE_ENGINES = ImmutableSet.of((Object)NMSLIB, (Object)FAISS);
        ENGINES_SUPPORTING_FILTERS = ImmutableSet.of((Object)LUCENE, (Object)FAISS);
        ENGINES_SUPPORTING_RADIAL_SEARCH = ImmutableSet.of((Object)LUCENE, (Object)FAISS);
        ENGINES_SUPPORTING_MULTI_VECTORS = ImmutableSet.of((Object)LUCENE, (Object)FAISS);
        MAX_DIMENSIONS_BY_ENGINE = Map.of(NMSLIB, 16000, FAISS, 16000, LUCENE, 16000);
    }
}

