/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.AbstractKNNMethod;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNLibrarySearchContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.faiss.FaissFP16Util;
import org.opensearch.knn.index.engine.faiss.MethodAsMapBuilder;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;

public abstract class AbstractFaissMethod
extends AbstractKNNMethod {
    public AbstractFaissMethod(MethodComponent methodComponent, Set<SpaceType> spaces, KNNLibrarySearchContext knnLibrarySearchContext) {
        super(methodComponent, spaces, knnLibrarySearchContext);
    }

    @Override
    protected PerDimensionValidator doGetPerDimensionValidator(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        VectorDataType vectorDataType = knnMethodConfigContext.getVectorDataType();
        if (VectorDataType.BINARY == vectorDataType) {
            return PerDimensionValidator.DEFAULT_BIT_VALIDATOR;
        }
        if (VectorDataType.BYTE == vectorDataType) {
            return PerDimensionValidator.DEFAULT_BYTE_VALIDATOR;
        }
        if (VectorDataType.FLOAT == vectorDataType) {
            if (FaissFP16Util.isFaissSQfp16(knnMethodContext.getMethodComponentContext())) {
                return FaissFP16Util.FP16_VALIDATOR;
            }
            return PerDimensionValidator.DEFAULT_FLOAT_VALIDATOR;
        }
        throw new IllegalStateException("Unsupported vector data type " + String.valueOf((Object)vectorDataType));
    }

    @Override
    protected PerDimensionProcessor doGetPerDimensionProcessor(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        VectorDataType vectorDataType = knnMethodConfigContext.getVectorDataType();
        if (VectorDataType.BINARY == vectorDataType) {
            return PerDimensionProcessor.NOOP_PROCESSOR;
        }
        if (VectorDataType.BYTE == vectorDataType) {
            return PerDimensionProcessor.NOOP_PROCESSOR;
        }
        if (VectorDataType.FLOAT == vectorDataType) {
            if (FaissFP16Util.isFaissSQClipToFP16RangeEnabled(knnMethodContext.getMethodComponentContext())) {
                return FaissFP16Util.CLIP_TO_FP16_PROCESSOR;
            }
            return PerDimensionProcessor.NOOP_PROCESSOR;
        }
        throw new IllegalStateException("Unsupported vector data type " + String.valueOf((Object)vectorDataType));
    }

    static KNNLibraryIndexingContext adjustIndexDescription(MethodAsMapBuilder methodAsMapBuilder, MethodComponentContext methodComponentContext, KNNMethodConfigContext knnMethodConfigContext) {
        String indexDescription;
        String prefix = "";
        MethodComponentContext encoderContext = AbstractFaissMethod.getEncoderMethodComponent(methodComponentContext);
        if (encoderContext != null && Objects.equals(encoderContext.getName(), "binary")) {
            prefix = "B";
        }
        if (knnMethodConfigContext.getVectorDataType() == VectorDataType.BINARY) {
            prefix = "B";
        }
        if (knnMethodConfigContext.getVectorDataType() == VectorDataType.BYTE && StringUtils.isNotEmpty((String)(indexDescription = methodAsMapBuilder.indexDescription))) {
            StringBuilder indexDescriptionBuilder = new StringBuilder();
            indexDescriptionBuilder.append(indexDescription.split(",")[0]);
            indexDescriptionBuilder.append(",");
            indexDescriptionBuilder.append("SQ8_direct_signed");
            methodAsMapBuilder.indexDescription = indexDescriptionBuilder.toString();
        }
        methodAsMapBuilder.indexDescription = prefix + methodAsMapBuilder.indexDescription;
        return methodAsMapBuilder.build();
    }

    static MethodComponentContext getEncoderMethodComponent(MethodComponentContext methodComponentContext) {
        if (!methodComponentContext.getParameters().containsKey("encoder")) {
            return null;
        }
        Object object = methodComponentContext.getParameters().get("encoder");
        if (!(object instanceof MethodComponentContext)) {
            return null;
        }
        return (MethodComponentContext)object;
    }
}

