/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import com.google.common.collect.ImmutableSet;
import io.skylite.common.TriFunction;
import java.util.Objects;
import java.util.Set;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.Parameter;
import org.opensearch.knn.index.engine.faiss.AbstractFaissPQEncoder;
import org.opensearch.knn.index.engine.faiss.MethodAsMapBuilder;

public class FaissHNSWPQEncoder
extends AbstractFaissPQEncoder {
    private static final Set<VectorDataType> SUPPORTED_DATA_TYPES = ImmutableSet.of((Object)((Object)VectorDataType.FLOAT));
    private static final MethodComponent METHOD_COMPONENT = MethodComponent.Builder.builder("pq").addSupportedDataTypes(SUPPORTED_DATA_TYPES).addParameter("m", new Parameter.IntegerParameter("m", KNNConstants.ENCODER_PARAMETER_PQ_CODE_COUNT_DEFAULT, (v, context) -> {
        boolean isValueGreaterThan0 = v > 0;
        boolean isValueLessThanCodeCountLimit = v < KNNConstants.ENCODER_PARAMETER_PQ_CODE_COUNT_LIMIT;
        boolean isDimensionDivisibleByValue = context.getDimension() % v == 0;
        return isValueGreaterThan0 && isValueLessThanCodeCountLimit && isDimensionDivisibleByValue;
    })).addParameter("code_size", new Parameter.IntegerParameter("code_size", KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_DEFAULT, (v, context) -> Objects.equals(v, KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_DEFAULT))).setRequiresTraining(true).setKnnLibraryIndexingContextGenerator((TriFunction<MethodComponent, MethodComponentContext, KNNMethodConfigContext, KNNLibraryIndexingContext>)((TriFunction)(methodComponent, methodComponentContext, knnMethodConfigContext) -> MethodAsMapBuilder.builder("PQ", methodComponent, methodComponentContext, knnMethodConfigContext).addParameter("m", "", "").build())).setOverheadInKBEstimator((TriFunction<MethodComponent, MethodComponentContext, Integer, Long>)((TriFunction)(methodComponent, methodComponentContext, dimension) -> {
        int codeSize = KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_DEFAULT;
        return 4L * (1L << codeSize) * (long)dimension.intValue() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L;
    })).build();

    @Override
    public MethodComponent getMethodComponent() {
        return METHOD_COMPONENT;
    }
}

