/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import com.google.common.collect.ImmutableSet;
import io.skylite.common.TriFunction;
import io.skylite.common.ValidationException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.Encoder;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContextImpl;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.Parameter;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.quantization.enums.ScalarQuantizationType;

public class QFrameBitEncoder
implements Encoder {
    public static final String NAME = "binary";
    public static final String BITCOUNT_PARAM = "bits";
    private static final int DEFAULT_BITS = 1;
    private static final Set<Integer> validBitCounts = ImmutableSet.of((Object)1, (Object)2, (Object)4);
    private static final Set<VectorDataType> SUPPORTED_DATA_TYPES = ImmutableSet.of((Object)((Object)VectorDataType.FLOAT));
    private static final MethodComponent METHOD_COMPONENT = MethodComponent.Builder.builder("binary").addSupportedDataTypes(SUPPORTED_DATA_TYPES).addParameter("bits", new Parameter.IntegerParameter("bits", 1, (v, context) -> validBitCounts.contains(v))).setKnnLibraryIndexingContextGenerator((TriFunction<MethodComponent, MethodComponentContext, KNNMethodConfigContext, KNNLibraryIndexingContext>)((TriFunction)(methodComponent, methodComponentContext, knnMethodConfigContext) -> {
        QuantizationConfig quantizationConfig;
        int bitCount = (Integer)methodComponentContext.getParameters().getOrDefault(BITCOUNT_PARAM, 1);
        if (bitCount == 1) {
            quantizationConfig = QuantizationConfig.builder().quantizationType(ScalarQuantizationType.ONE_BIT).build();
        } else if (bitCount == 2) {
            quantizationConfig = QuantizationConfig.builder().quantizationType(ScalarQuantizationType.TWO_BIT).build();
        } else if (bitCount == 4) {
            quantizationConfig = QuantizationConfig.builder().quantizationType(ScalarQuantizationType.FOUR_BIT).build();
        } else {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid bit count: %d", bitCount));
        }
        return KNNLibraryIndexingContextImpl.builder().quantizationConfig(quantizationConfig).parameters((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("index_description", "Flat");
            }
        }).build();
    })).setRequiresTraining(false).build();

    @Override
    public MethodComponent getMethodComponent() {
        return METHOD_COMPONENT;
    }

    @Override
    public CompressionLevel calculateCompressionLevel(MethodComponentContext methodComponentContext, KNNMethodConfigContext knnMethodConfigContext) {
        if (!methodComponentContext.getParameters().containsKey(BITCOUNT_PARAM)) {
            return CompressionLevel.NOT_CONFIGURED;
        }
        Object value = methodComponentContext.getParameters().get(BITCOUNT_PARAM);
        ValidationException validationException = METHOD_COMPONENT.getParameters().get(BITCOUNT_PARAM).validate(value, knnMethodConfigContext);
        if (validationException != null) {
            throw validationException;
        }
        Integer bitCount = (Integer)value;
        if (bitCount == 1) {
            return CompressionLevel.x32;
        }
        if (bitCount == 2) {
            return CompressionLevel.x16;
        }
        return CompressionLevel.x8;
    }
}

