/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import com.google.common.annotations.VisibleForTesting;
import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.Explicit;
import io.skylite.common.ValidationException;
import io.skylite.core.common.Strings;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.common.KNNValidationUtil;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.VectorField;
import org.opensearch.knn.index.engine.EngineResolver;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.ResolvedMethodContext;
import org.opensearch.knn.index.engine.SpaceTypeResolver;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.FlatVectorFieldMapper;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.mapper.LuceneFieldMapper;
import org.opensearch.knn.index.mapper.MethodFieldMapper;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.mapper.ModelFieldMapper;
import org.opensearch.knn.index.mapper.OriginalMappingParameters;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.VectorValidator;
import org.opensearch.knn.indices.ModelDao;

public abstract class KNNVectorFieldMapper
extends FieldMapper {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNVectorFieldMapper.class);
    public static final String CONTENT_TYPE = "knn_vector";
    public static final String KNN_FIELD = "knn_field";
    @VisibleForTesting
    public static final String[] MAPPING_COMPRESSION_NAMES_ARRAY = new String[]{CompressionLevel.NOT_CONFIGURED.getName(), CompressionLevel.x1.getName(), CompressionLevel.x2.getName(), CompressionLevel.x4.getName(), CompressionLevel.x8.getName(), CompressionLevel.x16.getName(), CompressionLevel.x32.getName()};
    protected Version indexCreatedVersion;
    protected Settings indexSettings;
    protected Explicit<Boolean> ignoreMalformed;
    protected boolean stored;
    protected boolean hasDocValues;
    protected VectorDataType vectorDataType;
    protected ModelDao modelDao;
    protected boolean useLuceneBasedVectorField;
    protected FieldType fieldType;
    protected OriginalMappingParameters originalMappingParameters;

    private static KNNVectorFieldMapper toType(FieldMapper in) {
        return (KNNVectorFieldMapper)in;
    }

    static boolean useKNNMethodContextFromLegacy(Builder builder, MappingParserContext parserContext) {
        return parserContext.indexVersionCreated().onOrBefore((Version)OpenSearchVersion.fromId((int)2170299)) && builder.originalParameters.isLegacyMapping();
    }

    public KNNVectorFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, Version<?> indexCreatedVersion, OriginalMappingParameters originalMappingParameters, Settings indexSettings) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.stored = stored;
        this.hasDocValues = hasDocValues;
        this.vectorDataType = mappedFieldType.getVectorDataType();
        this.updateEngineStats();
        this.indexCreatedVersion = indexCreatedVersion;
        this.originalMappingParameters = originalMappingParameters;
        this.indexSettings = indexSettings;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        this.parseCreateField(context, this.fieldType().getKnnMappingConfig().getDimension(), this.fieldType().getVectorDataType());
    }

    private Field createVectorField(float[] vectorValue) {
        if (this.useLuceneBasedVectorField) {
            return new KnnFloatVectorField(this.name(), vectorValue, this.fieldType);
        }
        return new VectorField(this.name(), vectorValue, (IndexableFieldType)this.fieldType);
    }

    private Field createVectorField(byte[] vectorValue) {
        if (this.useLuceneBasedVectorField) {
            return new KnnByteVectorField(this.name(), vectorValue, this.fieldType);
        }
        return new VectorField(this.name(), vectorValue, (IndexableFieldType)this.fieldType);
    }

    protected List<Field> getFieldsForFloatVector(float[] array) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(this.createVectorField(array));
        if (this.stored) {
            fields.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForFloatVector(this.name(), array));
        }
        return fields;
    }

    protected List<Field> getFieldsForByteVector(byte[] array) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(this.createVectorField(array));
        if (this.stored) {
            fields.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForByteVector(this.name(), array));
        }
        return fields;
    }

    protected void validatePreparse() {
        KNNVectorFieldMapperUtil.validateIfKNNPluginEnabled();
        KNNVectorFieldMapperUtil.validateIfCircuitBreakerIsNotTriggered();
    }

    protected abstract VectorValidator getVectorValidator();

    protected abstract PerDimensionValidator getPerDimensionValidator();

    protected abstract PerDimensionProcessor getPerDimensionProcessor();

    protected void parseCreateField(ParseContext context, int dimension, VectorDataType vectorDataType) throws IOException {
        this.validatePreparse();
        if (VectorDataType.BINARY == vectorDataType || VectorDataType.BYTE == vectorDataType) {
            Optional<byte[]> bytesArrayOptional = this.getBytesFromContext(context, dimension, vectorDataType);
            if (bytesArrayOptional.isEmpty()) {
                return;
            }
            byte[] array = bytesArrayOptional.get();
            this.getVectorValidator().validateVector(array);
            context.doc().addAll(this.getFieldsForByteVector(array));
        } else if (VectorDataType.FLOAT == vectorDataType) {
            Optional<float[]> floatsArrayOptional = this.getFloatsFromContext(context, dimension);
            if (floatsArrayOptional.isEmpty()) {
                return;
            }
            float[] array = floatsArrayOptional.get();
            this.getVectorValidator().validateVector(array);
            context.doc().addAll(this.getFieldsForFloatVector(array));
        } else {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot parse context for unsupported values provided for field [%s]", "data_type"));
        }
        context.path().remove();
    }

    Optional<byte[]> getBytesFromContext(ParseContext context, int dimension, VectorDataType dataType) throws IOException {
        context.path().add(this.simpleName());
        PerDimensionValidator perDimensionValidator = this.getPerDimensionValidator();
        PerDimensionProcessor perDimensionProcessor = this.getPerDimensionProcessor();
        ArrayList<Byte> vector = new ArrayList<Byte>();
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                value = perDimensionProcessor.processByte(context.parser().floatValue());
                perDimensionValidator.validateByte(value);
                vector.add((byte)value);
                token = context.parser().nextToken();
            }
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = perDimensionProcessor.processByte(context.parser().floatValue());
            perDimensionValidator.validateByte(value);
            vector.add((byte)value);
            context.parser().nextToken();
        } else if (token == XContentParser.Token.VALUE_NULL) {
            context.path().remove();
            return Optional.empty();
        }
        KNNValidationUtil.validateVectorDimension(dimension, vector.size(), dataType);
        byte[] array = new byte[vector.size()];
        int i = 0;
        for (Byte f : vector) {
            array[i++] = f;
        }
        return Optional.of(array);
    }

    Optional<float[]> getFloatsFromContext(ParseContext context, int dimension) throws IOException {
        context.path().add(this.simpleName());
        PerDimensionValidator perDimensionValidator = this.getPerDimensionValidator();
        PerDimensionProcessor perDimensionProcessor = this.getPerDimensionProcessor();
        ArrayList<Float> vector = new ArrayList<Float>();
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                value = perDimensionProcessor.process(context.parser().floatValue());
                perDimensionValidator.validate(value);
                vector.add(Float.valueOf(value));
                token = context.parser().nextToken();
            }
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = perDimensionProcessor.process(context.parser().floatValue());
            perDimensionValidator.validate(value);
            vector.add(Float.valueOf(value));
            context.parser().nextToken();
        } else if (token == XContentParser.Token.VALUE_NULL) {
            context.path().remove();
            return Optional.empty();
        }
        KNNValidationUtil.validateVectorDimension(dimension, vector.size(), this.vectorDataType);
        float[] array = new float[vector.size()];
        int i = 0;
        for (Float f : vector) {
            array[i++] = f.floatValue();
        }
        return Optional.of(array);
    }

    public FieldMapper.Builder getMergeBuilder() {
        KNNMethodConfigContext knnMethodConfigContext = this.fieldType().getKnnMappingConfig().getModelId().isPresent() ? null : KNNMethodConfigContext.builder().vectorDataType(this.vectorDataType).versionCreated(this.indexCreatedVersion).dimension(this.fieldType().getKnnMappingConfig().getDimension()).compressionLevel(this.fieldType().getKnnMappingConfig().getCompressionLevel()).mode(this.fieldType().getKnnMappingConfig().getMode()).build();
        return new Builder(this.simpleName(), this.modelDao, this.indexCreatedVersion, knnMethodConfigContext, this.originalMappingParameters, this.indexSettings).init(this);
    }

    public final boolean parsesArrayValue() {
        return true;
    }

    public KNNVectorFieldType fieldType() {
        return (KNNVectorFieldType)super.fieldType();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Boolean)this.ignoreMalformed.value());
        }
    }

    void updateEngineStats() {
    }

    public static class Builder
    extends FieldMapper.Builder {
        protected Boolean ignoreMalformed;
        protected Settings indexSettings;
        protected final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> KNNVectorFieldMapper.toType((FieldMapper)m).stored, (boolean)false);
        protected final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> KNNVectorFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        protected final FieldMapper.Parameter<Integer> dimension = new FieldMapper.Parameter("dimension", false, () -> -1, (n, c, o) -> {
            int value;
            if (o == null) {
                throw new IllegalArgumentException("Dimension cannot be null");
            }
            try {
                value = XContentMapValuesUtil.nodeIntegerValue((Object)o);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to parse [dimension] from provided value [%s] for vector [%s]", o, this.name));
            }
            if (value <= 0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Dimension value must be greater than 0 for vector: %s", this.name));
            }
            return value;
        }, m -> KNNVectorFieldMapper.toType((FieldMapper)m).originalMappingParameters.getDimension());
        protected final FieldMapper.Parameter<VectorDataType> vectorDataType = new FieldMapper.Parameter("data_type", false, () -> KNNConstants.DEFAULT_VECTOR_DATA_TYPE_FIELD, (n, c, o) -> VectorDataType.get((String)o), m -> KNNVectorFieldMapper.toType((FieldMapper)m).originalMappingParameters.getVectorDataType());
        protected final FieldMapper.Parameter<String> modelId = FieldMapper.Parameter.stringParam((String)"model_id", (boolean)false, m -> KNNVectorFieldMapper.toType((FieldMapper)m).originalMappingParameters.getModelId(), null);
        protected final FieldMapper.Parameter<KNNMethodContext> knnMethodContext = new FieldMapper.Parameter("method", false, () -> null, (n, c, o) -> KNNMethodContext.parse(o), m -> KNNVectorFieldMapper.toType((FieldMapper)m).originalMappingParameters.getKnnMethodContext()).setSerializer((b, n, v) -> {
            b.startObject(n);
            v.toXContent(b, ToXContent.EMPTY_PARAMS);
            b.endObject();
        }, m -> m.getMethodComponentContext().getName());
        protected final FieldMapper.Parameter<String> mode = FieldMapper.Parameter.restrictedStringParam((String)"mode", (boolean)false, m -> KNNVectorFieldMapper.toType((FieldMapper)m).originalMappingParameters.getMode(), (String[])Mode.NAMES_ARRAY).acceptsNull();
        protected final FieldMapper.Parameter<String> compressionLevel = FieldMapper.Parameter.restrictedStringParam((String)"compression_level", (boolean)false, m -> KNNVectorFieldMapper.toType((FieldMapper)m).originalMappingParameters.getCompressionLevel(), (String[])MAPPING_COMPRESSION_NAMES_ARRAY).acceptsNull();
        protected final FieldMapper.Parameter<String> topLevelSpaceType = FieldMapper.Parameter.stringParam((String)"space_type", (boolean)false, m -> KNNVectorFieldMapper.toType((FieldMapper)m).originalMappingParameters.getTopLevelSpaceType(), (String)SpaceType.UNDEFINED.getValue()).setValidator(SpaceType::getSpace);
        protected final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        protected ModelDao modelDao;
        protected Version indexCreatedVersion;
        private KNNMethodConfigContext knnMethodConfigContext;
        private OriginalMappingParameters originalParameters;

        public Builder(String name, ModelDao modelDao, Version<?> indexCreatedVersion, KNNMethodConfigContext knnMethodConfigContext, OriginalMappingParameters originalParameters, Settings indexSettings) {
            super(name);
            this.modelDao = modelDao;
            this.indexCreatedVersion = indexCreatedVersion;
            this.knnMethodConfigContext = knnMethodConfigContext;
            this.originalParameters = originalParameters;
            this.indexSettings = indexSettings;
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.stored, this.hasDocValues, this.dimension, this.vectorDataType, this.meta, this.knnMethodContext, this.modelId, this.mode, this.compressionLevel, this.topLevelSpaceType);
        }

        protected Explicit<Boolean> ignoreMalformed(ContentPath contentPath, Settings indexSettings) {
            if (this.ignoreMalformed != null) {
                return new Explicit((Object)this.ignoreMalformed, true);
            }
            if (indexSettings != null) {
                return new Explicit((Object)((Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(indexSettings)), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public KNNVectorFieldMapper build(ContentPath contentPath) {
            this.validateFullFieldName(contentPath);
            FieldMapper.MultiFields multiFieldsBuilder = this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath);
            FieldMapper.CopyTo copyToBuilder = this.copyTo.build();
            Explicit<Boolean> ignoreMalformed = this.ignoreMalformed(contentPath, this.indexSettings);
            Map metaValue = (Map)this.meta.getValue();
            if (this.modelId.get() != null) {
                return ModelFieldMapper.createFieldMapper(this.buildFullName(contentPath), this.name, metaValue, (VectorDataType)((Object)this.vectorDataType.getValue()), multiFieldsBuilder, copyToBuilder, ignoreMalformed, (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), this.modelDao, this.indexCreatedVersion, this.indexSettings, this.originalParameters, this.knnMethodConfigContext);
            }
            if (this.originalParameters.getResolvedKnnMethodContext() == null) {
                return FlatVectorFieldMapper.createFieldMapper(this.buildFullName(contentPath), this.name, metaValue, KNNMethodConfigContext.builder().vectorDataType((VectorDataType)((Object)this.vectorDataType.getValue())).versionCreated(this.indexCreatedVersion).dimension((Integer)this.dimension.getValue()).build(), multiFieldsBuilder, copyToBuilder, ignoreMalformed, (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), this.originalParameters, this.indexSettings);
            }
            if (this.originalParameters.getResolvedKnnMethodContext().getKnnEngine() == KNNEngine.LUCENE) {
                log.debug(String.format(Locale.ROOT, "Use [LuceneFieldMapper] mapper for field [%s]", this.name));
                LuceneFieldMapper.CreateLuceneFieldMapperInput createLuceneFieldMapperInput = LuceneFieldMapper.CreateLuceneFieldMapperInput.builder().name(this.name).multiFields(multiFieldsBuilder).copyTo(copyToBuilder).ignoreMalformed(ignoreMalformed).stored((Boolean)this.stored.getValue()).hasDocValues((Boolean)this.hasDocValues.getValue()).originalKnnMethodContext((KNNMethodContext)this.knnMethodContext.get()).build();
                return LuceneFieldMapper.createFieldMapper(this.buildFullName(contentPath), metaValue, this.knnMethodConfigContext, createLuceneFieldMapperInput, this.originalParameters);
            }
            return MethodFieldMapper.createFieldMapper(this.buildFullName(contentPath), this.name, metaValue, this.knnMethodConfigContext, multiFieldsBuilder, copyToBuilder, ignoreMalformed, (Boolean)this.stored.getValue(), (Boolean)this.hasDocValues.getValue(), this.originalParameters);
        }

        private void validateFullFieldName(ContentPath contentPath) {
            String fullFieldName = this.buildFullName(contentPath);
            for (char ch : fullFieldName.toCharArray()) {
                if (!Strings.INVALID_FILENAME_CHARS.contains(Character.valueOf(ch))) continue;
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Vector field name must not include invalid characters of %s. Provided field name=[%s] had a disallowed character [%c]", Strings.INVALID_FILENAME_CHARS.stream().map(c -> "'" + c + "'").collect(Collectors.toList()), fullFieldName, Character.valueOf(ch)));
            }
        }

        @Generated
        public void setKnnMethodConfigContext(KNNMethodConfigContext knnMethodConfigContext) {
            this.knnMethodConfigContext = knnMethodConfigContext;
        }

        @Generated
        public KNNMethodConfigContext getKnnMethodConfigContext() {
            return this.knnMethodConfigContext;
        }

        @Generated
        public void setOriginalParameters(OriginalMappingParameters originalParameters) {
            this.originalParameters = originalParameters;
        }

        @Generated
        public OriginalMappingParameters getOriginalParameters() {
            return this.originalParameters;
        }
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit((Object)false, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.putAttribute(KNNVectorFieldMapper.KNN_FIELD, "true");
            FIELD_TYPE.freeze();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private Supplier<ModelDao> modelDaoSupplier;

        public TypeParser(Supplier<ModelDao> modelDaoSupplier) {
            this.modelDaoSupplier = modelDaoSupplier;
        }

        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, this.modelDaoSupplier.get(), parserContext.indexVersionCreated(), null, null, parserContext.getSettings());
            builder.parse(name, parserContext, node);
            builder.setOriginalParameters(new OriginalMappingParameters(builder));
            if (builder.knnMethodContext.get() != null && builder.modelId.get() != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Method and model can not be both specified in the mapping: %s", name));
            }
            if (this.isKNNDisabled(parserContext.getSettings())) {
                this.validateFromFlat(builder);
            } else if (builder.modelId.get() != null) {
                this.validateFromModel(builder);
            } else {
                this.validateModeAndCompressionForDataType(builder);
                SpaceType resolvedSpaceType = SpaceTypeResolver.INSTANCE.resolveSpaceType(builder.originalParameters.getKnnMethodContext(), (VectorDataType)((Object)builder.vectorDataType.get()), (String)builder.topLevelSpaceType.get());
                this.setSpaceType(builder.originalParameters.getKnnMethodContext(), resolvedSpaceType);
                this.validateSpaceType(builder);
                this.resolveKNNMethodComponents(builder, parserContext, resolvedSpaceType);
                this.validateFromKNNMethod(builder);
            }
            return builder;
        }

        private void validateSpaceType(Builder builder) {
            KNNMethodContext knnMethodContext = (KNNMethodContext)builder.knnMethodContext.get();
            if (knnMethodContext != null) {
                SpaceType knnMethodContextSpaceType = knnMethodContext.getSpaceType();
                SpaceType topLevelSpaceType = SpaceType.getSpace((String)builder.topLevelSpaceType.get());
                if (topLevelSpaceType != SpaceType.UNDEFINED && topLevelSpaceType != knnMethodContextSpaceType && knnMethodContextSpaceType != SpaceType.UNDEFINED) {
                    throw new MapperParsingException("Space type in \"method\" and top level space type should be same or one of them should be defined");
                }
            }
        }

        private void validateModeAndCompressionForDataType(Builder builder) {
            boolean isModeOrCompressionConfigured;
            boolean bl = isModeOrCompressionConfigured = builder.mode.isConfigured() || builder.compressionLevel.isConfigured();
            if (isModeOrCompressionConfigured && builder.vectorDataType.getValue() != VectorDataType.FLOAT) {
                throw new MapperParsingException(String.format(Locale.ROOT, "Compression and mode cannot be used for non-float32 data type for field %s", builder.name));
            }
        }

        private void validateFromFlat(Builder builder) {
            if (builder.modelId.get() != null || builder.knnMethodContext.get() != null) {
                throw new IllegalArgumentException("Cannot set modelId or method parameters when index.knn setting is false");
            }
            this.validateDimensionSet(builder);
            this.validateCompressionAndModeNotSet(builder, builder.name(), "flat");
        }

        private void validateFromModel(Builder builder) {
            if ((Integer)builder.dimension.getValue() == -1 && builder.modelId.get() == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Dimension value missing for vector: %s", builder.name()));
            }
            if (builder.modelId.get() != null && SpaceType.getSpace((String)builder.topLevelSpaceType.get()) != SpaceType.UNDEFINED) {
                throw new IllegalArgumentException("TopLevel Space type and model can not be both specified in the mapping");
            }
            this.validateCompressionAndModeNotSet(builder, builder.name(), "model");
        }

        private void validateFromKNNMethod(Builder builder) {
            ValidationException validationException;
            if (builder.originalParameters.getResolvedKnnMethodContext().isTrainingRequired()) {
                ValidationException validationException2 = new ValidationException();
                validationException2.addValidationError(String.format(Locale.ROOT, "\"%s\" requires training.", "method"));
                throw validationException2;
            }
            if (builder.originalParameters.getResolvedKnnMethodContext() != null && (validationException = builder.originalParameters.getResolvedKnnMethodContext().validate(builder.knnMethodConfigContext)) != null) {
                throw validationException;
            }
            this.validateDimensionSet(builder);
        }

        private void validateDimensionSet(Builder builder) {
            if ((Integer)builder.dimension.getValue() == -1) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Dimension value missing for vector: %s", builder.name()));
            }
        }

        private void validateCompressionAndModeNotSet(Builder builder, String name, String context) {
            if (builder.mode.isConfigured() || builder.compressionLevel.isConfigured()) {
                throw new MapperParsingException(String.format(Locale.ROOT, "Compression and mode can not be specified in a %s mapping configuration for field: %s", context, name));
            }
        }

        private void resolveKNNMethodComponents(Builder builder, MappingParserContext parserContext, SpaceType resolvedSpaceType) {
            builder.setKnnMethodConfigContext(KNNMethodConfigContext.builder().vectorDataType(builder.originalParameters.getVectorDataType()).versionCreated(parserContext.indexVersionCreated()).dimension(builder.originalParameters.getDimension()).mode(Mode.fromName(builder.originalParameters.getMode())).compressionLevel(CompressionLevel.fromName(builder.originalParameters.getCompressionLevel())).build());
            if (KNNVectorFieldMapper.useKNNMethodContextFromLegacy(builder, parserContext)) {
                builder.originalParameters.setResolvedKnnMethodContext(KNNVectorFieldMapperUtil.createKNNMethodContextFromLegacy(parserContext.getSettings(), parserContext.indexVersionCreated(), resolvedSpaceType));
            }
            KNNEngine resolvedKNNEngine = EngineResolver.INSTANCE.resolveEngine(builder.knnMethodConfigContext, builder.originalParameters.getResolvedKnnMethodContext(), false);
            this.setEngine(builder.originalParameters.getResolvedKnnMethodContext(), resolvedKNNEngine);
            ResolvedMethodContext resolvedMethodContext = resolvedKNNEngine.resolveMethod(builder.originalParameters.getResolvedKnnMethodContext(), builder.knnMethodConfigContext, false, resolvedSpaceType);
            builder.originalParameters.setResolvedKnnMethodContext(resolvedMethodContext.getKnnMethodContext());
            builder.knnMethodConfigContext.setCompressionLevel(resolvedMethodContext.getCompressionLevel());
        }

        private boolean isKNNDisabled(Settings settings) {
            boolean isSettingPresent = KNNSettings.IS_KNN_INDEX_SETTING.exists(settings);
            return !isSettingPresent || (Boolean)KNNSettings.IS_KNN_INDEX_SETTING.get(settings) == false;
        }

        private void setSpaceType(KNNMethodContext knnMethodContext, SpaceType spaceType) {
            if (knnMethodContext == null) {
                return;
            }
            knnMethodContext.setSpaceType(spaceType);
        }

        private void setEngine(KNNMethodContext knnMethodContext, KNNEngine knnEngine) {
            if (knnMethodContext == null || knnMethodContext.isEngineConfigured()) {
                return;
            }
            knnMethodContext.setKnnEngine(knnEngine);
        }
    }
}

