/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.iterators;

import io.skylite.common.Nullable;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.iterators.KNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNByteVectorValues;

public class ByteVectorIdsKNNIterator
implements KNNIterator {
    protected final DocIdSetIterator filterIdsIterator;
    protected final float[] queryVector;
    protected final KNNByteVectorValues byteVectorValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;

    public ByteVectorIdsKNNIterator(@Nullable DocIdSetIterator filterIdsIterator, float[] queryVector, KNNByteVectorValues byteVectorValues, SpaceType spaceType) throws IOException {
        this.filterIdsIterator = filterIdsIterator;
        this.queryVector = queryVector;
        this.byteVectorValues = byteVectorValues;
        this.spaceType = spaceType;
        this.docId = this.getNextDocId();
    }

    public ByteVectorIdsKNNIterator(float[] queryVector, KNNByteVectorValues byteVectorValues, SpaceType spaceType) throws IOException {
        this(null, queryVector, byteVectorValues, spaceType);
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = this.computeScore();
        int currentDocId = this.docId;
        this.docId = this.getNextDocId();
        return currentDocId;
    }

    @Override
    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        byte[] vector = this.byteVectorValues.getVector();
        byte[] byteQueryVector = new byte[this.queryVector.length];
        for (int i = 0; i < this.queryVector.length; ++i) {
            byteQueryVector[i] = (byte)this.queryVector[i];
        }
        return this.spaceType.getKnnVectorSimilarityFunction().compare(byteQueryVector, vector);
    }

    protected int getNextDocId() throws IOException {
        if (this.filterIdsIterator == null) {
            return this.byteVectorValues.nextDoc();
        }
        int nextDocID = this.filterIdsIterator.nextDoc();
        if (nextDocID != Integer.MAX_VALUE) {
            this.byteVectorValues.advance(nextDocID);
        }
        return nextDocID;
    }
}

