/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.iterators;

import io.skylite.common.Nullable;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.index.query.SegmentLevelQuantizationUtil;
import org.opensearch.knn.index.query.iterators.KNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;

public class VectorIdsKNNIterator
implements KNNIterator {
    protected final DocIdSetIterator filterIdsIterator;
    protected final float[] queryVector;
    private final byte[] quantizedQueryVector;
    protected final KNNFloatVectorValues knnFloatVectorValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;
    private final SegmentLevelQuantizationInfo segmentLevelQuantizationInfo;

    public VectorIdsKNNIterator(@Nullable DocIdSetIterator filterIdsIterator, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType) throws IOException {
        this(filterIdsIterator, queryVector, knnFloatVectorValues, spaceType, null, null);
    }

    public VectorIdsKNNIterator(float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType) throws IOException {
        this(null, queryVector, knnFloatVectorValues, spaceType, null, null);
    }

    public VectorIdsKNNIterator(@Nullable DocIdSetIterator filterIdsIterator, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, byte[] quantizedQueryVector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) throws IOException {
        this.filterIdsIterator = filterIdsIterator;
        this.queryVector = queryVector;
        this.knnFloatVectorValues = knnFloatVectorValues;
        this.spaceType = spaceType;
        this.docId = this.getNextDocId();
        this.quantizedQueryVector = quantizedQueryVector;
        this.segmentLevelQuantizationInfo = segmentLevelQuantizationInfo;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = this.computeScore();
        int currentDocId = this.docId;
        this.docId = this.getNextDocId();
        return currentDocId;
    }

    @Override
    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        float[] vector = this.knnFloatVectorValues.getVector();
        if (this.segmentLevelQuantizationInfo != null && this.quantizedQueryVector != null) {
            byte[] quantizedVector = SegmentLevelQuantizationUtil.quantizeVector(vector, this.segmentLevelQuantizationInfo);
            return SpaceType.HAMMING.getKnnVectorSimilarityFunction().compare(this.quantizedQueryVector, quantizedVector);
        }
        return this.spaceType.getKnnVectorSimilarityFunction().compare(this.queryVector, vector);
    }

    protected int getNextDocId() throws IOException {
        if (this.filterIdsIterator == null) {
            return this.knnFloatVectorValues.nextDoc();
        }
        int nextDocID = this.filterIdsIterator.nextDoc();
        if (nextDocID != Integer.MAX_VALUE) {
            this.knnFloatVectorValues.advance(nextDocID);
        }
        return nextDocID;
    }
}

