/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.rescore;

import lombok.Generated;

public final class RescoreContext {
    public static final float DEFAULT_OVERSAMPLE_FACTOR = 1.0f;
    public static final float MAX_OVERSAMPLE_FACTOR = 100.0f;
    public static final float MIN_OVERSAMPLE_FACTOR = 1.0f;
    public static final int MAX_FIRST_PASS_RESULTS = 10000;
    public static final int DIMENSION_THRESHOLD = 1000;
    public static final float OVERSAMPLE_FACTOR_BELOW_DIMENSION_THRESHOLD = 5.0f;
    public static final int DIMENSION_THRESHOLD_1000 = 1000;
    public static final int DIMENSION_THRESHOLD_768 = 768;
    public static final float OVERSAMPLE_FACTOR_1000 = 1.0f;
    public static final float OVERSAMPLE_FACTOR_768 = 2.0f;
    public static final float OVERSAMPLE_FACTOR_BELOW_768 = 3.0f;
    public static final int MIN_FIRST_PASS_RESULTS = 100;
    private float oversampleFactor;
    private boolean userProvided;

    public static RescoreContext getDefault() {
        return RescoreContext.builder().oversampleFactor(1.0f).userProvided(false).build();
    }

    public int getFirstPassK(int finalK, boolean isShardLevelRescoringEnabled, int dimension) {
        if (!isShardLevelRescoringEnabled && !this.userProvided) {
            this.oversampleFactor = dimension >= 1000 ? 1.0f : (dimension >= 768 ? 2.0f : 3.0f);
        }
        return Math.min(10000, Math.max(100, (int)Math.ceil((float)finalK * this.oversampleFactor)));
    }

    @Generated
    private static float $default$oversampleFactor() {
        return 1.0f;
    }

    @Generated
    private static boolean $default$userProvided() {
        return true;
    }

    @Generated
    public static RescoreContextBuilder builder() {
        return new RescoreContextBuilder();
    }

    @Generated
    public float getOversampleFactor() {
        return this.oversampleFactor;
    }

    @Generated
    public boolean isUserProvided() {
        return this.userProvided;
    }

    @Generated
    public RescoreContext(float oversampleFactor, boolean userProvided) {
        this.oversampleFactor = oversampleFactor;
        this.userProvided = userProvided;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RescoreContext)) {
            return false;
        }
        RescoreContext other = (RescoreContext)o;
        if (Float.compare(this.getOversampleFactor(), other.getOversampleFactor()) != 0) {
            return false;
        }
        return this.isUserProvided() == other.isUserProvided();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getOversampleFactor());
        result = result * 59 + (this.isUserProvided() ? 79 : 97);
        return result;
    }

    @Generated
    public static class RescoreContextBuilder {
        @Generated
        private boolean oversampleFactor$set;
        @Generated
        private float oversampleFactor$value;
        @Generated
        private boolean userProvided$set;
        @Generated
        private boolean userProvided$value;

        @Generated
        RescoreContextBuilder() {
        }

        @Generated
        public RescoreContextBuilder oversampleFactor(float oversampleFactor) {
            this.oversampleFactor$value = oversampleFactor;
            this.oversampleFactor$set = true;
            return this;
        }

        @Generated
        public RescoreContextBuilder userProvided(boolean userProvided) {
            this.userProvided$value = userProvided;
            this.userProvided$set = true;
            return this;
        }

        @Generated
        public RescoreContext build() {
            float oversampleFactor$value = this.oversampleFactor$value;
            if (!this.oversampleFactor$set) {
                oversampleFactor$value = RescoreContext.$default$oversampleFactor();
            }
            boolean userProvided$value = this.userProvided$value;
            if (!this.userProvided$set) {
                userProvided$value = RescoreContext.$default$userProvided();
            }
            return new RescoreContext(oversampleFactor$value, userProvided$value);
        }

        @Generated
        public String toString() {
            return "RescoreContext.RescoreContextBuilder(oversampleFactor$value=" + this.oversampleFactor$value + ", userProvided$value=" + this.userProvided$value + ")";
        }
    }
}

