/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.vectorvalues.VectorValueExtractorStrategy;

public interface KNNVectorValuesIterator {
    public int docId();

    public int advance(int var1) throws IOException;

    public int nextDoc() throws IOException;

    public DocIdSetIterator getDocIdSetIterator();

    public long liveDocs();

    public VectorValueExtractorStrategy getVectorExtractorStrategy();

    public static class FieldWriterIteratorValues<T>
    implements KNNVectorValuesIterator {
        private final DocIdSetIterator docIdSetIterator;
        private final Map<Integer, T> vectors;

        FieldWriterIteratorValues(@NonNull DocsWithFieldSet docsWithFieldSet, @NonNull Map<Integer, T> vectors) {
            if (docsWithFieldSet == null) {
                throw new NullPointerException("docsWithFieldSet is marked non-null but is null");
            }
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            assert (docsWithFieldSet.iterator().cost() == (long)vectors.size());
            this.vectors = vectors;
            this.docIdSetIterator = docsWithFieldSet.iterator();
        }

        @Override
        public int docId() {
            return this.docIdSetIterator.docID();
        }

        @Override
        public int advance(int docId) throws IOException {
            return this.docIdSetIterator.advance(docId);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.docIdSetIterator.nextDoc();
        }

        public T vectorsValue() {
            return this.vectors.get(this.docId());
        }

        @Override
        public DocIdSetIterator getDocIdSetIterator() {
            return this.docIdSetIterator;
        }

        @Override
        public long liveDocs() {
            return this.docIdSetIterator.cost();
        }

        @Override
        public VectorValueExtractorStrategy getVectorExtractorStrategy() {
            return new VectorValueExtractorStrategy.FieldWriterIteratorVectorExtractor();
        }
    }

    public static class DocIdsIteratorValues
    implements KNNVectorValuesIterator {
        protected final DocIdSetIterator docIdSetIterator;
        private KnnVectorValues knnVectorValues = null;
        private int lastOrd = -1;
        private Object lastAccessedVector = null;

        DocIdsIteratorValues(@NonNull KnnVectorValues knnVectorValues) {
            if (knnVectorValues == null) {
                throw new NullPointerException("knnVectorValues is marked non-null but is null");
            }
            this.docIdSetIterator = knnVectorValues.iterator();
            this.knnVectorValues = knnVectorValues;
        }

        DocIdsIteratorValues(DocIdSetIterator docIdSetIterator) {
            this.docIdSetIterator = docIdSetIterator;
        }

        public KnnVectorValues getKnnVectorValues() {
            return this.knnVectorValues;
        }

        @Override
        public int docId() {
            return this.docIdSetIterator.docID();
        }

        @Override
        public int advance(int docId) throws IOException {
            return this.docIdSetIterator.advance(docId);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.docIdSetIterator.nextDoc();
        }

        @Override
        public DocIdSetIterator getDocIdSetIterator() {
            return this.docIdSetIterator;
        }

        @Override
        public long liveDocs() {
            if (this.docIdSetIterator instanceof BinaryDocValues) {
                return KNNCodecUtil.getTotalLiveDocsCount((BinaryDocValues)this.docIdSetIterator);
            }
            if (this.docIdSetIterator instanceof KnnVectorValues.DocIndexIterator) {
                return this.docIdSetIterator.cost();
            }
            throw new IllegalArgumentException("DocIdSetIterator present is not of valid type. Valid types are: BinaryDocValues, FloatVectorValues and ByteVectorValues");
        }

        @Override
        public VectorValueExtractorStrategy getVectorExtractorStrategy() {
            return new VectorValueExtractorStrategy.DISIVectorExtractor();
        }

        @Generated
        public int getLastOrd() {
            return this.lastOrd;
        }

        @Generated
        public void setLastOrd(int lastOrd) {
            this.lastOrd = lastOrd;
        }

        @Generated
        public Object getLastAccessedVector() {
            return this.lastAccessedVector;
        }

        @Generated
        public void setLastAccessedVector(Object lastAccessedVector) {
            this.lastAccessedVector = lastAccessedVector;
        }
    }
}

