/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin;

import com.google.common.collect.ImmutableList;
import io.lucenia.plugins.ActionPlugin;
import io.lucenia.plugins.EnginePlugin;
import io.lucenia.plugins.ExtensiblePlugin;
import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.ScriptPlugin;
import io.lucenia.plugins.SearchPlugin;
import io.lucenia.plugins.SystemIndexPlugin;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.NamedDiff;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.plugins.MapperPlugin;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptEngine;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.threadpool.ExecutorBuilder;
import io.skylite.core.threadpool.FixedExecutorBuilder;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.opensearch.index.IndexModule;
import org.opensearch.index.codec.CodecServiceFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.knn.index.KNNCircuitBreaker;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.codec.KNNCodecService;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.query.KNNWeight;
import org.opensearch.knn.index.query.parser.KNNQueryBuilderParser;
import org.opensearch.knn.index.util.KNNClusterUtil;
import org.opensearch.knn.indices.ModelCache;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelGraveyard;
import org.opensearch.knn.plugin.rest.RestClearCacheHandler;
import org.opensearch.knn.plugin.rest.RestDeleteModelHandler;
import org.opensearch.knn.plugin.rest.RestGetModelHandler;
import org.opensearch.knn.plugin.rest.RestKNNStatsHandler;
import org.opensearch.knn.plugin.rest.RestKNNWarmupHandler;
import org.opensearch.knn.plugin.rest.RestSearchModelHandler;
import org.opensearch.knn.plugin.rest.RestTrainModelHandler;
import org.opensearch.knn.plugin.script.KNNScoringScriptEngine;
import org.opensearch.knn.plugin.stats.KNNStats;
import org.opensearch.knn.plugin.transport.ClearCacheAction;
import org.opensearch.knn.plugin.transport.ClearCacheTransportAction;
import org.opensearch.knn.plugin.transport.DeleteModelAction;
import org.opensearch.knn.plugin.transport.DeleteModelTransportAction;
import org.opensearch.knn.plugin.transport.GetModelAction;
import org.opensearch.knn.plugin.transport.GetModelTransportAction;
import org.opensearch.knn.plugin.transport.KNNStatsAction;
import org.opensearch.knn.plugin.transport.KNNStatsTransportAction;
import org.opensearch.knn.plugin.transport.KNNWarmupAction;
import org.opensearch.knn.plugin.transport.KNNWarmupTransportAction;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheAction;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheTransportAction;
import org.opensearch.knn.plugin.transport.SearchModelAction;
import org.opensearch.knn.plugin.transport.SearchModelTransportAction;
import org.opensearch.knn.plugin.transport.TrainingJobRouteDecisionInfoAction;
import org.opensearch.knn.plugin.transport.TrainingJobRouteDecisionInfoTransportAction;
import org.opensearch.knn.plugin.transport.TrainingJobRouterAction;
import org.opensearch.knn.plugin.transport.TrainingJobRouterTransportAction;
import org.opensearch.knn.plugin.transport.TrainingModelAction;
import org.opensearch.knn.plugin.transport.TrainingModelRequest;
import org.opensearch.knn.plugin.transport.TrainingModelTransportAction;
import org.opensearch.knn.plugin.transport.UpdateModelGraveyardAction;
import org.opensearch.knn.plugin.transport.UpdateModelGraveyardTransportAction;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataAction;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataTransportAction;
import org.opensearch.knn.training.TrainingJobClusterStateListener;
import org.opensearch.knn.training.TrainingJobRunner;
import org.opensearch.knn.training.VectorReader;
import org.opensearch.rest.RestController;
import org.opensearch.watcher.ResourceWatcherService;

public class KNNPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin,
ActionPlugin,
EnginePlugin,
ScriptPlugin,
ExtensiblePlugin,
SystemIndexPlugin {
    public static final String LEGACY_KNN_BASE_URI = "/_opendistro/_knn";
    public static final String KNN_BASE_URI = "/_plugins/_knn";
    private KNNStats knnStats;
    private ClusterService clusterService;

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("knn_vector", new KNNVectorFieldMapper.TypeParser(ModelDao.OpenSearchKNNModelDao::getInstance));
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("knn", KNNQueryBuilder::new, KNNQueryBuilderParser::fromXContent));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.clusterService = clusterService;
        VectorReader vectorReader = new VectorReader(client);
        NativeMemoryLoadStrategy.TrainingLoadStrategy.initialize(vectorReader);
        KNNSettings.state().initialize(client, clusterService);
        KNNClusterUtil.instance().initialize(clusterService);
        ModelDao.OpenSearchKNNModelDao.initialize(client, clusterService, environment.settings());
        ModelCache.initialize(ModelDao.OpenSearchKNNModelDao.getInstance(), clusterService);
        TrainingJobRunner.initialize(threadPool, ModelDao.OpenSearchKNNModelDao.getInstance());
        TrainingJobClusterStateListener.initialize(threadPool, ModelDao.OpenSearchKNNModelDao.getInstance(), clusterService);
        KNNCircuitBreaker.getInstance().initialize(threadPool, clusterService, client);
        KNNQueryBuilder.initialize(ModelDao.OpenSearchKNNModelDao.getInstance());
        KNNWeight.initialize(ModelDao.OpenSearchKNNModelDao.getInstance());
        TrainingModelRequest.initialize(ModelDao.OpenSearchKNNModelDao.getInstance(), clusterService);
        clusterService.addListener((ClusterStateListener)TrainingJobClusterStateListener.getInstance());
        this.knnStats = new KNNStats();
        return ImmutableList.of((Object)this.knnStats);
    }

    public List<Setting<?>> getSettings() {
        return KNNSettings.state().getSettings();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestKNNStatsHandler restKNNStatsHandler = new RestKNNStatsHandler();
        RestKNNWarmupHandler restKNNWarmupHandler = new RestKNNWarmupHandler(settings, restController, this.clusterService, indexNameExpressionResolver);
        RestGetModelHandler restGetModelHandler = new RestGetModelHandler();
        RestDeleteModelHandler restDeleteModelHandler = new RestDeleteModelHandler();
        RestTrainModelHandler restTrainModelHandler = new RestTrainModelHandler();
        RestSearchModelHandler restSearchModelHandler = new RestSearchModelHandler();
        RestClearCacheHandler restClearCacheHandler = new RestClearCacheHandler(this.clusterService, indexNameExpressionResolver);
        return ImmutableList.of((Object)((Object)restKNNStatsHandler), (Object)((Object)restKNNWarmupHandler), (Object)((Object)restGetModelHandler), (Object)((Object)restDeleteModelHandler), (Object)((Object)restTrainModelHandler), (Object)((Object)restSearchModelHandler), (Object)((Object)restClearCacheHandler));
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)KNNStatsAction.INSTANCE, KNNStatsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)KNNWarmupAction.INSTANCE, KNNWarmupTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateModelMetadataAction.INSTANCE, UpdateModelMetadataTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)TrainingJobRouteDecisionInfoAction.INSTANCE, TrainingJobRouteDecisionInfoTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetModelAction.INSTANCE, GetModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteModelAction.INSTANCE, DeleteModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)TrainingJobRouterAction.INSTANCE, TrainingJobRouterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)TrainingModelAction.INSTANCE, TrainingModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RemoveModelFromCacheAction.INSTANCE, RemoveModelFromCacheTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchModelAction.INSTANCE, SearchModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateModelGraveyardAction.INSTANCE, UpdateModelGraveyardTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearCacheAction.INSTANCE, ClearCacheTransportAction.class, new Class[0]));
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        return Optional.empty();
    }

    public Optional<CodecServiceFactory> getCustomCodecServiceFactory(IndexSettings indexSettings) {
        if (((Boolean)indexSettings.getValue(KNNSettings.IS_KNN_INDEX_SETTING)).booleanValue()) {
            return Optional.of(KNNCodecService::new);
        }
        return Optional.empty();
    }

    public void onIndexModule(IndexModule indexModule) {
        KNNSettings.state().onIndexModule(indexModule);
    }

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new KNNScoringScriptEngine();
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return ImmutableList.of((Object)new FixedExecutorBuilder(settings, "training", 1, 1, "knn", false));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "opensearch-knn-blocked-models", ModelGraveyard::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "opensearch-knn-blocked-models", ModelGraveyard::readDiffFrom));
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("opensearch-knn-blocked-models", new String[0]), ModelGraveyard::fromXContent));
        return entries;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return ImmutableList.of((Object)new SystemIndexDescriptor(".lucenia-knn-models", "Index for storing models used for k-NN indices"));
    }
}

